/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.console;

import java.util.ArrayList;
import java.util.List;

public class History {
    private List<String> history = new ArrayList<String>();
    private int maxSize = 500;
    private int currentIndex = 0;

    public void clear() {
        this.history.clear();
        this.currentIndex = 0;
    }

    public void addToHistory(String buffer) {
        if (this.history.size() != 0 && buffer.equals(this.history.get(this.history.size() - 1))) {
            return;
        }
        this.history.add(buffer);
        while (this.history.size() > this.maxSize) {
            this.history.remove(0);
        }
        this.currentIndex = this.history.size();
    }

    public void moveToEnd() {
        this.currentIndex = this.history.size();
    }

    public String current() {
        if (this.currentIndex >= this.history.size()) {
            return "";
        }
        return this.history.get(this.currentIndex);
    }

    public boolean previous() {
        if (this.currentIndex <= 0) {
            return false;
        }
        --this.currentIndex;
        return true;
    }

    public boolean next() {
        if (this.currentIndex >= this.history.size()) {
            return false;
        }
        ++this.currentIndex;
        return true;
    }

    public boolean isHistoryCommand(String line) {
        return line.startsWith("!");
    }

    public String getHistoryCommand(String line) {
        if (!this.isHistoryCommand(line)) {
            return null;
        }
        if ("!!".equals(line) || "!".equals(line)) {
            if (this.history.size() > 1) {
                String historyLine = this.history.get(this.history.size() - 2);
                this.history.set(this.history.size() - 1, historyLine);
                return historyLine;
            }
        } else if (line.startsWith("!") && line.length() > 1) {
            String pattern = line.substring(1);
            int historyPos = -1;
            try {
                historyPos = Integer.parseInt(pattern);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (historyPos >= 0 && historyPos < this.history.size() - 1) {
                String historyLine = this.history.get(historyPos);
                this.history.set(this.history.size() - 1, historyLine);
                return historyLine;
            }
            for (int i = this.history.size() - 2; i >= 0; --i) {
                String historyLine = this.history.get(i);
                if (!historyLine.startsWith(pattern)) continue;
                this.history.set(this.history.size() - 1, historyLine);
                return historyLine;
            }
        }
        return null;
    }

    public String[] getHistory() {
        return this.history.toArray(new String[this.history.size()]);
    }

    public String toString() {
        return this.history.toString();
    }
}

