/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.examples;

import com.sap.jvm.tools.dumps.api.Dump;
import com.sap.jvm.tools.dumps.api.DumpFactory;
import com.sap.jvm.tools.dumps.api.Memory;
import java.io.IOException;

public class BlockFinder {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Incorrect number of arguments: " + args.length);
            return;
        }
        long STEP = 16L;
        long[] minBoundaries = new long[]{0x7F7000000000L, 0x50C000L};
        long[] maxBoundaries = new long[]{140127602999296L, 0xFF1000L};
        Dump dump = DumpFactory.getDump(args[0], args[1]);
        Memory memory = dump.getMemory();
        NullValidator nullValidator = new NullValidator();
        PointerValidator pointerValidator = new PointerValidator(minBoundaries, maxBoundaries, memory);
        long[] staticValues = new long[]{32L, 33L, 48L, 49L, 64L, 65L};
        Validator[] validators = new Validator[]{pointerValidator, pointerValidator, nullValidator, nullValidator, nullValidator, nullValidator};
        long[] counters = new long[staticValues.length];
        long unreadable = 0L;
        for (int i = 0; i < minBoundaries.length; ++i) {
            long min = minBoundaries[i];
            long max = maxBoundaries[i];
            block1: for (long current = min; current < max; current += 16L) {
                if (!BlockFinder.isBlockReadable(memory, current)) {
                    long mask = -4096L;
                    long page = 4096L;
                    current &= mask;
                    current = current + page - 16L;
                    if (++unreadable % 1000L != 0L) continue;
                    System.out.print('-');
                    continue;
                }
                long[] block = new long[]{memory.getInt64(current), memory.getInt64(current + 8L), memory.getInt64(current + 16L), memory.getInt64(current + 24L)};
                for (int j = 0; j < staticValues.length; ++j) {
                    if (block[1] != staticValues[j]) continue;
                    if (!validators[j].validate(block[2]) || !validators[j].validate(block[3])) continue block1;
                    counters[j] = counters[j] + 1L;
                    continue block1;
                }
            }
        }
        System.out.println();
        long sum = 0L;
        long bytes = 0L;
        for (int i = 0; i < staticValues.length; ++i) {
            long mask = -2L;
            long size = staticValues[i] & mask;
            long overallSize = size * counters[i];
            System.out.println("0x" + Long.toHexString(staticValues[i]) + " blocks: " + counters[i] + " (size: " + overallSize + " bytes, " + overallSize / 0x100000L + " MB)");
            sum += counters[i];
            bytes += overallSize;
        }
        System.out.println();
        System.out.println("Found " + sum + " blocks overall consuming " + bytes + " bytes, " + bytes / 0x100000L + " MB.");
    }

    private static boolean isBlockReadable(Memory memory, long address) {
        return memory.isMapped(address, 8) && memory.isMapped(address + 8L, 8) && memory.isMapped(address + 16L, 8) && memory.isMapped(address + 24L, 8);
    }

    private static class PointerValidator
    implements Validator {
        private final long[] minBoundaries;
        private final long[] maxBoundaries;
        private final Memory memory;

        public PointerValidator(long[] minBoundaries, long[] maxBoundaries, Memory memory) {
            this.minBoundaries = minBoundaries;
            this.maxBoundaries = maxBoundaries;
            this.memory = memory;
        }

        @Override
        public boolean validate(long address) {
            boolean inRange = false;
            for (int i = 0; i < this.minBoundaries.length; ++i) {
                inRange |= address > this.minBoundaries[i] && address < this.maxBoundaries[i];
            }
            return inRange && this.memory.isMapped(address, 8);
        }
    }

    private static class NullValidator
    implements Validator {
        private NullValidator() {
        }

        @Override
        public boolean validate(long address) {
            return address == 0L;
        }
    }

    private static interface Validator {
        public boolean validate(long var1);
    }
}

