/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.examples;

import com.sap.jvm.tools.dumps.api.Dump;
import com.sap.jvm.tools.dumps.api.DumpFactory;
import com.sap.jvm.tools.dumps.api.Memory;
import java.io.IOException;

public class MemoryLeakParser {
    public static void main(String[] args) throws IOException {
        long next;
        long previous;
        if (args.length != 3) {
            System.err.println("Incorrect number of arguments: " + args.length);
            return;
        }
        long start = Long.parseLong(args[2], 16);
        long[] min = new long[]{0x7F7000000000L, 0x50C000L};
        long[] max = new long[]{140127602999296L, 0xFF1000L};
        Dump dump = DumpFactory.getDump(args[0], args[1]);
        Memory memory = dump.getMemory();
        long current = start;
        long last = 0L;
        long counter = 0L;
        do {
            if (++counter % 1000L == 0L) {
                System.out.print(counter + " ");
            }
            previous = memory.getInt64(current + 16L);
            next = memory.getInt64(current + 24L);
            if ((previous <= min[0] || previous >= max[0]) && previous <= min[1] && previous >= max[1]) {
                System.err.println();
                System.err.println("previous out of range: current=0x" + Long.toHexString(current) + ", last=0x" + Long.toHexString(last) + ", prev=0x" + Long.toHexString(previous) + ", next=0x" + Long.toHexString(next));
                break;
            }
            if ((next <= min[0] || next >= max[0]) && next <= min[1] && next >= max[1]) {
                System.err.println();
                System.err.println("next out of range: current=0x" + Long.toHexString(current) + ", last=0x" + Long.toHexString(last) + ", prev=0x" + Long.toHexString(previous) + ", next=0x" + Long.toHexString(next));
                break;
            }
            if (last != 0L && next != last) {
                System.err.println();
                System.err.println("Incorrect structure: current=0x" + Long.toHexString(current) + ", last=0x" + Long.toHexString(last) + ", prev=0x" + Long.toHexString(previous) + ", next=0x" + Long.toHexString(next));
            }
            last = current;
        } while ((current = previous) != start);
        System.out.println();
        System.out.println("The queue has " + counter + (current == start ? "" : " previous") + " elements.");
        if (current != start) {
            System.out.println();
            current = start;
            last = 0L;
            counter = 0L;
            do {
                if (++counter % 1000L == 0L) {
                    System.out.print(counter + " ");
                }
                previous = memory.getInt64(current + 16L);
                next = memory.getInt64(current + 24L);
                if ((previous <= min[0] || previous >= max[0]) && previous <= min[1] && previous >= max[1]) {
                    System.err.println();
                    System.err.println("previous out of range: current=0x" + Long.toHexString(current) + ", last=0x" + Long.toHexString(last) + ", prev=0x" + Long.toHexString(previous) + ", next=0x" + Long.toHexString(next));
                    break;
                }
                if ((next <= min[0] || next >= max[0]) && next <= min[1] && next >= max[1]) {
                    System.err.println();
                    System.err.println("next out of range: current=0x" + Long.toHexString(current) + ", last=0x" + Long.toHexString(last) + ", prev=0x" + Long.toHexString(previous) + ", next=0x" + Long.toHexString(next));
                    break;
                }
                if (last != 0L && previous != last) {
                    System.err.println();
                    System.err.println("Incorrect structure: current=0x" + Long.toHexString(current) + ", last=0x" + Long.toHexString(last) + ", prev=0x" + Long.toHexString(previous) + ", next=0x" + Long.toHexString(next));
                }
                last = current;
            } while ((current = next) != start);
            System.out.println();
            System.out.println("The queue has " + counter + " following elements.");
        }
    }
}

