/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.examples;

import com.sap.jvm.tools.dumps.api.Dump;
import com.sap.jvm.tools.dumps.api.DumpFactory;
import com.sap.jvm.tools.dumps.api.Memory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PrintLongestQueue {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Incorrect number of arguments: " + args.length);
            return;
        }
        long[] minBoundaries = new long[]{0x7F7000000000L, 0x50C000L};
        long[] maxBoundaries = new long[]{140127602999296L, 0xFF1000L};
        Dump dump = DumpFactory.getDump(args[0], args[1]);
        Memory memory = dump.getMemory();
        HashSet<Long> entries = new HashSet<Long>();
        long counter = 0L;
        long unreadable = 0L;
        for (int i = 0; i < minBoundaries.length; ++i) {
            long min = minBoundaries[i];
            long max = maxBoundaries[i];
            for (long current = min; current < max; current += 8L) {
                if (!memory.isMapped(current, 32)) {
                    long mask = -4096L;
                    long page = 4096L;
                    current &= mask;
                    current = current + page - 8L;
                    if (++unreadable % 1000L != 0L) continue;
                    System.out.print('-');
                    continue;
                }
                if (!PrintLongestQueue.isQueueEntry(memory, current, minBoundaries, maxBoundaries)) continue;
                entries.add(current);
                if (++counter % 1000L != 0L) continue;
                System.out.print('.');
            }
        }
        HashSet tmpEntries = new HashSet(entries);
        ArrayList queues = new ArrayList();
        long elementCounter = 0L;
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            long start = (Long)iterator.next();
            if (!tmpEntries.contains(start)) continue;
            System.out.print('#');
            HashSet<Long> q = new HashSet<Long>();
            queues.add(q);
            long current = start;
            long last = 0L;
            do {
                if (++elementCounter % 1000L == 0L) {
                    System.out.print(',');
                }
                q.add(current);
                tmpEntries.remove(current);
                last = current;
            } while (PrintLongestQueue.isQueueEntry(memory, current = PrintLongestQueue.getPrev(memory, current), minBoundaries, maxBoundaries) && tmpEntries.contains(current) && PrintLongestQueue.getNext(memory, current) == last && current != start);
            if (current == start) continue;
            current = start;
            last = 0L;
            do {
                if (++elementCounter % 1000L == 0L) {
                    System.out.print(',');
                }
                q.add(current);
                tmpEntries.remove(current);
                last = current;
            } while (PrintLongestQueue.isQueueEntry(memory, current = PrintLongestQueue.getNext(memory, current), minBoundaries, maxBoundaries) && tmpEntries.contains(current) && PrintLongestQueue.getPrev(memory, current) == last && current != start);
        }
        System.out.println();
        int index = 0;
        for (Set iterator2 : queues) {
            System.out.println("Queue " + index + ": size=" + iterator2.size());
            ++index;
        }
        Collections.sort(queues, new Comparator<Set<Long>>(){

            @Override
            public int compare(Set<Long> o1, Set<Long> o2) {
                return o1.size() - o2.size();
            }
        });
        System.out.println();
        index = 0;
        for (Set set : queues) {
            if (set.size() < 10) continue;
            long entry = (Long)set.iterator().next();
            System.out.println("Queue " + index + ": entry=0x" + Long.toHexString(entry) + ", size=" + set.size());
            ++index;
        }
        System.out.println();
        System.out.println(counter + " queue entries found.");
        System.out.println(entries.size() + " unique queue entries found.");
        System.out.println(queues.size() + " queues found.");
        System.out.println();
        System.out.println("Printing longest Queue:");
        ArrayList longestQueue = new ArrayList((Collection)queues.get(queues.size() - 1));
        Collections.sort(longestQueue);
        Iterator iterator2 = longestQueue.iterator();
        while (iterator2.hasNext()) {
            long element = (Long)iterator2.next();
            System.out.println("0x" + Long.toHexString(element));
        }
    }

    private static boolean isQueueEntry(Memory memory, long address, long[] min, long[] max) {
        if (!(memory.isMapped(address, 8) && memory.isMapped(address + 8L, 8) && memory.isMapped(address + 16L, 8) && memory.isMapped(address + 24L, 8))) {
            return false;
        }
        long staticValue = memory.getInt64(address + 8L);
        long previous = PrintLongestQueue.getPrev(memory, address);
        long next = PrintLongestQueue.getNext(memory, address);
        return staticValue == 33L && PrintLongestQueue.isValidPointer(memory, previous, min, max) && PrintLongestQueue.isValidPointer(memory, next, min, max);
    }

    private static long getPrev(Memory memory, long address) {
        if (!memory.isMapped(address, 32)) {
            return 0L;
        }
        return memory.getInt64(address + 16L);
    }

    private static long getNext(Memory memory, long address) {
        if (!memory.isMapped(address, 32)) {
            return 0L;
        }
        return memory.getInt64(address + 24L);
    }

    private static boolean isValidPointer(Memory memory, long address, long[] min, long[] max) {
        boolean inRange = false;
        for (int i = 0; i < min.length; ++i) {
            inRange |= address > min[i] && address < max[i];
        }
        return inRange && memory.isMapped(address, 8);
    }
}

