/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.examples;

import com.sap.jvm.tools.dumps.api.Dump;
import com.sap.jvm.tools.dumps.api.DumpFactory;
import com.sap.jvm.tools.dumps.api.Memory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class QueueFinder {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Incorrect number of arguments: " + args.length);
            return;
        }
        long[] minBoundaries = new long[]{0x7F7000000000L, 0x50C000L};
        long[] maxBoundaries = new long[]{140127602999296L, 0xFF1000L};
        Dump dump = DumpFactory.getDump(args[0], args[1]);
        Memory memory = dump.getMemory();
        HashSet<Long> entries = new HashSet<Long>();
        final HashMap<Long, Long> queues = new HashMap<Long, Long>();
        long counter = 0L;
        long exceptions = 0L;
        for (int i = 0; i < minBoundaries.length; ++i) {
            long min = minBoundaries[i];
            long max = maxBoundaries[i];
            for (long current = min; current < max; current += 8L) {
                if (!memory.isMapped(current, 32)) {
                    long mask = -4096L;
                    long page = 4096L;
                    current &= mask;
                    current = current + page - 8L;
                    if (++exceptions % 1000L != 0L) continue;
                    System.out.print('-');
                    continue;
                }
                if (!QueueFinder.isQueueEntry(memory, current, minBoundaries, maxBoundaries)) continue;
                if (++counter % 1000L == 0L) {
                    System.out.print('.');
                }
                if (entries.contains(current)) continue;
                QueueFinder.addQueue(memory, queues, entries, current, minBoundaries, maxBoundaries);
            }
        }
        System.out.println();
        int index = 0;
        for (Map.Entry entry : queues.entrySet()) {
            System.out.println("Queue " + index + ": start=0x" + Long.toHexString((Long)entry.getKey()) + ", length=" + entry.getValue());
            ++index;
        }
        ArrayList queueKeys = new ArrayList(queues.keySet());
        Collections.sort(queueKeys, new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                long length1 = (Long)queues.get(o1);
                long length2 = (Long)queues.get(o2);
                return (int)(length1 - length2);
            }
        });
        System.out.println();
        index = 0;
        Iterator iterator = queueKeys.iterator();
        while (iterator.hasNext()) {
            long key = (Long)iterator.next();
            long length = (Long)queues.get(key);
            if (length < 10L) continue;
            System.out.println("Queue " + index + ": start=0x" + Long.toHexString(key) + ", length=" + length);
            ++index;
        }
        System.out.println();
        System.out.println(counter + " queue entries found.");
        System.out.println(entries.size() + " unique queue entries found.");
        System.out.println(queues.size() + " queues found.");
    }

    private static boolean isQueueEntry(Memory memory, long address, long[] min, long[] max) {
        if (!(memory.isMapped(address, 8) && memory.isMapped(address + 8L, 8) && memory.isMapped(address + 16L, 8) && memory.isMapped(address + 24L, 8))) {
            return false;
        }
        long staticValue = memory.getInt64(address + 8L);
        long previous = QueueFinder.getPrev(memory, address);
        long next = QueueFinder.getNext(memory, address);
        return staticValue == 33L && QueueFinder.isValidPointer(memory, previous, min, max) && QueueFinder.isValidPointer(memory, next, min, max);
    }

    private static void addQueue(Memory memory, Map<Long, Long> queues, Set<Long> entries, long address, long[] min, long[] max) {
        long previous;
        long current = address;
        long counter = 0L;
        long lowest = Long.MAX_VALUE;
        long last = 0L;
        do {
            ++counter;
            entries.add(current);
            if (current < lowest) {
                lowest = current;
            }
            previous = QueueFinder.getPrev(memory, current);
            last = current;
        } while ((current = previous) != address && QueueFinder.isQueueEntry(memory, current, min, max));
        if (current != address) {
            long next;
            long queueStart = last;
            current = address;
            do {
                ++counter;
                entries.add(current);
                if (current >= lowest) continue;
                lowest = current;
            } while ((current = (next = QueueFinder.getNext(memory, current))) != address && QueueFinder.isQueueEntry(memory, current, min, max));
            lowest = queueStart;
        }
        queues.put(lowest, counter);
        System.out.print('#');
    }

    private static long getPrev(Memory memory, long address) {
        if (!memory.isMapped(address, 32)) {
            return 0L;
        }
        return memory.getInt64(address + 16L);
    }

    private static long getNext(Memory memory, long address) {
        if (!memory.isMapped(address, 32)) {
            return 0L;
        }
        return memory.getInt64(address + 24L);
    }

    private static boolean isValidPointer(Memory memory, long address, long[] min, long[] max) {
        boolean inRange = false;
        for (int i = 0; i < min.length; ++i) {
            inRange |= address > min[i] && address < max[i];
        }
        return inRange && memory.isMapped(address, 8);
    }
}

