/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.examples;

import com.sap.jvm.tools.dumps.api.Dump;
import com.sap.jvm.tools.dumps.api.DumpFactory;
import com.sap.jvm.tools.dumps.api.Memory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class QueueFinder2 {
    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException {
        void var16_29;
        if (args.length != 2) {
            System.err.println("Incorrect number of arguments: " + args.length);
            return;
        }
        long[] minBoundaries = new long[]{0x7F7000000000L, 0x50C000L};
        long[] maxBoundaries = new long[]{140127602999296L, 0xFF1000L};
        Dump dump = DumpFactory.getDump(args[0], args[1]);
        Memory memory = dump.getMemory();
        HashSet<Long> entries = new HashSet<Long>();
        long counter = 0L;
        long unreadable = 0L;
        for (int i = 0; i < minBoundaries.length; ++i) {
            long min = minBoundaries[i];
            long max = maxBoundaries[i];
            for (long current = min; current < max; current += 8L) {
                if (!memory.isMapped(current, 32)) {
                    long mask = -4096L;
                    long page = 4096L;
                    current &= mask;
                    current = current + page - 8L;
                    if (++unreadable % 1000L != 0L) continue;
                    System.out.print('-');
                    continue;
                }
                if (!QueueFinder2.isQueueEntry(memory, current, minBoundaries, maxBoundaries)) continue;
                entries.add(current);
                if (++counter % 1000L != 0L) continue;
                System.out.print('.');
            }
        }
        HashSet tmpEntries = new HashSet(entries);
        ArrayList queues = new ArrayList();
        long elementCounter = 0L;
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            long start = (Long)iterator.next();
            if (!tmpEntries.contains(start)) continue;
            System.out.print('#');
            HashSet<Long> q = new HashSet<Long>();
            queues.add(q);
            long current = start;
            long last = 0L;
            do {
                if (++elementCounter % 1000L == 0L) {
                    System.out.print(',');
                }
                q.add(current);
                tmpEntries.remove(current);
                last = current;
            } while (QueueFinder2.isQueueEntry(memory, current = QueueFinder2.getPrev(memory, current), minBoundaries, maxBoundaries) && tmpEntries.contains(current) && QueueFinder2.getNext(memory, current) == last && current != start);
            if (current == start) continue;
            current = start;
            last = 0L;
            do {
                if (++elementCounter % 1000L == 0L) {
                    System.out.print(',');
                }
                q.add(current);
                tmpEntries.remove(current);
                last = current;
            } while (QueueFinder2.isQueueEntry(memory, current = QueueFinder2.getNext(memory, current), minBoundaries, maxBoundaries) && tmpEntries.contains(current) && QueueFinder2.getPrev(memory, current) == last && current != start);
        }
        System.out.println();
        int index = 0;
        for (Set set : queues) {
            System.out.println("Queue " + index + ": size=" + set.size());
            ++index;
        }
        Collections.sort(queues, new Comparator<Set<Long>>(){

            @Override
            public int compare(Set<Long> o1, Set<Long> o2) {
                return o1.size() - o2.size();
            }
        });
        System.out.println();
        index = 0;
        for (Set set : queues) {
            if (set.size() < 10) continue;
            long entry = (Long)set.iterator().next();
            System.out.println("Queue " + index + ": entry=0x" + Long.toHexString(entry) + ", size=" + set.size());
            ++index;
        }
        System.out.println();
        System.out.println(counter + " queue entries found.");
        System.out.println(entries.size() + " unique queue entries found.");
        System.out.println(queues.size() + " queues found.");
        System.out.println();
        Set ring = (Set)queues.get(queues.size() - 1);
        System.out.println("Searching for references in queue with size: " + ring.size());
        elementCounter = 0L;
        boolean bl = false;
        while (var16_29 < memory.getNrOfMappedRanges()) {
            long start = memory.getRangeStartAddress((int)var16_29);
            long end = start + memory.getRangeSize((int)var16_29);
            for (long current = start; current < end; current += 8L) {
                long value;
                if (++elementCounter % 1000L == 0L) {
                    System.out.print('+');
                }
                if (((value = memory.getInt64(current)) <= minBoundaries[0] || value >= maxBoundaries[0]) && (value <= minBoundaries[1] || value >= maxBoundaries[1]) || !ring.contains(value)) continue;
                long previous = QueueFinder2.getPrev(memory, value);
                long next = QueueFinder2.getNext(memory, value);
                if (current == previous + 16L || current == previous + 24L || current == next + 16L || current == next + 24L) continue;
                System.out.println();
                System.out.println("0x" + Long.toHexString(current) + " references queue element 0x" + Long.toHexString(value));
            }
            ++var16_29;
        }
    }

    private static boolean isQueueEntry(Memory memory, long address, long[] min, long[] max) {
        if (!(memory.isMapped(address, 8) && memory.isMapped(address + 8L, 8) && memory.isMapped(address + 16L, 8) && memory.isMapped(address + 24L, 8))) {
            return false;
        }
        long staticValue = memory.getInt64(address + 8L);
        long previous = QueueFinder2.getPrev(memory, address);
        long next = QueueFinder2.getNext(memory, address);
        return staticValue == 33L && QueueFinder2.isValidPointer(memory, previous, min, max) && QueueFinder2.isValidPointer(memory, next, min, max);
    }

    private static long getPrev(Memory memory, long address) {
        if (!memory.isMapped(address, 32)) {
            return 0L;
        }
        return memory.getInt64(address + 16L);
    }

    private static long getNext(Memory memory, long address) {
        if (!memory.isMapped(address, 32)) {
            return 0L;
        }
        return memory.getInt64(address + 24L);
    }

    private static boolean isValidPointer(Memory memory, long address, long[] min, long[] max) {
        boolean inRange = false;
        for (int i = 0; i < min.length; ++i) {
            inRange |= address > min[i] && address < max[i];
        }
        return inRange && memory.isMapped(address, 8);
    }
}

