/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.impl.common;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public abstract class AbstractDataFile {
    private static final int BUFFER_SIZE = 256;
    private final RandomAccessFile file;
    private final byte[] buffer;
    private long bufferOffset;
    private long bufferSize;

    public AbstractDataFile(String fileName) throws IOException {
        this.file = new RandomAccessFile(fileName, "r");
        this.buffer = new byte[256];
        this.bufferOffset = -256L;
    }

    public final void close() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final short readUint8(long offset) {
        return (short)(this.readInt8(offset) & 0xFF);
    }

    public final byte readInt8(long offset) {
        if (offset >= this.bufferOffset && offset - this.bufferOffset < this.bufferSize) {
            return this.buffer[(int)(offset - this.bufferOffset)];
        }
        this.fillBuffer(offset);
        return this.buffer[0];
    }

    private void ensureBytes(long offset, int nrOfBytes) {
        if (offset >= this.bufferOffset && offset - this.bufferOffset + (long)nrOfBytes <= this.bufferSize) {
            return;
        }
        this.fillBuffer(offset);
        if (this.bufferSize < (long)nrOfBytes) {
            throw new RuntimeException("Could not read " + nrOfBytes + " at offset " + offset);
        }
    }

    private final void fillBuffer(long offset) {
        try {
            this.file.seek(offset);
            this.bufferSize = this.file.read(this.buffer);
            if (this.bufferSize == -1L) {
                throw new RuntimeException("Invalid file offset " + offset);
            }
            this.bufferOffset = offset;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final short readInt16LE(long offset) {
        this.ensureBytes(offset, 2);
        int off = (int)(offset - this.bufferOffset);
        return (short)(this.buffer[off] & 0xFF | (this.buffer[off + 1] & 0xFF) << 8);
    }

    protected final short readInt16BE(long offset) {
        this.ensureBytes(offset, 2);
        int off = (int)(offset - this.bufferOffset);
        return (short)(this.buffer[off + 1] & 0xFF | (this.buffer[off] & 0xFF) << 8);
    }

    public abstract short readInt16(long var1);

    protected final char readUint16LE(long offset) {
        return (char)this.readInt16LE(offset);
    }

    protected final char readUint16BE(long offset) {
        return (char)this.readInt16BE(offset);
    }

    public abstract char readUint16(long var1);

    protected final int readInt32LE(long offset) {
        this.ensureBytes(offset, 4);
        int off = (int)(offset - this.bufferOffset);
        return this.buffer[off] & 0xFF | (this.buffer[off + 1] & 0xFF) << 8 | (this.buffer[off + 2] & 0xFF) << 16 | (this.buffer[off + 3] & 0xFF) << 24;
    }

    protected final int readInt32BE(long offset) {
        this.ensureBytes(offset, 4);
        int off = (int)(offset - this.bufferOffset);
        return this.buffer[off + 3] & 0xFF | (this.buffer[off + 2] & 0xFF) << 8 | (this.buffer[off + 1] & 0xFF) << 16 | (this.buffer[off] & 0xFF) << 24;
    }

    public abstract int readInt32(long var1);

    protected final long readUint32LE(long offset) {
        return (long)this.readInt32LE(offset) & 0xFFFFFFFFL;
    }

    protected final long readUint32BE(long offset) {
        return (long)this.readInt32BE(offset) & 0xFFFFFFFFL;
    }

    public abstract long readUint32(long var1);

    protected final long readInt64LE(long offset) {
        this.ensureBytes(offset, 8);
        int off = (int)(offset - this.bufferOffset);
        return (long)this.buffer[off] & 0xFFL | ((long)this.buffer[off + 1] & 0xFFL) << 8 | ((long)this.buffer[off + 2] & 0xFFL) << 16 | ((long)this.buffer[off + 3] & 0xFFL) << 24 | ((long)this.buffer[off + 4] & 0xFFL) << 32 | ((long)this.buffer[off + 5] & 0xFFL) << 40 | ((long)this.buffer[off + 6] & 0xFFL) << 48 | ((long)this.buffer[off + 7] & 0xFFL) << 56;
    }

    protected final long readInt64BE(long offset) {
        this.ensureBytes(offset, 8);
        int off = (int)(offset - this.bufferOffset);
        return (long)this.buffer[off + 7] & 0xFFL | ((long)this.buffer[off + 6] & 0xFFL) << 8 | ((long)this.buffer[off + 5] & 0xFFL) << 16 | ((long)this.buffer[off + 4] & 0xFFL) << 24 | ((long)this.buffer[off + 3] & 0xFFL) << 32 | ((long)this.buffer[off + 2] & 0xFFL) << 40 | ((long)this.buffer[off + 1] & 0xFFL) << 48 | ((long)this.buffer[off] & 0xFFL) << 56;
    }

    public abstract long readInt64(long var1);

    public final byte[] read(long offset, int size) {
        byte[] result = new byte[size];
        this.readBytes(result, 0, offset, size);
        return result;
    }

    public final String readUTF8String(long offset) {
        return this.readUTF8String(offset, this.getLengthOfString(offset));
    }

    public final String readUTF8String(long offset, int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.readInt8(offset + (long)i);
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "<failed to convert UTF-8 String>";
        }
    }

    public final int getLengthOfString(long offset) {
        int length = 0;
        long newOffset = offset;
        if (offset >= this.bufferOffset && offset - this.bufferOffset < this.bufferSize) {
            int off;
            int i = off = (int)(offset - this.bufferOffset);
            while ((long)i < this.bufferSize) {
                if (this.buffer[i] != 0) {
                    ++length;
                } else {
                    return length;
                }
                ++i;
            }
            newOffset = this.bufferOffset + this.bufferSize;
        }
        this.fillBuffer(newOffset);
        return length + this.getLengthOfString(newOffset);
    }

    public final void readBytes(byte[] result, int offset, long fileOffset, int size) {
        try {
            this.file.seek(fileOffset);
            int toRead = size;
            int off = offset;
            while (toRead > 0) {
                int read = this.file.read(result, off, toRead);
                if (read <= 0) {
                    throw new RuntimeException(new EOFException());
                }
                toRead -= read;
                off += read;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

