/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.impl.common;

import com.sap.jvm.tools.dumps.api.Memory;
import com.sap.jvm.tools.dumps.impl.common.AbstractDataFile;
import com.sap.jvm.tools.dumps.impl.common.MemoryRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractMemoryImpl
implements Memory {
    private final MemoryRange[] ranges;
    private final AbstractDataFile file;
    private int lastRangeIndex;

    public AbstractMemoryImpl(AbstractDataFile file, List<MemoryRange> rangeList) {
        this.file = file;
        Collections.sort(rangeList);
        List<MemoryRange> finalList = AbstractMemoryImpl.coalesceRanges(rangeList);
        this.ranges = finalList.toArray(new MemoryRange[finalList.size()]);
    }

    @Override
    public final byte getInt8(long address) {
        return this.file.readInt8(this.getOffsetForAddress(address, 1));
    }

    @Override
    public final short getUint8(long address) {
        return this.file.readUint8(this.getOffsetForAddress(address, 1));
    }

    @Override
    public short getInt16(long address) {
        return this.file.readInt16(this.getOffsetForAddress(address, 2));
    }

    @Override
    public int getInt32(long address) {
        return this.file.readInt32(this.getOffsetForAddress(address, 4));
    }

    @Override
    public long getInt64(long address) {
        return this.file.readInt64(this.getOffsetForAddress(address, 8));
    }

    @Override
    public char getUint16(long address) {
        return this.file.readUint16(this.getOffsetForAddress(address, 2));
    }

    @Override
    public long getUint32(long address) {
        return this.file.readUint32(this.getOffsetForAddress(address, 4));
    }

    private static List<MemoryRange> coalesceRanges(List<MemoryRange> rangeList) {
        ArrayList<MemoryRange> result = new ArrayList<MemoryRange>();
        result.add(rangeList.get(0));
        for (int i = 1; i < rangeList.size(); ++i) {
            int endIndex = result.size() - 1;
            MemoryRange lastRange = (MemoryRange)result.get(endIndex);
            MemoryRange newRange = rangeList.get(i);
            if (lastRange.getEndAddress() == newRange.getStartAddress() && lastRange.getEndOffset() == newRange.getStartOffset()) {
                result.set(endIndex, new MemoryRange(lastRange.getStartAddress(), lastRange.getSize() + newRange.getSize(), lastRange.getStartOffset()));
                continue;
            }
            result.add(newRange);
        }
        return result;
    }

    @Override
    public final boolean isMapped(long address, int span) {
        int index = this.getRangeIndex(address);
        if (index == -1) {
            return false;
        }
        if (this.ranges[index].isInRange(address, span)) {
            return true;
        }
        long offset = address - this.ranges[index].getStartAddress();
        long left = (long)span - (this.ranges[index].getSize() - offset);
        long nextAddress = this.ranges[index].getEndAddress();
        for (int i = index + 1; i < this.ranges.length; ++i) {
            if (nextAddress != this.ranges[i].getStartAddress()) {
                return false;
            }
            if ((left -= this.ranges[i].getSize()) <= 0L) {
                return true;
            }
            nextAddress += this.ranges[i].getSize();
        }
        return false;
    }

    @Override
    public final boolean getBool(long address) {
        return this.getInt8(address) != 0;
    }

    @Override
    public int getNrOfMappedRanges() {
        return this.ranges.length;
    }

    @Override
    public long getRangeSize(int index) {
        return this.ranges[index].getSize();
    }

    @Override
    public long getRangeStartAddress(int index) {
        return this.ranges[index].getStartAddress();
    }

    @Override
    public void findInt8InRange(byte value, long start, long size, ArrayList<Long> result) {
        long end = start + size;
        for (long address = start; address < end; ++address) {
            if (!this.isMapped(address, 1) || this.getInt8(address) != value) continue;
            result.add(address);
        }
    }

    @Override
    public void findInt16InRange(short value, long start, long size, ArrayList<Long> result) {
        long end = start + size;
        for (long address = start; address < end; address += 2L) {
            if (!this.isMapped(address, 2) || this.getInt16(address) != value) continue;
            result.add(address);
        }
    }

    @Override
    public void findInt32InRange(int value, long start, long size, ArrayList<Long> result) {
        long end = start + size;
        for (long address = start; address < end; address += 4L) {
            if (!this.isMapped(address, 4) || this.getInt32(address) != value) continue;
            result.add(address);
        }
    }

    @Override
    public void findInt64InRange(long value, long start, long size, ArrayList<Long> result) {
        long end = start + size;
        for (long address = start; address < end; address += 8L) {
            if (!this.isMapped(address, 8) || this.getInt64(address) != value) continue;
            result.add(address);
        }
    }

    @Override
    public void findAddressInRange(long address, long start, long size, ArrayList<Long> result) {
        if (this.getAddressSize() == 8) {
            this.findInt64InRange(address, start, size, result);
        } else {
            this.findInt32InRange((int)address, start, size, result);
        }
    }

    private long getOffsetForAddress(long address, int size) {
        assert (this.isMapped(address, size));
        int index = this.getRangeIndex(address);
        if (index == -1) {
            throw new RuntimeException("No memory at 0x" + Long.toHexString(address) + " with " + size + " bytes");
        }
        MemoryRange range = this.ranges[index];
        if (range.isInRange(address, size)) {
            return range.getFileOffset(address);
        }
        throw new RuntimeException("Reading memory at 0x" + Long.toHexString(address) + " with " + size + " bytes crosses a memory range");
    }

    private int getRangeIndex(long address) {
        if (this.ranges[this.lastRangeIndex].isInRange(address)) {
            return this.lastRangeIndex;
        }
        int low = 0;
        int high = this.ranges.length;
        while (low < high) {
            int mid = (low + high) / 2;
            if (this.ranges[mid].isInRange(address)) {
                this.lastRangeIndex = mid;
                return mid;
            }
            if (this.ranges[mid].getStartAddress() < address) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        if (low < this.ranges.length && this.ranges[low].isInRange(address)) {
            this.lastRangeIndex = low;
            return low;
        }
        return -1;
    }

    @Override
    public String getUTF8String(long address, int length) {
        assert (this.isMapped(address, length));
        int index = this.getRangeIndex(address);
        if (index == -1) {
            throw new RuntimeException("No memory at 0x" + Long.toHexString(address) + " with " + length + " bytes");
        }
        MemoryRange range = this.ranges[index];
        if (range.isInRange(address, length)) {
            return this.file.readUTF8String(range.getFileOffset(address), length);
        }
        return "<Creating string contained in two memory regions is not supported>";
    }
}

