/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.impl.common;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;

public final class FileUtils {
    public static String findBestMatch(String fileName, String ... dirs) {
        ArrayList<String> matches = new ArrayList<String>();
        String name = new File(fileName).getName();
        for (String dirName : dirs) {
            File dir = new File(dirName);
            ArrayList<String> possibleMatches = new ArrayList<String>();
            FileUtils.addMatches(possibleMatches, dir, name);
            matches.addAll(possibleMatches);
        }
        int longestMatch = 0;
        String normalizedFile = FileUtils.normalize(fileName);
        ArrayList<String> bestMatches = new ArrayList<String>();
        int fileLength = normalizedFile.length();
        for (String match : matches) {
            int matchLength = match.length();
            int max = Math.min(matchLength, fileLength);
            if (match.equals(normalizedFile)) {
                return match;
            }
            boolean wasMatch = true;
            for (int i = 1; i <= max; ++i) {
                if (match.charAt(matchLength - i) == normalizedFile.charAt(fileLength - i)) continue;
                if (i > longestMatch) {
                    bestMatches = new ArrayList();
                    bestMatches.add(match);
                    longestMatch = i;
                } else if (i == longestMatch) {
                    bestMatches.add(match);
                }
                wasMatch = false;
                break;
            }
            if (!wasMatch) continue;
            longestMatch = max;
            bestMatches.add(match);
        }
        if (bestMatches.size() > 1) {
            throw new RuntimeException("Found more than one matching file for " + fileName + " in directories: " + Arrays.toString(dirs) + ": " + bestMatches);
        }
        if (bestMatches.isEmpty()) {
            throw new RuntimeException("Found no matching file for " + fileName + " in directories: " + Arrays.toString(dirs));
        }
        return (String)bestMatches.get(0);
    }

    private static void addMatches(final ArrayList<String> result, File dir, final String baseName) {
        dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dummy, String name) {
                File file = new File(dummy.getPath() + "/" + name);
                if (file.isDirectory()) {
                    FileUtils.addMatches(result, file, baseName);
                } else if (name.equals(baseName)) {
                    result.add(file.getPath());
                }
                return false;
            }
        });
    }

    public static String normalize(String rawFileName) {
        if (rawFileName == null) {
            return null;
        }
        return rawFileName.replace('\\', '/');
    }
}

