/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.impl.common;

import com.sap.jvm.tools.dumps.impl.common.AbstractDataFile;
import java.io.IOException;

public final class LittleEndianDataFile
extends AbstractDataFile {
    public LittleEndianDataFile(String fileName) throws IOException {
        super(fileName);
    }

    @Override
    public short readInt16(long offset) {
        return this.readInt16LE(offset);
    }

    @Override
    public char readUint16(long offset) {
        return this.readUint16LE(offset);
    }

    @Override
    public int readInt32(long offset) {
        return this.readInt32LE(offset);
    }

    @Override
    public long readUint32(long offset) {
        return this.readUint32LE(offset);
    }

    @Override
    public long readInt64(long offset) {
        return this.readInt64LE(offset);
    }

    public static byte getInt8(byte[] data) {
        return data[0];
    }

    public static short getInt16(byte[] data) {
        return (short)(data[0] & 0xFF | (data[1] & 0xFF) << 8);
    }

    public static char getUint16(byte[] data) {
        return (char)(data[0] & 0xFF | (data[1] & 0xFF) << 8);
    }

    public static int getInt32(byte[] data) {
        return data[0] & 0xFF | (data[1] & 0xFF) << 8 | (data[2] & 0xFF) << 16 | (data[3] & 0xFF) << 24;
    }

    public static long getUint32(byte[] data) {
        return (long)data[0] & 0xFFL | ((long)data[1] & 0xFFL) << 8 | ((long)data[2] & 0xFFL) << 16 | ((long)data[3] & 0xFFL) << 24;
    }

    public static long getInt64(byte[] data) {
        return (long)data[0] & 0xFFL | ((long)data[1] & 0xFFL) << 8 | ((long)data[2] & 0xFFL) << 16 | ((long)data[3] & 0xFFL) << 24 | ((long)data[4] & 0xFFL) << 32 | ((long)data[5] & 0xFFL) << 40 | ((long)data[6] & 0xFFL) << 48 | ((long)data[7] & 0xFFL) << 56;
    }
}

