/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.impl.common;

public final class MemoryRange
implements Comparable<MemoryRange> {
    private final long startAddress;
    private final long size;
    private final long fileOffset;

    public MemoryRange(long startAddress, long size, long fileOffset) {
        this.startAddress = startAddress;
        this.size = size;
        this.fileOffset = fileOffset;
    }

    public long getStartAddress() {
        return this.startAddress;
    }

    public long getSize() {
        return this.size;
    }

    public long getEndAddress() {
        return this.startAddress + this.size;
    }

    public boolean isInRange(long address) {
        return this.startAddress <= address && this.startAddress + this.size > address;
    }

    public boolean isInRange(long address, int span) {
        return this.isInRange(address) && this.isInRange(address + (long)span - 1L);
    }

    public long getFileOffset(long address) {
        return this.fileOffset + address - this.startAddress;
    }

    public long getStartOffset() {
        return this.fileOffset;
    }

    public long getEndOffset() {
        return this.fileOffset + this.size;
    }

    @Override
    public int compareTo(MemoryRange o) {
        if (this.startAddress < o.startAddress) {
            return -1;
        }
        if (this.startAddress > o.startAddress) {
            return 1;
        }
        return 0;
    }
}

