/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.impl.common;

import com.sap.jvm.tools.dumps.api.Dump;
import com.sap.jvm.tools.dumps.api.Module;
import com.sap.jvm.tools.dumps.api.SymbolResolver;

public class SymbolResolverImpl
implements SymbolResolver {
    private final Dump dump;

    public SymbolResolverImpl(Dump dump) {
        this.dump = dump;
    }

    @Override
    public long getAddress(String symbol) {
        int exPos = symbol.indexOf(33);
        if (exPos < 0) {
            throw new RuntimeException("Missing '!' in symbol name " + symbol);
        }
        String moduleName = symbol.substring(0, exPos);
        String symbolName = symbol.substring(exPos + 1);
        Module module = this.dump.getModuleFromName(moduleName);
        return module.getSymbolAddress(symbolName);
    }

    @Override
    public int getOffset(String field) {
        int exPos = field.indexOf(33);
        if (exPos < 0) {
            throw new RuntimeException("Missing '!' in field " + field);
        }
        String moduleName = field.substring(0, exPos);
        int dotPos = field.lastIndexOf(46);
        if (dotPos <= 0) {
            throw new RuntimeException("Missing '.' in field " + field);
        }
        Module module = this.dump.getModuleFromName(moduleName);
        return module.getFieldOffset(field.substring(exPos + 1));
    }

    @Override
    public long getAddressOrFail(String symbol) throws RuntimeException {
        long result = this.getAddress(symbol);
        if (result == -1L) {
            throw new RuntimeException("Could not find symbol " + symbol);
        }
        return result;
    }

    @Override
    public int getOffsetOrFail(String field) throws RuntimeException {
        int result = this.getOffset(field);
        if (result == -1) {
            throw new RuntimeException("Could not find field " + field);
        }
        return result;
    }
}

