/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.impl.elf;

import com.sap.jvm.tools.dumps.impl.common.AbstractDataFile;
import java.util.ArrayList;
import java.util.HashMap;

public class Dwarf2Parser {
    private static final int TAG_STRUCTURE = 19;
    private static final int TAG_CLASS = 2;
    private static final int TAG_MEMBER = 13;
    private final AbstractDataFile file;
    private final long infoOffset;
    private final long infoSize;
    private final long stringOffset;
    private final long abbrOffset;
    private final long abbrSize;
    private HashMap<String, Integer> fieldOffsets;
    private final long[][] abbrAttrTable;
    private final long[][] abbrFormTable;
    private final long[] abbrTypeTable;
    private final boolean[] abbrHasChildrenTable;
    private final InfoEntry[] infoEntries;
    private int stackSize;
    private long infoStartddress;
    private long infoEndAddress;
    private int addressSize;
    private long address;
    private final HashMap<Long, String> stringTableCache;

    public Dwarf2Parser(AbstractDataFile file, long infoOffset, long infoSize, long stringOffset, long abbrOffset, long abbrSize) {
        this.file = file;
        this.infoOffset = infoOffset;
        this.infoSize = infoSize;
        this.stringOffset = stringOffset;
        this.abbrOffset = abbrOffset;
        this.abbrSize = abbrSize;
        this.abbrAttrTable = new long[10000][];
        this.abbrFormTable = new long[10000][];
        this.abbrTypeTable = new long[10000];
        this.abbrHasChildrenTable = new boolean[10000];
        this.infoEntries = new InfoEntry[1000];
        for (int i = 0; i < this.infoEntries.length; ++i) {
            this.infoEntries[i] = new InfoEntry();
        }
        this.stringTableCache = new HashMap();
    }

    public HashMap<String, Integer> getFieldOffsets() {
        if (this.fieldOffsets == null) {
            this.fieldOffsets = new HashMap();
            long curr = this.infoOffset;
            while (curr < this.infoOffset + this.infoSize) {
                long len = this.file.readUint32(curr);
                short version = this.file.readInt16(curr += 4L);
                curr += 2L;
                if (version != 2) {
                    throw new RuntimeException("Can only parse dwarf 2 not dwarf " + version);
                }
                long abbrAddress = this.file.readUint32(curr);
                this.address = abbrAddress + this.abbrOffset;
                this.createAbbrTable();
                this.addressSize = this.file.readInt8(curr += 4L);
                this.address = ++curr;
                this.infoEndAddress = curr + len - 7L;
                this.infoStartddress = curr;
                this.parseInfos();
                curr = this.infoEndAddress;
            }
        }
        return this.fieldOffsets;
    }

    private void parseInfos() {
        this.stackSize = 1;
        while (this.address < this.infoEndAddress) {
            for (int i = this.stackSize - 1; i >= 0; --i) {
                if (this.address != this.infoEntries[i].sibling) continue;
                this.stackSize = i + 1;
                break;
            }
            this.pushNextInfo();
            InfoEntry entry = this.infoEntries[this.stackSize - 1];
            if (entry.type != 13) continue;
            String name = "." + entry.name;
            boolean addedType = false;
            for (int i = this.stackSize - 2; i >= 0; --i) {
                entry = this.infoEntries[i];
                if (entry.type != 2 && entry.type != 19) continue;
                name = !addedType ? entry.name + name : entry.name + "::" + name;
                addedType = true;
            }
            this.fieldOffsets.put(name, this.infoEntries[this.stackSize - 1].offset);
        }
    }

    private void pushNextInfo() {
        int abbr = (int)this.readLEB128();
        long type = this.abbrTypeTable[abbr];
        if (abbr == 0) {
            return;
        }
        this.infoEntries[this.stackSize - 1].type = (int)type;
        this.infoEntries[this.stackSize - 1].sibling = -1L;
        this.infoEntries[this.stackSize - 1].offset = -1;
        for (int i = 0; i < this.abbrAttrTable[abbr].length; ++i) {
            this.readAttribute(this.abbrAttrTable[abbr][i], this.abbrFormTable[abbr][i]);
        }
        if (this.abbrHasChildrenTable[abbr]) {
            ++this.stackSize;
        }
    }

    private void readAttribute(long attr, long form) {
        String str = null;
        byte[] block = null;
        long reference = -1L;
        switch ((int)form) {
            case 1: {
                this.address += (long)this.addressSize;
                break;
            }
            case 3: {
                this.address += (long)(2 + this.file.readUint16(this.address));
                break;
            }
            case 4: {
                this.address += 4L + this.file.readUint32(this.address);
                break;
            }
            case 5: {
                this.address += 2L;
                break;
            }
            case 6: {
                this.address += 4L;
                break;
            }
            case 7: {
                this.address += 8L;
                break;
            }
            case 8: {
                str = this.file.readUTF8String(this.address);
                this.address += (long)(this.file.getLengthOfString(this.address) + 1);
                break;
            }
            case 9: {
                long len = this.readLEB128();
                this.address += len;
                break;
            }
            case 10: {
                if (attr == 56L) {
                    short size = this.file.readUint8(this.address);
                    block = new byte[size];
                    this.file.readBytes(block, 0, this.address + 1L, size);
                    this.address += (long)(1 + size);
                    break;
                }
                this.address += (long)(1 + this.file.readUint8(this.address));
                break;
            }
            case 11: {
                ++this.address;
                break;
            }
            case 12: {
                ++this.address;
                break;
            }
            case 13: {
                this.readLEB128();
                break;
            }
            case 14: {
                long offset = this.file.readUint32(this.address);
                this.address += 4L;
                str = this.stringTableCache.get(offset);
                if (str != null) break;
                str = this.file.readUTF8String(this.stringOffset + offset);
                this.stringTableCache.put(offset, str);
                break;
            }
            case 15: {
                this.readLEB128();
                break;
            }
            case 16: {
                this.address += (long)this.addressSize;
                break;
            }
            case 17: {
                reference = this.file.readUint8(this.address);
                ++this.address;
                break;
            }
            case 18: {
                reference = this.file.readUint16(this.address);
                this.address += 2L;
                break;
            }
            case 19: {
                reference = this.file.readUint32(this.address);
                this.address += 4L;
                break;
            }
            case 20: {
                this.address += 8L;
                break;
            }
            case 21: {
                this.readLEB128();
                break;
            }
            case 22: {
                this.readAttribute(attr, this.readLEB128());
                break;
            }
        }
        if (attr == 1L) {
            this.infoEntries[this.stackSize - 1].sibling = reference + this.infoStartddress - 11L;
        } else if (attr == 3L) {
            this.infoEntries[this.stackSize - 1].name = str;
        } else if (attr == 56L && block[0] == 35) {
            this.infoEntries[this.stackSize - 1].offset = 0;
            int i = 0;
            int shift = 0;
            do {
                this.infoEntries[this.stackSize - 1].offset += (block[++i] & 0x7F) << shift;
                shift += 7;
            } while (block[i] < 0);
        }
    }

    private void createAbbrTable() {
        long lastAbbr = 0L;
        while (this.address < this.abbrOffset + this.abbrSize) {
            int abbr = (int)this.readLEB128();
            if ((long)abbr <= lastAbbr) {
                return;
            }
            this.abbrTypeTable[abbr] = this.readLEB128();
            ArrayList<Long> attributes = new ArrayList<Long>();
            ArrayList<Long> forms = new ArrayList<Long>();
            this.abbrHasChildrenTable[abbr] = this.file.readInt8(this.address) == 1;
            ++this.address;
            while (true) {
                long attr = this.readLEB128();
                long form = this.readLEB128();
                if (attr == 0L && form == 0L) break;
                attributes.add(attr);
                forms.add(form);
            }
            this.abbrAttrTable[abbr] = new long[attributes.size()];
            this.abbrFormTable[abbr] = new long[forms.size()];
            for (int i = 0; i < this.abbrAttrTable[abbr].length; ++i) {
                this.abbrAttrTable[abbr][i] = (Long)attributes.get(i);
                this.abbrFormTable[abbr][i] = (Long)forms.get(i);
            }
        }
    }

    private long readLEB128() {
        long read;
        int shift = 0;
        long result = 0L;
        do {
            read = this.file.readInt8(this.address);
            ++this.address;
            result += (read & 0x7FL) << shift;
            shift += 7;
        } while (read < 0L);
        return result;
    }

    private static class InfoEntry {
        public String name;
        public int type;
        public int offset;
        public long sibling;

        private InfoEntry() {
        }
    }
}

