/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.impl.elf;

import com.sap.jvm.tools.dumps.impl.common.AbstractDataFile;
import com.sap.jvm.tools.dumps.impl.common.BigEndianDataFile;
import com.sap.jvm.tools.dumps.impl.common.LittleEndianDataFile;
import com.sap.jvm.tools.dumps.impl.elf.Dwarf2Parser;
import com.sap.jvm.tools.dumps.impl.elf.Symbol;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

public class ElfFile {
    public static final int PROGRAM_HEADER_TYPE_LOADABLE = 1;
    public static final int PROGRAM_HEADER_NOTE = 4;
    public static final int SECTION_HEADER_SYMBOLS = 2;
    public static final int SECTION_HEADER_DYN_SYMBOLS = 11;
    private static final int NO_ELF = 0;
    private static final int ELF_32_LE = 1;
    private static final int ELF_32_BE = 2;
    private static final int ELF_64_LE = 3;
    private static final int ELF_64_BE = 4;
    private static final int EXE_TYPE = 2;
    private static final int SHARED_LIB_TYPE = 3;
    private static final int CORE_TYPE = 4;
    private static final int SPARC = 43;
    private static final int X86 = 3;
    private static final int X86_64 = 62;
    private static final int IA64 = 50;
    private static final int PPC = 21;
    private static final int ZARCH = 22;
    private static final int PARISC = 15;
    private static final long ALIGNMENT = 4096L;
    private final AbstractDataFile file;
    private final boolean is32Bit;
    private final boolean isLittleEndian;
    private final int fileType;
    private final int processorType;
    private final long programHeaderOffset;
    private final long sectionHeaderOffset;
    private final int programHeaderEntrySize;
    private final int programHeaderEntryCount;
    private final int sectionHeaderEntrySize;
    private final int sectionHeaderEntryCount;
    private final int sectionHeaderNameIndex;
    private final int sectionStrTabIndex;
    private final long[] noteEntryOffsets;
    private final int dynamicNameIndex;
    private final int dwarfInfoIndex;
    private final int dwarfStringIndex;
    private final int dwarfAbbrIndex;

    public ElfFile(String fileName) throws IOException {
        int i;
        int type = ElfFile.getType(fileName);
        if (type == 0) {
            throw new RuntimeException("Invalid elf file " + fileName);
        }
        this.is32Bit = type == 2 || type == 1;
        this.isLittleEndian = type == 1 || type == 3;
        this.file = this.isLittleEndian ? new LittleEndianDataFile(fileName) : new BigEndianDataFile(fileName);
        this.fileType = this.file.readUint16(16L);
        if (this.fileType != 2 && this.fileType != 3 && this.fileType != 4) {
            throw new RuntimeException("Unknown type " + this.fileType);
        }
        this.processorType = this.file.readUint16(18L);
        if (this.processorType != 3 && this.processorType != 62 && this.processorType != 50 && this.processorType != 43 && this.processorType != 15 && this.processorType != 21 && this.processorType != 22) {
            throw new RuntimeException("Unsupported processor type");
        }
        if (this.is32Bit) {
            this.programHeaderOffset = this.file.readUint32(28L);
            this.sectionHeaderOffset = this.file.readUint32(32L);
            this.programHeaderEntrySize = this.file.readUint16(42L);
            this.programHeaderEntryCount = this.file.readUint16(44L);
            this.sectionHeaderEntrySize = this.file.readUint16(46L);
            this.sectionHeaderEntryCount = this.file.readUint16(48L);
            this.sectionHeaderNameIndex = this.file.readUint16(50L);
        } else {
            this.programHeaderOffset = this.file.readInt64(32L);
            this.sectionHeaderOffset = this.file.readInt64(40L);
            this.programHeaderEntrySize = this.file.readUint16(54L);
            this.programHeaderEntryCount = this.file.readUint16(56L);
            this.sectionHeaderEntrySize = this.file.readUint16(58L);
            this.sectionHeaderEntryCount = this.file.readUint16(60L);
            this.sectionHeaderNameIndex = this.file.readUint16(62L);
        }
        ArrayList<Long> offsets = new ArrayList<Long>();
        for (i = 0; i < this.programHeaderEntryCount; ++i) {
            int headerType = this.getProgramHeaderType(i);
            if (headerType != 4) continue;
            this.parseNoteSegement(this.getProgramHeaderOffset(i), this.getProgramHeaderSize(i), offsets);
        }
        this.noteEntryOffsets = new long[offsets.size()];
        for (i = 0; i < this.noteEntryOffsets.length; ++i) {
            this.noteEntryOffsets[i] = offsets.get(i);
        }
        int dynIndex = -1;
        int infoIndex = -1;
        int strIndex = -1;
        int abbrIndex = -1;
        int strTabIndex = -1;
        for (int i2 = 0; i2 < this.sectionHeaderEntryCount; ++i2) {
            String name = this.getSectionHeaderName(i2);
            if (name.equals(".dynstr")) {
                dynIndex = i2;
                continue;
            }
            if (name.equals(".debug_info")) {
                infoIndex = i2;
                continue;
            }
            if (name.equals(".debug_str")) {
                strIndex = i2;
                continue;
            }
            if (name.equals(".debug_abbrev")) {
                abbrIndex = i2;
                continue;
            }
            if (!name.equals(".strtab")) continue;
            strTabIndex = i2;
        }
        this.dynamicNameIndex = dynIndex;
        this.dwarfInfoIndex = infoIndex;
        this.dwarfStringIndex = strIndex;
        this.dwarfAbbrIndex = abbrIndex;
        this.sectionStrTabIndex = strTabIndex;
    }

    public static boolean isElfFile(String fileName) throws IOException {
        return ElfFile.getType(fileName) != 0;
    }

    private static int getType(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        int result = 0;
        if (fis.read() == 127 && fis.read() == 69 && fis.read() == 76 && fis.read() == 70) {
            int classTag = fis.read();
            int endianTag = fis.read();
            if (classTag == 1) {
                if (endianTag == 1) {
                    result = 1;
                } else if (endianTag == 2) {
                    result = 2;
                }
            } else if (classTag == 2) {
                if (endianTag == 1) {
                    result = 3;
                } else if (endianTag == 2) {
                    result = 4;
                }
            }
        }
        fis.close();
        return result;
    }

    private void parseNoteSegement(long offset, long size, ArrayList<Long> offsets) {
        long curr = 0L;
        while (curr + 12L < size) {
            offsets.add(offset + curr);
            long nameSize = this.file.readUint32(offset + curr);
            long descSize = this.file.readUint32(offset + curr + 4L);
            curr += 12L;
            if (this.is32Bit) {
                curr += ElfFile.alignUp(nameSize, 4L);
                curr += ElfFile.alignUp(descSize, 4L);
                continue;
            }
            curr += ElfFile.alignUp(nameSize, 8L);
            curr += ElfFile.alignUp(descSize, 8L);
        }
    }

    public boolean isCore() {
        return this.fileType == 4;
    }

    public boolean isExe() {
        return this.fileType == 2;
    }

    public boolean isSharedLib() {
        return this.fileType == 3;
    }

    public boolean isX86() {
        return this.processorType == 3;
    }

    public boolean isAmd64() {
        return this.processorType == 62;
    }

    public boolean isSparc() {
        return this.processorType == 43;
    }

    public boolean isPaRisc() {
        return this.processorType == 15;
    }

    public boolean isPowerPC() {
        return this.processorType == 21;
    }

    public boolean isZArch() {
        return this.processorType == 22;
    }

    public boolean isIA64() {
        return this.processorType == 50;
    }

    public int getNrOfProgramHeaders() {
        return this.programHeaderEntryCount;
    }

    public int getNrOfSectionHeaders() {
        return this.sectionHeaderEntryCount;
    }

    public int getProgramHeaderType(int index) {
        assert (index >= 0);
        assert (index < this.programHeaderEntryCount);
        return this.file.readInt32(this.programHeaderOffset + (long)(index * this.programHeaderEntrySize));
    }

    public long getProgramHeaderOffset(int index) {
        assert (index >= 0);
        assert (index < this.programHeaderEntryCount);
        if (this.is32Bit) {
            return this.file.readUint32(this.programHeaderOffset + (long)(index * this.programHeaderEntrySize) + 4L);
        }
        return this.file.readInt64(this.programHeaderOffset + (long)(index * this.programHeaderEntrySize) + 8L);
    }

    public long getProgramHeaderAddress(int index) {
        assert (index >= 0);
        assert (index < this.programHeaderEntryCount);
        if (this.is32Bit) {
            return this.file.readUint32(this.programHeaderOffset + (long)(index * this.programHeaderEntrySize) + 8L);
        }
        return this.file.readInt64(this.programHeaderOffset + (long)(index * this.programHeaderEntrySize) + 16L);
    }

    public long getProgramHeaderSize(int index) {
        assert (index >= 0);
        assert (index < this.programHeaderEntryCount);
        if (this.is32Bit) {
            return this.file.readUint32(this.programHeaderOffset + (long)(index * this.programHeaderEntrySize) + 16L);
        }
        return this.file.readInt64(this.programHeaderOffset + (long)(index * this.programHeaderEntrySize) + 32L);
    }

    public long getProgramHeaderMemSize(int index) {
        assert (index >= 0);
        assert (index < this.programHeaderEntryCount);
        if (this.is32Bit) {
            return this.file.readUint32(this.programHeaderOffset + (long)(index * this.programHeaderEntrySize) + 20L);
        }
        return this.file.readInt64(this.programHeaderOffset + (long)(index * this.programHeaderEntrySize) + 40L);
    }

    public int getProgramHeaderFlags(int index) {
        assert (index >= 0);
        assert (index < this.programHeaderEntryCount);
        if (this.is32Bit) {
            return this.file.readInt32(this.programHeaderOffset + (long)(index * this.programHeaderEntrySize) + 24L);
        }
        return this.file.readInt32(this.programHeaderOffset + (long)(index * this.programHeaderEntrySize) + 4L);
    }

    public boolean getProgramHeaderIsWritable(int index) {
        assert (index >= 0);
        assert (index < this.programHeaderEntryCount);
        return (this.getProgramHeaderFlags(index) & 2) == 2;
    }

    public boolean is32Bit() {
        return this.is32Bit;
    }

    public boolean isLittleEndian() {
        return this.isLittleEndian;
    }

    public AbstractDataFile getFile() {
        return this.file;
    }

    public int getNrOfNoteEntries() {
        return this.noteEntryOffsets.length;
    }

    public long getNoteNameOffset(int index) {
        return this.noteEntryOffsets[index] + 12L;
    }

    public long getNoteNameSize(int index) {
        return this.file.readUint32(this.noteEntryOffsets[index]);
    }

    public long getNoteDescOffset(int index) {
        if (this.is32Bit) {
            return this.noteEntryOffsets[index] + 12L + ElfFile.alignUp(this.getNoteNameSize(index), 4L);
        }
        return this.noteEntryOffsets[index] + 12L + ElfFile.alignUp(this.getNoteNameSize(index), 8L);
    }

    public long getNoteDescSize(int index) {
        return this.file.readUint32(this.noteEntryOffsets[index] + 4L);
    }

    public int getNoteType(int index) {
        return this.file.readInt32(this.noteEntryOffsets[index] + 8L);
    }

    private static long alignUp(long val, long alignment) {
        assert ((alignment & alignment - 1L) == 0L);
        return val + alignment - 1L & (alignment - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private final boolean rangeIsFileMapped(long address, long size) {
        if (size <= 0L) {
            return true;
        }
        for (int i = 0; i < this.getNrOfProgramHeaders(); ++i) {
            if (this.getProgramHeaderType(i) != 1) continue;
            long fileSize = this.getProgramHeaderSize(i);
            long fileAddress = this.getProgramHeaderAddress(i);
            if (address < fileAddress || address >= fileAddress + fileSize) continue;
            if (address + size <= fileAddress + fileSize) {
                return true;
            }
            long leftSize = fileAddress + fileSize - address;
            return this.rangeIsFileMapped(address, leftSize);
        }
        return false;
    }

    public void printProgramHeader(PrintStream out) {
        for (int i = 0; i < this.getNrOfProgramHeaders(); ++i) {
            long type = this.getProgramHeaderType(i);
            long fileOffset = this.getProgramHeaderOffset(i);
            long fileSize = this.getProgramHeaderSize(i);
            long memOffset = this.getProgramHeaderAddress(i);
            long memSize = this.getProgramHeaderMemSize(i);
            out.println("type: 0x" + Long.toHexString(type) + " file offset 0x" + Long.toHexString(fileOffset) + " file size 0x" + Long.toHexString(fileSize) + " file size aligned 0x" + Long.toHexString(ElfFile.alignUp(fileSize, 4096L)) + " address 0x" + Long.toHexString(memOffset) + " mem size 0x" + Long.toHexString(memSize) + " mem size aligned 0x" + Long.toHexString(ElfFile.alignUp(memSize, 4096L)) + " unmapped size 0x" + Long.toHexString(ElfFile.alignUp(memSize, 4096L) - ElfFile.alignUp(fileSize, 4096L)) + (this.getProgramHeaderIsWritable(i) ? " writable" : " non writable"));
        }
    }

    public long getMappedAddressForLinux(ElfFile other) {
        if (other.getProgramHeaderType(0) != 1) {
            throw new RuntimeException("Expected loadable segment first");
        }
        if (other.getProgramHeaderType(1) != 1) {
            throw new RuntimeException("Expected loadable segment second");
        }
        if (other.getProgramHeaderIsWritable(0)) {
            throw new RuntimeException("Expected read-only first segment");
        }
        if (!other.getProgramHeaderIsWritable(1)) {
            throw new RuntimeException("Expected writabke second segment");
        }
        long fs1 = ElfFile.alignUp(other.getProgramHeaderSize(0), 4096L);
        long gap = other.getProgramHeaderAddress(1) - other.getProgramHeaderAddress(0);
        long mr1 = ElfFile.alignUp(other.getProgramHeaderSize(1), 4096L);
        long mr2 = ElfFile.alignUp(other.getProgramHeaderMemSize(1), 4096L) - mr1;
        for (int i = 0; i < this.getNrOfProgramHeaders(); ++i) {
            long address;
            if (this.getProgramHeaderSize(i) == 0L || ElfFile.alignUp(this.getProgramHeaderMemSize(i), 4096L) != fs1 || !this.rangeIsFileMapped(address = this.getProgramHeaderAddress(i) + gap, mr1) || !this.rangeIsFileMapped(address, mr2)) continue;
            return this.getProgramHeaderAddress(i) - other.getProgramHeaderAddress(0);
        }
        throw new RuntimeException("Could not match");
    }

    public int getSectionHeaderType(int index) {
        assert (index >= 0);
        assert (index < this.getNrOfSectionHeaders());
        return this.file.readInt32(this.sectionHeaderOffset + (long)(index * this.sectionHeaderEntrySize) + 4L);
    }

    public long getSectionHeaderOffset(int index) {
        assert (index >= 0);
        assert (index < this.getNrOfSectionHeaders());
        if (this.is32Bit) {
            return this.file.readUint32(this.sectionHeaderOffset + (long)(index * this.sectionHeaderEntrySize) + 16L);
        }
        return this.file.readInt64(this.sectionHeaderOffset + (long)(index * this.sectionHeaderEntrySize) + 24L);
    }

    public long getSectionHeaderSize(int index) {
        assert (index >= 0);
        assert (index < this.getNrOfSectionHeaders());
        if (this.is32Bit) {
            return this.file.readUint32(this.sectionHeaderOffset + (long)(index * this.sectionHeaderEntrySize) + 20L);
        }
        return this.file.readInt64(this.sectionHeaderOffset + (long)(index * this.sectionHeaderEntrySize) + 32L);
    }

    public long getSectionHeaderEntrySize(int index) {
        assert (index >= 0);
        assert (index < this.getNrOfSectionHeaders());
        if (this.is32Bit) {
            return this.file.readUint32(this.sectionHeaderOffset + (long)(index * this.sectionHeaderEntrySize) + 36L);
        }
        return this.file.readInt64(this.sectionHeaderOffset + (long)(index * this.sectionHeaderEntrySize) + 56L);
    }

    public String getSectionHeaderName(int index) {
        assert (index >= 0);
        assert (index < this.getNrOfSectionHeaders());
        return this.getStringTableEntry(this.file.readUint32(this.sectionHeaderOffset + (long)(index * this.sectionHeaderEntrySize)));
    }

    public String getStringFromStringTableEntry(long index) {
        long offset = this.getSectionHeaderOffset(this.sectionStrTabIndex);
        assert (index >= 0L);
        assert (index < this.getSectionHeaderSize(this.sectionStrTabIndex));
        return this.file.readUTF8String(offset + index);
    }

    public String getStringTableEntry(long index) {
        long offset = this.getSectionHeaderOffset(this.sectionHeaderNameIndex);
        assert (index >= 0L);
        assert (index < this.getSectionHeaderSize(this.sectionHeaderNameIndex));
        return this.file.readUTF8String(offset + index);
    }

    public String getDynamicStringTableEntry(long index) {
        long offset = this.getSectionHeaderOffset(this.dynamicNameIndex);
        assert (index >= 0L);
        assert (index < this.getSectionHeaderSize(this.dynamicNameIndex));
        return this.file.readUTF8String(offset + index);
    }

    public void printSectionHeader(PrintStream out) {
        for (int i = 0; i < this.getNrOfSectionHeaders(); ++i) {
            long type = this.getSectionHeaderType(i);
            long fileOffset = this.getSectionHeaderOffset(i);
            long fileSize = this.getSectionHeaderSize(i);
            long entrySize = this.getSectionHeaderEntrySize(i);
            String name = this.getSectionHeaderName(i);
            out.println("name: " + name + "type: 0x" + Long.toHexString(type) + " file offset 0x" + Long.toHexString(fileOffset) + " file size 0x" + Long.toHexString(fileSize) + " file size aligned 0x" + Long.toHexString(ElfFile.alignUp(fileSize, 4096L)) + " entry size 0x" + Long.toHexString(entrySize));
        }
    }

    private void addSymbols(int index, boolean isDynamic, ArrayList<Symbol> result) {
        long offset = this.getSectionHeaderOffset(index);
        long size = this.getSectionHeaderSize(index);
        long entrySize = this.getSectionHeaderEntrySize(index);
        if (this.is32Bit) {
            int nrOfEntries = (int)(size / entrySize);
            int i = 0;
            while (i < nrOfEntries) {
                String name = isDynamic ? this.getDynamicStringTableEntry(this.file.readUint32(offset)) : this.getStringFromStringTableEntry(this.file.readUint32(offset));
                long value = this.file.readUint32(offset + 4L);
                long sizeValue = this.file.readUint32(offset + 8L);
                int info = this.file.readInt8(offset + 12L) & 0xFF;
                char sectionIndex = this.file.readUint16(offset + 14L);
                result.add(new Symbol(name, value, sizeValue, info, sectionIndex));
                ++i;
                offset += entrySize;
            }
        } else {
            int nrOfEntries = (int)(size / entrySize);
            int i = 0;
            while (i < nrOfEntries) {
                String name = isDynamic ? this.getDynamicStringTableEntry(this.file.readUint32(offset)) : this.getStringTableEntry(this.file.readUint32(offset));
                long value = this.file.readInt64(offset + 8L);
                long sizeValue = this.file.readInt64(offset + 16L);
                int info = this.file.readInt8(offset + 4L) & 0xFF;
                char sectionIndex = this.file.readUint16(offset + 6L);
                result.add(new Symbol(name, value, sizeValue, info, sectionIndex));
                ++i;
                offset += entrySize;
            }
        }
    }

    public Symbol[] getSymbols() {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        for (int i = 0; i < this.getNrOfSectionHeaders(); ++i) {
            int type = this.getSectionHeaderType(i);
            if (type != 2 && type != 11) continue;
            this.addSymbols(i, type == 11, result);
        }
        return result.toArray(new Symbol[result.size()]);
    }

    public void printSymbols(PrintStream out) {
        for (Symbol symbol : this.getSymbols()) {
            out.println(symbol);
        }
    }

    public Dwarf2Parser getDwarf2Parser() {
        if (this.dwarfInfoIndex == -1 || this.dwarfAbbrIndex == -1 || this.dwarfStringIndex == -1) {
            return null;
        }
        return new Dwarf2Parser(this.file, this.getSectionHeaderOffset(this.dwarfInfoIndex), this.getSectionHeaderSize(this.dwarfInfoIndex), this.getSectionHeaderOffset(this.dwarfStringIndex), this.getSectionHeaderOffset(this.dwarfAbbrIndex), this.getSectionHeaderSize(this.dwarfAbbrIndex));
    }
}

