/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.impl.elf;

public class Symbol {
    public static final int TYPE_NO_TYPE = 0;
    public static final int TYPE_OBJECT = 1;
    public static final int TYPE_FUNCTION = 2;
    public static final int TYPE_SECTION = 3;
    public static final int TYPE_FILE = 4;
    public static final int BINDING_LOCAL = 0;
    public static final int BINDING_GLOBAL = 1;
    public static final int BINDING_WEAK = 2;
    private final String name;
    private final long value;
    private final long size;
    private final int info;
    private final int sectionIndex;

    public Symbol(String name, long value, long size, int info, int sectionIndex) {
        this.name = name;
        this.value = value;
        this.size = size;
        this.info = info;
        this.sectionIndex = sectionIndex;
    }

    public String getName() {
        return this.name;
    }

    public long getValue() {
        return this.value;
    }

    public long getSize() {
        return this.size;
    }

    public int getInfo() {
        return this.info;
    }

    public int getSectionIndex() {
        return this.sectionIndex;
    }

    public int getType() {
        return this.info & 0xF;
    }

    public int getBinding() {
        return this.info >>> 4;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.name);
        result.append(" Value: 0x" + Long.toHexString(this.value));
        result.append(" Size: 0x" + Long.toHexString(this.size));
        result.append(" Section Index: 0x" + Integer.toHexString(this.sectionIndex));
        result.append(" Info: 0x" + Integer.toHexString(this.info) + " (");
        switch (this.getType()) {
            case 0: {
                result.append("NO TYPE");
                break;
            }
            case 4: {
                result.append("FILE");
                break;
            }
            case 2: {
                result.append("FUNTION");
                break;
            }
            case 1: {
                result.append("OBJECT");
                break;
            }
            case 3: {
                result.append("SECTION");
                break;
            }
            default: {
                result.append("TYPE " + this.getType());
            }
        }
        result.append(", ");
        switch (this.getBinding()) {
            case 1: {
                result.append("GLOBAL");
                break;
            }
            case 0: {
                result.append("LOCAL");
                break;
            }
            case 2: {
                result.append("WEAK");
                break;
            }
            default: {
                result.append("OBINDING " + this.getBinding());
            }
        }
        result.append(')');
        return result.toString();
    }
}

