/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.impl.elf.hp;

import com.sap.jvm.tools.dumps.api.Dump;
import com.sap.jvm.tools.dumps.api.Memory;
import com.sap.jvm.tools.dumps.api.Module;
import com.sap.jvm.tools.dumps.api.SymbolResolver;
import com.sap.jvm.tools.dumps.impl.common.AbstractMemoryImpl;
import com.sap.jvm.tools.dumps.impl.common.Memory32;
import com.sap.jvm.tools.dumps.impl.common.Memory64;
import com.sap.jvm.tools.dumps.impl.common.MemoryRange;
import com.sap.jvm.tools.dumps.impl.elf.ElfFile;
import java.io.IOException;
import java.util.ArrayList;

public class HPCore
implements Dump {
    private static final int LOADABLE_START = 0x60000001;
    private static final int LOADABLE_END = 0x60000009;
    private final ElfFile core;
    private AbstractMemoryImpl memory;

    public HPCore(String fileName) throws IOException {
        this.core = new ElfFile(fileName);
        if (!this.core.isCore()) {
            throw new RuntimeException(fileName + " is not a core file");
        }
    }

    public boolean isHPCore() {
        for (int i = 0; i < this.core.getNrOfProgramHeaders(); ++i) {
            int type = this.core.getProgramHeaderType(i);
            if (type < 0x60000001 || type > 0x60000009) continue;
            return true;
        }
        return false;
    }

    @Override
    public Memory getMemory() {
        if (this.memory == null) {
            ArrayList<MemoryRange> ranges = new ArrayList<MemoryRange>();
            for (int i = 0; i < this.core.getNrOfProgramHeaders(); ++i) {
                long size;
                int type = this.core.getProgramHeaderType(i);
                if (type < 0x60000001 || type > 0x60000009 || (size = this.core.getProgramHeaderSize(i)) <= 0L) continue;
                long offset = this.core.getProgramHeaderOffset(i);
                long address = this.core.getProgramHeaderAddress(i);
                ranges.add(new MemoryRange(address, size, offset));
            }
            this.memory = this.core.is32Bit() ? new Memory32(this.core.getFile(), ranges) : new Memory64(this.core.getFile(), ranges);
        }
        return this.memory;
    }

    @Override
    public SymbolResolver getSymbolResolver() {
        throw new RuntimeException("No symbol information available");
    }

    @Override
    public Module getModuleFromName(String name) {
        throw new RuntimeException("No module information available");
    }
}

