/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.impl.elf.linux;

import com.sap.jvm.tools.dumps.api.Dump;
import com.sap.jvm.tools.dumps.api.Memory;
import com.sap.jvm.tools.dumps.api.Module;
import com.sap.jvm.tools.dumps.api.SymbolResolver;
import com.sap.jvm.tools.dumps.impl.common.AbstractMemoryImpl;
import com.sap.jvm.tools.dumps.impl.common.FileUtils;
import com.sap.jvm.tools.dumps.impl.common.Memory32;
import com.sap.jvm.tools.dumps.impl.common.Memory64;
import com.sap.jvm.tools.dumps.impl.common.MemoryRange;
import com.sap.jvm.tools.dumps.impl.common.SymbolResolverImpl;
import com.sap.jvm.tools.dumps.impl.elf.ElfFile;
import com.sap.jvm.tools.dumps.impl.elf.linux.ModuleImpl;
import java.io.IOException;
import java.util.ArrayList;

public class LinuxCore
implements Dump {
    private final ElfFile core;
    private final String[] directories;
    private AbstractMemoryImpl memory;

    public LinuxCore(String fileName, String ... dirs) throws IOException {
        this.directories = dirs;
        this.core = new ElfFile(fileName);
        if (!this.core.isCore()) {
            throw new RuntimeException(fileName + " is not a core file");
        }
    }

    @Override
    public Memory getMemory() {
        if (this.memory == null) {
            ArrayList<MemoryRange> ranges = new ArrayList<MemoryRange>();
            for (int i = 0; i < this.core.getNrOfProgramHeaders(); ++i) {
                long size;
                int type = this.core.getProgramHeaderType(i);
                if (type != 1 || (size = this.core.getProgramHeaderSize(i)) <= 0L) continue;
                long offset = this.core.getProgramHeaderOffset(i);
                long address = this.core.getProgramHeaderAddress(i);
                ranges.add(new MemoryRange(address, size, offset));
            }
            this.memory = this.core.is32Bit() ? new Memory32(this.core.getFile(), ranges) : new Memory64(this.core.getFile(), ranges);
        }
        return this.memory;
    }

    @Override
    public SymbolResolver getSymbolResolver() {
        return new SymbolResolverImpl(this);
    }

    @Override
    public Module getModuleFromName(String name) {
        String realName = name + ".so";
        int slashPos = name.lastIndexOf(47);
        realName = slashPos >= 0 ? realName.substring(0, slashPos) + "/lib" + realName.substring(slashPos + 1) : "lib" + realName;
        String file = FileUtils.findBestMatch(realName, this.directories);
        try {
            ElfFile elfFile = new ElfFile(file);
            return new ModuleImpl(elfFile, name, this.core.getMappedAddressForLinux(elfFile));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

