/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.impl.elf.linux;

import com.sap.jvm.tools.dumps.api.Module;
import com.sap.jvm.tools.dumps.impl.elf.Dwarf2Parser;
import com.sap.jvm.tools.dumps.impl.elf.ElfFile;
import com.sap.jvm.tools.dumps.impl.elf.Symbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ModuleImpl
implements Module {
    private final ElfFile file;
    private final String name;
    private final long addressOffset;
    private HashMap<String, Long> symbols;
    private HashMap<String, Integer> fieldOffsets;

    public ModuleImpl(ElfFile file, String name, long addressOffset) {
        this.file = file;
        this.name = name;
        this.addressOffset = addressOffset;
    }

    @Override
    public int getFieldOffset(String field) {
        Integer result;
        if (this.fieldOffsets == null) {
            Dwarf2Parser parser = this.file.getDwarf2Parser();
            this.fieldOffsets = parser != null ? parser.getFieldOffsets() : new HashMap();
        }
        if ((result = this.fieldOffsets.get(field)) == null) {
            return -1;
        }
        return result;
    }

    @Override
    public String[] getFields() {
        if (this.fieldOffsets == null) {
            Dwarf2Parser parser = this.file.getDwarf2Parser();
            this.fieldOffsets = parser != null ? parser.getFieldOffsets() : new HashMap();
        }
        ArrayList<String> result = new ArrayList<String>(this.fieldOffsets.keySet());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void ensureSymbols() {
        if (this.symbols != null) {
            return;
        }
        this.symbols = new HashMap();
        for (Symbol symbol : this.file.getSymbols()) {
            String demangledName;
            String rawName;
            if (symbol.getType() != 1 || (rawName = symbol.getName()).length() == 0 || rawName.indexOf(64) >= 0 || (demangledName = ModuleImpl.demangle(symbol.getName())) == null || this.symbols.containsKey(demangledName)) continue;
            this.symbols.put(demangledName, symbol.getValue() + this.addressOffset);
        }
    }

    @Override
    public long getSymbolAddress(String symbol) {
        this.ensureSymbols();
        Long result = this.symbols.get(symbol);
        if (result == null) {
            return -1L;
        }
        return result;
    }

    @Override
    public String[] getSymbols() {
        this.ensureSymbols();
        String[] result = new String[this.symbols.size()];
        int index = 0;
        Iterator<String> iterator = this.symbols.keySet().iterator();
        while (iterator.hasNext()) {
            String symbol;
            result[index] = symbol = iterator.next();
            ++index;
        }
        return result;
    }

    private static String demangle(String name) {
        if (!name.startsWith("_Z")) {
            return name;
        }
        if (name.charAt(2) != 'N') {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int offset = 3;
        while (name.charAt(offset) != 'E') {
            int intSize = 0;
            while (Character.isDigit(name.charAt(offset + intSize))) {
                ++intSize;
            }
            int size = Integer.parseInt(name.substring(offset, offset + intSize));
            String part = name.substring(offset += intSize, offset + size);
            offset += size;
            if (result.length() > 0) {
                result.append("::");
            }
            result.append(part);
        }
        return result.toString();
    }
}

