/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.impl.minidump;

import com.sap.jvm.tools.dumps.api.Dump;
import com.sap.jvm.tools.dumps.api.Memory;
import com.sap.jvm.tools.dumps.api.Module;
import com.sap.jvm.tools.dumps.api.SymbolResolver;
import com.sap.jvm.tools.dumps.impl.common.AbstractMemoryImpl;
import com.sap.jvm.tools.dumps.impl.common.LittleEndianDataFile;
import com.sap.jvm.tools.dumps.impl.common.Memory32;
import com.sap.jvm.tools.dumps.impl.common.Memory64;
import com.sap.jvm.tools.dumps.impl.common.MemoryRange;
import com.sap.jvm.tools.dumps.impl.common.SymbolResolverImpl;
import com.sap.jvm.tools.dumps.impl.minidump.Modules;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class MiniDump
implements Dump {
    private static final int SIGNATURE = 1347241037;
    private static final int MEMORY_LIST_32 = 5;
    private static final int MEMORY_LIST_64 = 9;
    private static final int SYSTEM_INFO = 7;
    private static final int MODULE_INFO = 4;
    private final int PROCESSOR_ARCHITECTURE_INTEL = 0;
    private final LittleEndianDataFile file;
    private AbstractMemoryImpl memory;
    private Modules modules;
    private SymbolResolverImpl symbolResolver;
    private final boolean is64Bit;
    private final String[] directories;

    public MiniDump(String fileName, String ... dirs) throws IOException {
        this.file = new LittleEndianDataFile(fileName);
        this.directories = dirs;
        long[] offsets = this.getLocationOffset(7);
        long offset = offsets[0];
        char processorType = this.readUint16(offset);
        this.is64Bit = processorType != '\u0000';
    }

    public void close() {
        this.file.close();
    }

    public boolean isMiniDump() {
        int signature = this.readInt32(0L);
        return signature == 1347241037;
    }

    public byte[] read(long offset, int size) {
        byte[] result = new byte[size];
        this.readBytes(result, 0, offset, size);
        return result;
    }

    public String readString(long offset) {
        int length = this.readInt32(offset) / 2;
        char[] text = new char[length];
        for (int i = 0; i < length; ++i) {
            text[i] = this.readUint16(offset + 4L + (long)(i * 2));
        }
        return new String(text);
    }

    public byte readInt8(long offset) {
        return this.file.readInt8(offset);
    }

    public short readInt16(long offset) {
        return this.file.readInt16(offset);
    }

    public char readUint16(long offset) {
        return this.file.readUint16(offset);
    }

    public int readInt32(long offset) {
        return this.file.readInt32(offset);
    }

    public long readUint32(long offset) {
        return this.file.readUint32(offset);
    }

    public long readInt64(long offset) {
        return this.file.readInt64(offset);
    }

    public String readUTF8String(long offset) {
        return this.file.readUTF8String(offset);
    }

    public void readBytes(byte[] result, int offset, long fileOffset, int size) {
        this.file.readBytes(result, offset, fileOffset, size);
    }

    @Override
    public Memory getMemory() {
        if (this.memory == null) {
            ArrayList<MemoryRange> ranges = new ArrayList<MemoryRange>();
            for (long offset : this.getLocationOffset(5)) {
                this.addList32(offset, ranges);
            }
            for (long offset : this.getLocationOffset(9)) {
                this.addList64(offset, ranges);
            }
            this.memory = this.is64Bit ? new Memory64(this.file, ranges) : new Memory32(this.file, ranges);
        }
        return this.memory;
    }

    private long[] getLocationOffset(int type) {
        long directoryOffset;
        ArrayList<Long> offsets = new ArrayList<Long>();
        long nrOfStreams = this.readUint32(8L);
        long offset = directoryOffset = this.readUint32(12L);
        for (long i = 0L; i < nrOfStreams; ++i) {
            long rva;
            int currType = this.readInt32(offset);
            if (MiniDump.offsetIsLarge(offset)) {
                rva = this.readInt64(offset + 12L);
                offset += 20L;
            } else {
                rva = this.readUint32(offset + 8L);
                offset += 12L;
            }
            if (currType != type) continue;
            offsets.add(rva);
        }
        long[] result = new long[offsets.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Long)offsets.get(i);
        }
        return result;
    }

    public static boolean offsetIsLarge(long offset) {
        return offset >= 0x100000000L;
    }

    public Modules getModules() {
        if (this.modules == null) {
            long[] offsets = this.getLocationOffset(4);
            this.modules = new Modules(this, offsets);
        }
        return this.modules;
    }

    public String[] getDirectories() {
        return this.directories;
    }

    @Override
    public SymbolResolver getSymbolResolver() {
        if (this.symbolResolver == null) {
            this.symbolResolver = new SymbolResolverImpl(this);
        }
        return this.symbolResolver;
    }

    private void addList32(long offset, ArrayList<MemoryRange> result) {
        long nrOfRanges = this.readUint32(offset);
        long curr = offset + 4L;
        for (long i = 0L; i < nrOfRanges; ++i) {
            long rva;
            long startAddress = this.readInt64(curr);
            long size = this.readInt64(curr += 8L);
            if (MiniDump.offsetIsLarge(curr += 8L)) {
                rva = this.readInt64(curr);
                curr += 8L;
            } else {
                rva = this.readUint32(curr);
                curr += 4L;
            }
            result.add(new MemoryRange(startAddress, size, rva));
        }
    }

    private void addList64(long offset, ArrayList<MemoryRange> result) {
        long nrOfRanges = this.readInt64(offset);
        long rva = this.readInt64(offset + 8L);
        for (long i = 0L; i < nrOfRanges; ++i) {
            long startAddress = this.readInt64(offset + 16L + i * 16L);
            long size = this.readInt64(offset + 24L + i * 16L);
            result.add(new MemoryRange(startAddress, size, rva));
            rva += size;
        }
    }

    @Override
    public Module getModuleFromName(String name) {
        Object[] foundModules = this.getModules().getModulesByName(name);
        if (foundModules.length == 0) {
            throw new RuntimeException("Could not find module " + name);
        }
        if (foundModules.length > 1) {
            throw new RuntimeException("Found more than one matching module: " + Arrays.toString(foundModules));
        }
        return foundModules[0];
    }
}

