/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.impl.minidump;

import com.sap.jvm.tools.dumps.api.Memory;
import com.sap.jvm.tools.dumps.api.Module;
import com.sap.jvm.tools.dumps.impl.common.FileUtils;
import com.sap.jvm.tools.dumps.impl.minidump.MiniDump;
import com.sap.jvm.tools.dumps.impl.minidump.PdbFile;

public class ModuleImpl
implements Module {
    private final short DOS_SIGNATURE = (short)23117;
    private final int PE_SIGNATURE = 17744;
    private final short TYPE_32 = (short)267;
    private final short TYPE_32_PLUS = (short)523;
    private final String name;
    private final String fileName;
    private final String fileNameWithoutSuffix;
    private final String pdbFileName;
    private PdbFile pdbFile;
    private final MiniDump dump;
    private final long[] sectionAddresses;
    private final long[] sectionSizes;

    ModuleImpl(MiniDump dump, String rawFileName, String rawPdbFile, long address) {
        boolean is64Bit;
        this.dump = dump;
        this.fileName = FileUtils.normalize(rawFileName);
        int dotPos = this.fileName.lastIndexOf(46);
        int slashPos = this.fileName.lastIndexOf(47);
        this.fileNameWithoutSuffix = dotPos > 0 && dotPos > slashPos ? this.fileName.substring(0, dotPos) : this.fileName;
        slashPos = this.fileNameWithoutSuffix.lastIndexOf(47);
        this.name = slashPos >= 0 ? this.fileNameWithoutSuffix.substring(slashPos + 1) : this.fileNameWithoutSuffix;
        this.pdbFileName = FileUtils.normalize(rawPdbFile);
        Memory memory = dump.getMemory();
        short dosSignature = memory.getInt16(address);
        if (dosSignature != 23117) {
            throw new RuntimeException("Expected DOS header at start im image");
        }
        int peOffset = memory.getInt32(address + 60L);
        int peSignature = memory.getInt32(address + (long)peOffset);
        if (peSignature != 17744) {
            throw new RuntimeException("Found no PE header");
        }
        int nrOfSections = memory.getUint16(address + (long)(peOffset += 4) + 2L);
        short type = memory.getInt16(address + (long)(peOffset += 20));
        boolean bl = is64Bit = type == 523;
        if (type != 267 && type != 523) {
            throw new RuntimeException("Unkown image type");
        }
        long sectionOffset = peOffset + 224;
        if (is64Bit) {
            sectionOffset += 16L;
        }
        this.sectionAddresses = new long[nrOfSections];
        this.sectionSizes = new long[nrOfSections];
        for (int i = 0; i < nrOfSections; ++i) {
            this.sectionAddresses[i] = memory.getUint32(address + sectionOffset + 12L + (long)(i * 40)) + address;
            this.sectionSizes[i] = memory.getUint32(address + sectionOffset + 16L + (long)(i * 40));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPdbFileName() {
        return this.pdbFileName;
    }

    public boolean matches(String toMatch) {
        if (!this.fileNameWithoutSuffix.endsWith(toMatch)) {
            return false;
        }
        if (toMatch.length() == this.fileNameWithoutSuffix.length()) {
            return true;
        }
        int slashPos = this.fileNameWithoutSuffix.length() - toMatch.length() - 1;
        return this.fileNameWithoutSuffix.charAt(slashPos) == '/';
    }

    private void ensurePdbFile() {
        if (this.pdbFile != null) {
            return;
        }
        if (this.pdbFileName == null) {
            return;
        }
        String realName = FileUtils.findBestMatch(this.pdbFileName, this.dump.getDirectories());
        if (realName == null) {
            throw new RuntimeException("Could not find PDF file for " + this.pdbFileName);
        }
        this.pdbFile = new PdbFile(this.dump, realName, this.sectionAddresses, this.sectionSizes);
    }

    @Override
    public long getSymbolAddress(String symbol) {
        this.ensurePdbFile();
        if (this.pdbFile != null) {
            return this.pdbFile.getAddress(symbol);
        }
        return -1L;
    }

    @Override
    public String[] getSymbols() {
        this.ensurePdbFile();
        if (this.pdbFile != null) {
            return this.pdbFile.getSymbols();
        }
        return new String[0];
    }

    @Override
    public int getFieldOffset(String field) {
        this.ensurePdbFile();
        if (this.pdbFile != null) {
            return this.pdbFile.getOffset(field);
        }
        return -1;
    }

    @Override
    public String[] getFields() {
        this.ensurePdbFile();
        if (this.pdbFile != null) {
            return this.pdbFile.getFields();
        }
        return new String[0];
    }
}

