/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.impl.minidump;

import com.sap.jvm.tools.dumps.impl.minidump.MiniDump;
import com.sap.jvm.tools.dumps.impl.minidump.ModuleImpl;
import java.util.ArrayList;

public final class Modules {
    private static final int PDB_70_SIGNATURE = 1396986706;
    private final ModuleImpl[] modules;

    public Modules(MiniDump dump, long[] offsets) {
        ArrayList<ModuleImpl> result = new ArrayList<ModuleImpl>();
        for (long offset : offsets) {
            int nrOfModules = dump.readInt32(offset);
            offset += 4L;
            for (int i = 0; i < nrOfModules; ++i) {
                int sig;
                long cvRva;
                long cvSize;
                long nameRva;
                long address = dump.readInt64(offset);
                if (MiniDump.offsetIsLarge(offset)) {
                    nameRva = dump.readInt64(offset + 20L);
                    offset += 28L;
                } else {
                    nameRva = dump.readUint32(offset + 20L);
                    offset += 24L;
                }
                String fileName = dump.readString(nameRva);
                if (MiniDump.offsetIsLarge(offset += 52L)) {
                    cvSize = dump.readInt64(offset);
                    cvRva = dump.readInt64(offset + 8L);
                    offset += 16L;
                } else {
                    cvSize = dump.readUint32(offset);
                    cvRva = dump.readUint32(offset + 4L);
                    offset += 8L;
                }
                String pdbFile = null;
                if (cvSize > 24L && (sig = dump.readInt32(cvRva)) == 1396986706) {
                    pdbFile = dump.readUTF8String(cvRva + 24L);
                }
                result.add(new ModuleImpl(dump, fileName, pdbFile, address));
                offset = MiniDump.offsetIsLarge(offset) ? (offset += 16L) : (offset += 8L);
                offset += 16L;
            }
        }
        this.modules = result.toArray(new ModuleImpl[result.size()]);
    }

    public ModuleImpl[] getModules() {
        return this.modules;
    }

    public ModuleImpl[] getModulesByName(String name) {
        ArrayList<ModuleImpl> result = new ArrayList<ModuleImpl>();
        for (ModuleImpl module : this.modules) {
            if (!module.matches(name)) continue;
            result.add(module);
        }
        return result.toArray(new ModuleImpl[result.size()]);
    }
}

