/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.impl.minidump;

import com.sap.jvm.tools.dumps.impl.common.LittleEndianDataFile;
import com.sap.jvm.tools.dumps.impl.minidump.MiniDump;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;

public class PdbFile {
    private static final int SIG_PART_1 = 1919117645;
    private static final int SIG_PART_2 = 1718580079;
    private static final int SIG_PART_3 = 792928372;
    private static final int SIG_PART_4 = 539700035;
    private static final int SIG_PART_5 = 541479757;
    private static final int SIG_PART_6 = 808463927;
    private static final int SIG_PART_7 = 1142557197;
    private static final int SIG_PART_8 = 83;
    private static final short LDATA_32 = 4364;
    private static final short GDATA_32 = 4365;
    private static final short FIELD_LIST = 4611;
    private static final short MEMBER = 5389;
    private static final int CLASS = 5380;
    private static final int STRUCT = 5381;
    private final HashMap<String, Long> symbolAddresses;
    private final HashMap<String, Integer> fieldOffsets;
    private final int[] rootPages;
    private final int[][] streamPages;
    private final int[] streamSizes;
    private final LittleEndianDataFile file;

    public PdbFile(MiniDump dump, String pdbFile, long[] sectionAddresses, long[] sectionSizes) {
        int i;
        try {
            this.file = new LittleEndianDataFile(pdbFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.symbolAddresses = new HashMap();
        this.fieldOffsets = new HashMap();
        if (this.file.readInt32(0L) != 1919117645) {
            throw new RuntimeException("Invalid PDB File");
        }
        if (this.file.readInt32(4L) != 1718580079) {
            throw new RuntimeException("Invalid PDB File");
        }
        if (this.file.readInt32(8L) != 792928372) {
            throw new RuntimeException("Invalid PDB File");
        }
        if (this.file.readInt32(12L) != 539700035) {
            throw new RuntimeException("Invalid PDB File");
        }
        if (this.file.readInt32(16L) != 541479757) {
            throw new RuntimeException("Invalid PDB File");
        }
        if (this.file.readInt32(20L) != 808463927) {
            throw new RuntimeException("Invalid PDB File");
        }
        if (this.file.readInt32(24L) != 1142557197) {
            throw new RuntimeException("Invalid PDB File");
        }
        if (this.file.readInt32(28L) != 83) {
            throw new RuntimeException("Invalid PDB File");
        }
        long offset = 32L;
        int pageSize = this.file.readInt32(offset);
        if (pageSize != 1024) {
            throw new RuntimeException("Page size must be 1024");
        }
        int rootStreamSize = this.file.readInt32(offset + 12L);
        int nrOfRootPages = (rootStreamSize + pageSize - 1) / pageSize;
        this.rootPages = new int[nrOfRootPages];
        int rootPageOffset = this.file.readInt32(offset + 20L) * pageSize;
        for (int i2 = 0; i2 < nrOfRootPages; ++i2) {
            this.rootPages[i2] = this.file.readInt32(rootPageOffset + i2 * 4) * pageSize;
        }
        int nrOfStreams = LittleEndianDataFile.getInt32(this.getFromStream(this.rootPages, 0, 4));
        this.streamPages = new int[nrOfStreams][];
        this.streamSizes = new int[nrOfStreams];
        int streamOffset = nrOfStreams * 4 + 4;
        for (i = 0; i < nrOfStreams; ++i) {
            this.streamSizes[i] = LittleEndianDataFile.getInt32(this.getFromStream(this.rootPages, i * 4 + 4, 4));
            int nrOfStreamPages = (this.streamSizes[i] + pageSize - 1) / pageSize;
            this.streamPages[i] = new int[nrOfStreamPages];
            for (int j = 0; j < nrOfStreamPages; ++j) {
                this.streamPages[i][j] = LittleEndianDataFile.getInt32(this.getFromStream(this.rootPages, streamOffset, 4)) * pageSize;
                streamOffset += 4;
            }
        }
        for (i = 0; i < nrOfStreams; ++i) {
            this.parseSymbolAddresses(this.streamPages[i], this.streamSizes[i], sectionAddresses, sectionSizes);
        }
        if (nrOfStreams >= 3) {
            this.parseFieldOffsets(this.streamPages[2], this.streamSizes[2], sectionAddresses, sectionSizes);
        }
    }

    private void parseSymbolAddresses(int[] pages, int size, long[] sectionAddresses, long[] sectionSizes) {
        int headerSize;
        char entrySize;
        if (size < 8) {
            return;
        }
        int version = LittleEndianDataFile.getInt32(this.getFromStream(pages, 0, 4));
        if (version == -1) {
            return;
        }
        for (int offset = headerSize = LittleEndianDataFile.getInt32(this.getFromStream(pages, 4, 4)); offset < size; offset += entrySize + 2) {
            char sectionIndex;
            entrySize = LittleEndianDataFile.getUint16(this.getFromStream(pages, offset, 2));
            char type = LittleEndianDataFile.getUint16(this.getFromStream(pages, offset + 2, 2));
            if (type != '\u110c' && type != '\u110d' || (sectionIndex = LittleEndianDataFile.getUint16(this.getFromStream(pages, offset + 12, 2))) <= '\u0000' || sectionIndex > sectionAddresses.length) continue;
            long sectionOffset = LittleEndianDataFile.getUint32(this.getFromStream(pages, offset + 8, 4));
            String name = this.readName(pages, offset + 14);
            long address = sectionAddresses[sectionIndex - '\u0001'] + sectionOffset;
            assert (!this.symbolAddresses.containsKey(name) || this.symbolAddresses.get(name).equals(address) || type == '\u110c');
            this.symbolAddresses.put(name, address);
        }
    }

    private void parseFieldOffsets(int[] pages, int size, long[] sectionAddresses, long[] sectionSizes) {
        if (size < 16) {
            return;
        }
        int version = LittleEndianDataFile.getInt32(this.getFromStream(pages, 0, 4));
        if (version == -1) {
            return;
        }
        int headerSize = LittleEndianDataFile.getInt32(this.getFromStream(pages, 4, 4));
        int indexStart = LittleEndianDataFile.getInt32(this.getFromStream(pages, 8, 4));
        int indexEnd = LittleEndianDataFile.getInt32(this.getFromStream(pages, 12, 4));
        int offset = headerSize;
        HashMap seenOffsets = new HashMap();
        for (int i = indexStart; i <= indexEnd; ++i) {
            int fieldListIndex;
            HashMap fieldList;
            char nrOfItems;
            char entrySize = LittleEndianDataFile.getUint16(this.getFromStream(pages, offset, 2));
            char type = LittleEndianDataFile.getUint16(this.getFromStream(pages, offset + 2, 2));
            if (type == '\u1203') {
                HashMap<String, Integer> fields = new HashMap<String, Integer>();
                int j = 2;
                while (j + 12 < entrySize) {
                    int nameLength;
                    char fieldOffset;
                    short fieldType = LittleEndianDataFile.getInt16(this.getFromStream(pages, offset + j + 2, 2));
                    if (fieldType == 5389 && (fieldOffset = LittleEndianDataFile.getUint16(this.getFromStream(pages, offset + j + 8 + 2, 2))) < '\u8000' && (nameLength = this.getNameLength(pages, offset + j + 10 + 2)) > 0 && nameLength + j + 10 < entrySize) {
                        fields.put(this.readName(pages, offset + j + 10 + 2), Integer.valueOf(fieldOffset));
                    }
                    ++j;
                }
                if (fields.size() > 0) {
                    seenOffsets.put(i, fields);
                }
            } else if (type == '\u1504' | type == '\u1505' && (nrOfItems = LittleEndianDataFile.getUint16(this.getFromStream(pages, offset + 4, 2))) > '\u0000' && (fieldList = (HashMap)seenOffsets.get(fieldListIndex = LittleEndianDataFile.getInt32(this.getFromStream(pages, offset + 8, 4)))) != null) {
                String name = this.readName(pages, offset + 22);
                for (String fieldName : fieldList.keySet()) {
                    this.fieldOffsets.put(name + "." + fieldName, (Integer)fieldList.get(fieldName));
                }
            }
            offset += entrySize + 2;
        }
    }

    private String readName(int[] pages, int offset) {
        int len = 0;
        while (this.getFromStream(pages, offset + len, 1)[0] != 0) {
            ++len;
        }
        byte[] raw = this.getFromStream(pages, offset, len);
        try {
            return new String(raw, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "<could not convert string>";
        }
    }

    private int getNameLength(int[] pages, int offset) {
        int len = 0;
        while (this.getFromStream(pages, offset + len, 1)[0] != 0) {
            ++len;
        }
        byte[] raw = this.getFromStream(pages, offset, len);
        try {
            new String(raw, "UTF-8");
            return len + 1;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private byte[] getFromStream(int[] pages, int offset, int size) {
        byte[] result = new byte[size];
        for (int i = offset; i < offset + size; ++i) {
            int pageOffset = i & 0x3FF;
            int page = i >> 10;
            result[i - offset] = this.file.readInt8(pages[page] + pageOffset);
        }
        return result;
    }

    public long getAddress(String name) {
        Long address = this.symbolAddresses.get(name);
        if (address == null) {
            return -1L;
        }
        return address;
    }

    public String[] getSymbols() {
        ArrayList<String> symbols = new ArrayList<String>(this.symbolAddresses.keySet());
        return symbols.toArray(new String[symbols.size()]);
    }

    public int getOffset(String field) {
        Integer offset = this.fieldOffsets.get(field);
        if (offset == null) {
            return -1;
        }
        return offset;
    }

    public String[] getFields() {
        ArrayList<String> fields = new ArrayList<String>(this.fieldOffsets.keySet());
        return fields.toArray(new String[fields.size()]);
    }
}

