/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.tools;

import com.sap.jvm.tools.console.Completor;
import com.sap.jvm.tools.console.ConsoleReader;
import com.sap.jvm.tools.dumps.api.Dump;
import com.sap.jvm.tools.dumps.api.DumpFactory;
import com.sap.jvm.tools.dumps.tools.DumpOperation;
import com.sap.jvm.tools.dumps.tools.jvm.operation.DumpFields;
import com.sap.jvm.tools.dumps.tools.jvm.operation.DumpMappedRegions;
import com.sap.jvm.tools.dumps.tools.jvm.operation.DumpMemory;
import com.sap.jvm.tools.dumps.tools.jvm.operation.DumpSymbolAddresses;
import com.sap.jvm.tools.dumps.tools.jvm.operation.ExamineOop;
import com.sap.jvm.tools.dumps.tools.jvm.operation.FindPrevOop;
import com.sap.jvm.tools.dumps.tools.jvm.operation.FindSymbolOfAddress;
import com.sap.jvm.tools.dumps.tools.jvm.operation.GetKlassOopByName;
import com.sap.jvm.tools.dumps.tools.jvm.operation.GetSubClasses;
import com.sap.jvm.tools.dumps.tools.jvm.operation.PrintInitialProperties;
import com.sap.jvm.tools.dumps.tools.jvm.operation.PrintKlassOop;
import com.sap.jvm.tools.dumps.tools.jvm.operation.PrintUTF8String;
import com.sap.jvm.tools.dumps.tools.jvm.operation.PrintVersion;
import com.sap.jvm.tools.dumps.tools.jvm.operation.SearchInCompleteHeap;
import com.sap.jvm.tools.dumps.tools.jvm.operation.SearchInHeap;
import com.sap.jvm.tools.dumps.tools.jvm.operation.SearchInJavaHeap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AnalyzeDump {
    private static final ArrayList<DumpOperation> operations = AnalyzeDump.getOperations();
    private static ConsoleReader input;
    private static ArrayList<String> history;
    private static Dump dump;

    public static void main(String[] args) throws IOException {
        if (args.length == 0 || args[0].equals("-h") || args[0].equals("--help")) {
            System.out.println("Syntax: AnalysDump <dump> [<dir> ...] <operation> [<arg> ...]");
            System.out.println();
            System.out.println("<dump>     : The name of the mini dump or core dump");
            System.out.println("<dir>      : A directory containing the needed PDB files or ");
            System.out.println("             the executables containing the debugging info");
            System.out.println("<arg>      : Additional arguments to performed operation");
            System.out.println("<operation>: The operation to perform. Add '-h' after the");
            System.out.println("             operation to get additional help.");
            System.out.println();
            System.out.println("If you don't supply an operation you will be taken into a");
            System.out.println("console, where you can enter them interactively.");
            System.out.println();
            System.out.println("The following operations are supported:");
            System.out.println();
            AnalyzeDump.showAvailableOperations();
            System.exit(1);
        }
        if (args.length == 1) {
            AnalyzeDump.runConsole(args);
        }
        int operationStart = 0;
        DumpOperation operation = null;
        block0: for (int i = 1; i < args.length; ++i) {
            for (int j = 0; j < operations.size(); ++j) {
                operation = operations.get(j);
                if (!args[i].equals(operation.getCommandName())) continue;
                operationStart = i;
                break block0;
            }
        }
        if (operationStart < 1) {
            AnalyzeDump.runConsole(args);
        }
        String[] dirs = new String[operationStart - 1];
        System.arraycopy(args, 1, dirs, 0, dirs.length);
        dump = DumpFactory.getDump(args[0], dirs);
        if (dump == null) {
            System.out.println("Could not parse the dump file '" + args[0] + "'");
            System.exit(1);
        }
        String[] arguments = new String[args.length - operationStart - 1];
        System.arraycopy(args, operationStart + 1, arguments, 0, arguments.length);
        operation.performOperation(dump, arguments);
    }

    private static ArrayList<DumpOperation> getOperations() {
        ArrayList<DumpOperation> result = new ArrayList<DumpOperation>();
        result.add(new PrintVersion());
        result.add(new PrintInitialProperties());
        result.add(new SearchInJavaHeap());
        result.add(new SearchInHeap());
        result.add(new GetKlassOopByName());
        result.add(new PrintKlassOop());
        result.add(new GetSubClasses());
        result.add(new DumpFields());
        result.add(new DumpSymbolAddresses());
        result.add(new DumpMemory());
        result.add(new DumpMappedRegions());
        result.add(new ExamineOop());
        result.add(new PrintUTF8String());
        result.add(new SearchInCompleteHeap());
        result.add(new FindSymbolOfAddress());
        result.add(new FindPrevOop());
        Collections.sort(result, new Comparator<DumpOperation>(){

            @Override
            public int compare(DumpOperation o1, DumpOperation o2) {
                return o1.getCommandName().compareTo(o2.getCommandName());
            }
        });
        return result;
    }

    private static void showAvailableOperations() {
        int maxCommandLength = 0;
        for (DumpOperation op : operations) {
            maxCommandLength = Math.max(maxCommandLength, op.getCommandName().length());
        }
        for (DumpOperation op : operations) {
            System.out.print(op.getCommandName());
            for (int i = op.getCommandName().length(); i < maxCommandLength; ++i) {
                System.out.print(' ');
            }
            System.out.println(" - " + op.getShortDescription());
        }
    }

    private static void runConsole(String[] args) throws IOException {
        String[] dirs = new String[args.length - 1];
        System.arraycopy(args, 1, dirs, 0, dirs.length);
        dump = DumpFactory.getDump(args[0], dirs);
        if (dump == null) {
            System.out.println("Could not parse the dump file '" + args[0] + "'");
            System.exit(1);
        }
        input = new ConsoleReader(new Completor(){

            @Override
            public void complete(String buffer, List<String> candidates) {
                AnalyzeDump.completeOperation(buffer, candidates);
            }
        });
        AnalyzeDump.commandLoop();
        System.exit(0);
    }

    private static void completeOperation(String soFar, List<String> result) {
        if (soFar.startsWith("help ")) {
            for (DumpOperation op : operations) {
                if (!("help " + op.getCommandName()).startsWith(soFar)) continue;
                result.add("help " + op.getCommandName());
            }
        }
        for (DumpOperation op : operations) {
            if (!op.getCommandName().startsWith(soFar)) continue;
            result.add(op.getCommandName());
        }
    }

    private static void commandLoop() throws IOException {
        String line;
        block2: while ((line = input.readLine(false)) != null) {
            if (line.trim().length() == 0) continue;
            if ("!!".equals(line) || "!".equals(line)) {
                if (history.size() <= 0) continue;
                String lastLine = history.get(history.size() - 1);
                System.out.println(lastLine);
                AnalyzeDump.handleCommand(lastLine);
                continue;
            }
            if (line.startsWith("!") && line.length() > 1) {
                String pattern = line.substring(1);
                int historyPos = -1;
                try {
                    historyPos = Integer.parseInt(pattern);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (historyPos >= 0 && historyPos < history.size()) {
                    String lastLine = history.get(historyPos);
                    System.out.println(lastLine);
                    AnalyzeDump.handleCommand(lastLine);
                    continue;
                }
                for (int i = history.size() - 1; i >= 0; --i) {
                    String lastLine = history.get(i);
                    if (!lastLine.startsWith(pattern)) continue;
                    System.out.println(lastLine);
                    AnalyzeDump.handleCommand(lastLine);
                    continue block2;
                }
                continue;
            }
            if (!AnalyzeDump.handleCommand(line)) continue;
            history.add(line);
        }
    }

    private static boolean handleCommand(String line) throws IOException {
        String[] splitted = line.split("\\s+");
        String cmd = splitted[0];
        String[] args = new String[splitted.length - 1];
        System.arraycopy(splitted, 1, args, 0, args.length);
        if ("help".equals(cmd)) {
            if (args.length == 0) {
                System.out.println("The following operations can be performed on the dump:");
                System.out.println();
                AnalyzeDump.showAvailableOperations();
                System.out.println();
                System.out.println("If you want a detailed description of an operation type:");
                System.out.println("help <operation>");
                System.out.println();
                System.out.println("Type 'exit' or 'quit' to exit");
            } else if (args.length == 1) {
                for (DumpOperation op : operations) {
                    if (!op.getCommandName().equals(args[0])) continue;
                    System.out.println(op.getLongDescription());
                }
            } else {
                System.out.println("Too many arguments to 'help'");
            }
            return true;
        }
        for (DumpOperation op : operations) {
            if (!cmd.equals(op.getCommandName())) continue;
            try {
                op.performOperation(dump, args);
                return true;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        if ("exit".equals(cmd) || "quit".equals(cmd)) {
            System.exit(0);
        }
        return true;
    }

    static {
        history = new ArrayList();
    }
}

