/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.tools;

import com.sap.jvm.tools.dumps.api.Dump;
import com.sap.jvm.tools.dumps.api.Memory;
import com.sap.jvm.tools.dumps.tools.DumpOperation;
import com.sap.jvm.tools.dumps.tools.jvm.Jvm;
import com.sap.jvm.tools.dumps.tools.jvm.JvmHeap;
import com.sap.jvm.tools.dumps.tools.jvm.JvmInformation;
import com.sap.jvm.tools.dumps.tools.jvm.JvmOops;
import java.util.HashMap;

public abstract class JvmDumpOperation
implements DumpOperation {
    protected static final int TAG_TYPE = 0;
    protected static final int TAG_MODULE = 1;
    protected static final int TAG_ADDRESS = 2;
    protected static final int TAG_END_ADDRESS = 3;
    protected static final int TAG_OFFSET = 4;
    protected static final int TAG_VALUE = 5;
    protected static final int TAG_NAME = 6;
    protected static final int TAG_SWITCH = 7;
    private final String commandName;
    private final String shortDescription;
    private final String longDescription;
    private final ArgumentSpec[] specs;
    protected Dump dump;
    protected Jvm jvm;
    protected Memory memory;
    protected JvmOops jvmOops;
    protected JvmHeap jvmHeap;
    protected JvmInformation jvmInformation;
    private long lastAddress;
    private boolean needsJvm;

    protected JvmDumpOperation(boolean needsJvm, String commandName, String shortDescription, String longDescription, ArgumentSpec ... specs) {
        this.needsJvm = needsJvm;
        this.commandName = commandName;
        this.specs = specs;
        this.shortDescription = shortDescription;
        this.longDescription = longDescription;
    }

    protected JvmDumpOperation(boolean needsJvm, String commandName, String description, ArgumentSpec ... specs) {
        this.needsJvm = needsJvm;
        this.commandName = commandName;
        this.specs = specs;
        this.shortDescription = description;
        this.longDescription = description;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public String getLongDescription() {
        StringBuilder result = new StringBuilder(this.longDescription);
        result.append("\n\nThe syntax of the comand is:\n");
        result.append(this.getCommandName());
        int maxNameLength = 0;
        for (ArgumentSpec spec : this.specs) {
            maxNameLength = Math.max(maxNameLength, spec.getName().length());
        }
        for (ArgumentSpec spec : this.specs) {
            result.append(" <");
            result.append(spec.name);
            result.append('>');
        }
        result.append("\n\n");
        for (ArgumentSpec spec : this.specs) {
            result.append(" <");
            result.append(spec.name);
            result.append('>');
            result.append(this.format(": " + spec.getDescription() + this.getTagHelp(spec.getTag()), maxNameLength - spec.name.length(), maxNameLength + 5, 120));
        }
        return result.toString();
    }

    private String getTagHelp(int tag) {
        switch (tag) {
            case 0: {
                return " This can be /1 for bytes, /2 for 2-byte integers, /4 for 4-byte integers, /8 for 8-byte integers and /a for addresses.";
            }
            case 2: {
                return " The address can be given in decimal or hexadecimal format. Additionally you can give the name of a symbol to use its address (e.g. jvm!MyClass::my_static_field). If you prefix the address with * not the address is used, but the address stored at the given address (e.g. *jvm!MyClass::static_pointer).";
            }
            case 3: {
                return " In additional to the normal address format you can specify the address as an offset to the start address by putting a + in front of an offset. The offset can be a decimal or hexadecimal number or a field name (e.g. jvm!MyClass._field) to use the offset of the field.";
            }
            case 4: {
                return " The offset can be a decimal or hexadecimal number or a field name (e.g. jvm!MyClass._field) to use the offset of the field.";
            }
            case 5: {
                return " The value can be given in decimal or hexadecimal format.";
            }
            case 1: {
                return " The module is the base name of the dll or shared library (e.g jvm for libjvm.so or jvm.dll).";
            }
        }
        return "";
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public void performOperation(Dump dump, String[] arguments) {
        int optionalArguments = 0;
        for (ArgumentSpec spec : this.specs) {
            if (spec.getTag() != 7) continue;
            ++optionalArguments;
        }
        if (arguments.length + optionalArguments < this.specs.length) {
            System.out.println("Not enough arguments where given !");
            System.out.println();
            System.out.println(this.getLongDescription());
            return;
        }
        if (arguments.length > this.specs.length) {
            System.out.println("Too many arguments where given !");
            System.out.println();
            System.out.println(this.getLongDescription());
            return;
        }
        this.dump = dump;
        HashMap<String, Argument> args = new HashMap<String, Argument>();
        int index = 0;
        block9: for (int i = 0; i < this.specs.length; ++i) {
            int tag = this.specs[i].getTag();
            String name = this.specs[i].getName();
            switch (tag) {
                case 0: {
                    args.put(name, new Argument(this.getTypeSize(arguments[index])));
                    ++index;
                    continue block9;
                }
                case 2: 
                case 3: {
                    this.lastAddress = this.parseAddress(arguments[index]);
                    ++index;
                    args.put(name, new Argument(this.lastAddress));
                    continue block9;
                }
                case 4: {
                    args.put(name, new Argument(this.parseOffset(arguments[index])));
                    ++index;
                    continue block9;
                }
                case 5: {
                    args.put(name, new Argument(this.parseValue(arguments[index])));
                    ++index;
                    continue block9;
                }
                case 1: 
                case 6: {
                    args.put(name, new Argument(arguments[index]));
                    ++index;
                    continue block9;
                }
                case 7: {
                    if (arguments[index].equals(name)) {
                        args.put(name, new Argument(1L));
                        ++index;
                        continue block9;
                    }
                    args.put(name, new Argument(0L));
                    continue block9;
                }
                default: {
                    throw new RuntimeException("Unknown tag " + tag);
                }
            }
        }
        if (this.needsJvm) {
            this.jvm = new Jvm(dump);
            this.jvmInformation = this.jvm.getJvmInformation();
            this.jvmHeap = this.jvm.getJvmHeap();
            this.jvmOops = this.jvm.getJvmOops();
        }
        this.memory = dump.getMemory();
        this.performOperation(args);
        this.jvm = null;
        this.jvmInformation = null;
        this.jvmHeap = null;
        this.jvmOops = null;
        this.memory = null;
        this.dump = null;
    }

    private String format(String str, int firstIndentation, int indentation, int maxLength) {
        int max = Math.max(maxLength, Math.max(firstIndentation, indentation) + 40);
        int indent = firstIndentation;
        int len = max - indent;
        String left = str;
        StringBuilder result = new StringBuilder();
        while (true) {
            int i;
            if (left.length() > 0 && Character.isWhitespace(left.charAt(0))) {
                left = left.substring(1);
                continue;
            }
            if (left.length() == 0) {
                return result.toString();
            }
            for (int i2 = 0; i2 < indent; ++i2) {
                result.append(' ');
            }
            if (left.length() <= len) {
                result.append(left);
                result.append('\n');
                return result.toString();
            }
            boolean printed = false;
            for (i = len - 1; i > 40; --i) {
                if (!Character.isWhitespace(left.charAt(i))) continue;
                result.append(left.substring(0, i));
                result.append('\n');
                left = left.substring(i + 1);
                printed = true;
                break;
            }
            if (!printed) {
                for (i = len; i < left.length(); ++i) {
                    if (!Character.isWhitespace(left.charAt(i))) continue;
                    result.append(left.substring(0, i));
                    result.append('\n');
                    left = left.substring(i + 1);
                    printed = true;
                    break;
                }
            }
            if (!printed) {
                result.append(left);
                result.append('\n');
                return result.toString();
            }
            indent = indentation;
            len = max - indent;
        }
    }

    protected final long parseAddress(String arg) {
        if (arg.startsWith("+")) {
            return this.lastAddress + (long)this.parseOffset(arg.substring(1));
        }
        if (arg.startsWith("0x")) {
            return this.parseLong(arg);
        }
        if (arg.contains("!")) {
            if (arg.startsWith("*")) {
                long address = this.dump.getSymbolResolver().getAddressOrFail(arg);
                return this.dump.getMemory().getAddress(address);
            }
            return this.dump.getSymbolResolver().getAddressOrFail(arg);
        }
        return Long.parseLong(arg);
    }

    protected final long parseValue(String arg) {
        return this.parseLong(arg);
    }

    protected final int parseOffset(String arg) {
        if (arg.startsWith("0x")) {
            return Integer.parseInt(arg.substring(2), 16);
        }
        if (arg.contains("!")) {
            return this.dump.getSymbolResolver().getOffsetOrFail(arg);
        }
        return Integer.parseInt(arg);
    }

    protected final int getTypeSize(String type) {
        if ("/1".equals(type)) {
            return 1;
        }
        if ("/2".equals(type)) {
            return 2;
        }
        if ("/4".equals(type)) {
            return 4;
        }
        if ("/8".equals(type)) {
            return 8;
        }
        if ("/a".equals(type)) {
            return this.dump.getMemory().getAddressSize();
        }
        throw new RuntimeException("Unkown type " + type);
    }

    private long parseLong(String arg) {
        if (arg.startsWith("0x")) {
            String p = "0" + arg.substring(2);
            long result = Long.parseLong(p.substring(0, p.length() - 1), 16) << 4;
            return result | Long.parseLong(p.substring(p.length() - 1), 16);
        }
        return Long.parseLong(arg);
    }

    protected abstract void performOperation(HashMap<String, Argument> var1);

    protected static class Argument {
        private long longValue;
        private String stringValue;

        public Argument(long value) {
            this.longValue = value;
        }

        public Argument(String value) {
            this.stringValue = value;
        }

        public long getLongValue() {
            return this.longValue;
        }

        public boolean getBooleanValue() {
            return this.longValue != 0L;
        }

        public int getIntValue() {
            return (int)(this.longValue & 0xFFFFFFFFL);
        }

        public String getStringValue() {
            return this.stringValue;
        }
    }

    protected static class ArgumentSpec {
        private final String name;
        private final String description;
        private final int tag;

        public ArgumentSpec(int tag, String name, String description) {
            this.tag = tag;
            this.name = name;
            this.description = description;
        }

        public int getTag() {
            return this.tag;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

