/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.tools.jvm;

import com.sap.jvm.tools.dumps.api.Dump;
import com.sap.jvm.tools.dumps.tools.jvm.DumpContentHolder;
import com.sap.jvm.tools.dumps.tools.jvm.JvmHeap;
import com.sap.jvm.tools.dumps.tools.jvm.JvmInformation;
import com.sap.jvm.tools.dumps.tools.jvm.JvmOops;
import java.io.UnsupportedEncodingException;

public class Jvm
extends DumpContentHolder {
    private JvmInformation jvmInformation;
    private JvmHeap jvmHeap;
    private JvmOops jvmOops;

    public Jvm(Dump dump) {
        super(dump);
    }

    public Dump getDump() {
        return this.dump;
    }

    public JvmInformation getJvmInformation() {
        if (this.jvmInformation == null) {
            this.jvmInformation = new JvmInformation(this);
        }
        return this.jvmInformation;
    }

    public JvmHeap getJvmHeap() {
        if (this.jvmHeap == null) {
            this.jvmHeap = new JvmHeap(this);
        }
        return this.jvmHeap;
    }

    public JvmOops getJvmOops() {
        if (this.jvmOops == null) {
            this.jvmOops = new JvmOops(this);
        }
        return this.jvmOops;
    }

    public String getCString(long address) {
        int offset = 0;
        while (this.memory.isMapped(address + (long)offset, 1)) {
            if (this.memory.getInt8(address + (long)offset) == 0) {
                return this.getCString(address, offset);
            }
            ++offset;
        }
        return this.getCString(address, offset) + " <plus unmapped data>";
    }

    public String getCString(long address, int length) {
        if (length <= 0) {
            return "";
        }
        if (!this.memory.isMapped(address, length)) {
            for (int i = length - 1; i > 0; --i) {
                if (!this.memory.isMapped(address, i)) continue;
                return this.getCString(address, i) + " <plus unmapped data>";
            }
            return "<not mapped>";
        }
        byte[] raw = new byte[length];
        for (int i = 0; i < length; ++i) {
            raw[i] = this.memory.getInt8(address + (long)i);
        }
        try {
            return new String(raw, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            for (int i = 0; i < length; ++i) {
                if (raw[i] >= 0) continue;
                raw[i] = 63;
            }
            try {
                return new String(raw, "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
                return "Could not convert string";
            }
        }
    }
}

