/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.tools.jvm;

import com.sap.jvm.tools.dumps.tools.jvm.DumpContentHolder;
import com.sap.jvm.tools.dumps.tools.jvm.Jvm;

public class JvmHeap
extends DumpContentHolder {
    public static final int EDEN_SPACE = 0;
    public static final int FROM_SPACE = 1;
    public static final int TO_SPACE = 2;
    public static final int OLD_SPACE = 3;
    public static final int PERM_SPACE = 4;
    private final long edenStart;
    private final long edenEnd;
    private final long edenUsedSize;
    private final long fromStart;
    private final long fromEnd;
    private final long fromUsedSize;
    private final long toStart;
    private final long toEnd;
    private final long toUsedSize;
    private final long oldStart;
    private final long oldEnd;
    private final long oldUsedSize;
    private final long permStart;
    private final long permEnd;
    private final long permUsedSize;
    private final boolean isCMS;

    JvmHeap(Jvm jvm) {
        super(jvm.getDump());
        long cmsPermGenOffset;
        long perm;
        long highOffset;
        long startOffset;
        long virtualSpace;
        long spaceOffset;
        if (this.memory.getBool(this.getAddress("jvm!UseParallelGC")) || this.memory.getBool(this.getAddress("jvm!UseParallelOldGC"))) {
            throw new RuntimeException("GC currently not supported");
        }
        long gch = this.memory.getAddress(this.getAddress("jvm!GenCollectedHeap::_gch"));
        long gens_offset = this.getOffset("jvm!GenCollectedHeap._gens");
        long youngGen = this.memory.getAddress(gch + gens_offset);
        long edenSpace = this.memory.getAddress(youngGen + (long)this.getOffset("jvm!DefNewGeneration._eden_space"));
        long fromSpace = this.memory.getAddress(youngGen + (long)this.getOffset("jvm!DefNewGeneration._from_space"));
        long toSpace = this.memory.getAddress(youngGen + (long)this.getOffset("jvm!DefNewGeneration._to_space"));
        long bottomOffset = this.getOffset("jvm!Space._bottom");
        long endOffset = this.getOffset("jvm!Space._end");
        long topOffset = this.getOffset("jvm!ContiguousSpace._top");
        this.edenStart = this.memory.getAddress(edenSpace + bottomOffset);
        this.edenEnd = this.memory.getAddress(edenSpace + endOffset);
        this.edenUsedSize = this.memory.getAddress(edenSpace + topOffset) - this.edenStart;
        this.fromStart = this.memory.getAddress(fromSpace + bottomOffset);
        this.fromEnd = this.memory.getAddress(fromSpace + endOffset);
        this.fromUsedSize = this.memory.getAddress(fromSpace + topOffset) - this.fromStart;
        this.toStart = this.memory.getAddress(toSpace + bottomOffset);
        this.toEnd = this.memory.getAddress(toSpace + endOffset);
        this.toUsedSize = this.memory.getAddress(toSpace + topOffset) - this.toStart;
        if (this.memory.getBool(this.getAddress("jvm!UseConcMarkSweepGC"))) {
            long oldGen = this.memory.getAddress(gch + gens_offset + (long)this.memory.getAddressSize());
            spaceOffset = this.getOffset("jvm!Generation._virtual_space");
            virtualSpace = oldGen + spaceOffset;
            startOffset = this.getOffset("jvm!VirtualSpace._low_boundary");
            endOffset = this.getOffset("jvm!VirtualSpace._high_boundary");
            highOffset = this.getOffset("jvm!VirtualSpace._high");
            this.oldStart = this.memory.getAddress(virtualSpace + startOffset);
            this.oldEnd = this.memory.getAddress(virtualSpace + endOffset);
            this.oldUsedSize = this.memory.getAddress(virtualSpace + highOffset) - this.oldStart;
            long permOffset = this.getOffset("jvm!SharedHeap._perm_gen");
            perm = this.memory.getAddress(gch + permOffset);
            try {
                cmsPermGenOffset = this.getOffset("jvm!CMSPermGen._gen");
            }
            catch (Exception e) {
                cmsPermGenOffset = 2 * this.memory.getAddressSize();
            }
        } else {
            throw new RuntimeException("GC currently not supported");
        }
        long permGen = this.memory.getAddress(perm + cmsPermGenOffset);
        virtualSpace = permGen + spaceOffset;
        this.permStart = this.memory.getAddress(virtualSpace + startOffset);
        this.permEnd = this.memory.getAddress(virtualSpace + endOffset);
        this.permUsedSize = this.memory.getAddress(virtualSpace + highOffset) - this.permStart;
        this.isCMS = true;
    }

    public long getSpaceStart(int space) {
        switch (space) {
            case 0: {
                return this.edenStart;
            }
            case 1: {
                return this.fromStart;
            }
            case 2: {
                return this.toStart;
            }
            case 3: {
                return this.oldStart;
            }
            case 4: {
                return this.permStart;
            }
        }
        throw new RuntimeException("Unknown space " + space);
    }

    public long getSpaceUsedSize(int space) {
        switch (space) {
            case 0: {
                return this.edenUsedSize;
            }
            case 1: {
                return this.fromUsedSize;
            }
            case 2: {
                return this.toUsedSize;
            }
            case 3: {
                return this.oldUsedSize;
            }
            case 4: {
                return this.permUsedSize;
            }
        }
        throw new RuntimeException("Unknown space " + space);
    }

    public long getSpaceEnd(int space) {
        switch (space) {
            case 0: {
                return this.edenEnd;
            }
            case 1: {
                return this.fromEnd;
            }
            case 2: {
                return this.toEnd;
            }
            case 3: {
                return this.oldEnd;
            }
            case 4: {
                return this.permEnd;
            }
        }
        throw new RuntimeException("Unknown space " + space);
    }

    public boolean isInUsedHeap(long address) {
        if (address >= this.edenStart && address < this.edenStart + this.edenUsedSize) {
            return true;
        }
        if (address >= this.fromStart && address < this.fromStart + this.fromUsedSize) {
            return true;
        }
        if (address >= this.toStart && address < this.toStart + this.toUsedSize) {
            return true;
        }
        if (address >= this.oldStart && address < this.oldStart + this.oldUsedSize) {
            return true;
        }
        return address >= this.permStart && address < this.permStart + this.permUsedSize;
    }

    public boolean isInUsedPerm(long address) {
        return address >= this.permStart && address < this.permStart + this.permUsedSize;
    }

    public boolean isCMS() {
        return this.isCMS;
    }
}

