/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.tools.jvm;

import com.sap.jvm.tools.dumps.tools.jvm.DumpContentHolder;
import com.sap.jvm.tools.dumps.tools.jvm.Jvm;
import java.util.HashMap;

public class JvmInformation
extends DumpContentHolder {
    private final Jvm jvm;
    private String vmVersionString;
    private HashMap<String, String> initialSystemProperties;

    JvmInformation(Jvm jvm) {
        super(jvm.getDump());
        this.jvm = jvm;
    }

    public HashMap<String, String> getInitialSystemProperties() {
        if (this.initialSystemProperties == null) {
            int keyOffset = this.getOffset("jvm!SystemProperty._key");
            int valueOffset = this.getOffset("jvm!SystemProperty._value");
            int nextOffset = this.getOffset("jvm!SystemProperty._next");
            long propertiesAddr = this.getAddress("jvm!Arguments::_system_properties");
            long properties = this.memory.getAddress(propertiesAddr);
            this.initialSystemProperties = new HashMap();
            while (properties != 0L) {
                String key = this.jvm.getCString(this.memory.getAddress(properties + (long)keyOffset));
                String value = this.jvm.getCString(this.memory.getAddress(properties + (long)valueOffset));
                properties = this.memory.getAddress(properties + (long)nextOffset);
                this.initialSystemProperties.put(key, value);
            }
        }
        return this.initialSystemProperties;
    }

    public String getVmVersionString() {
        if (this.vmVersionString == null) {
            HashMap<String, String> props = this.getInitialSystemProperties();
            this.vmVersionString = props.get("java.vm.name") + " (build " + props.get("java.vm.version") + ", " + props.get("java.vm.info") + ")";
        }
        return this.vmVersionString;
    }
}

