/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.tools.jvm;

import com.sap.jvm.tools.dumps.api.MemoryCallback;
import com.sap.jvm.tools.dumps.tools.jvm.DumpContentHolder;
import com.sap.jvm.tools.dumps.tools.jvm.Jvm;
import com.sap.jvm.tools.dumps.tools.jvm.JvmHeap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public final class JvmOops
extends DumpContentHolder {
    private final int symbolOopLengthOffset;
    private final int symbolOopNameOffset;
    private final int klassNameOffset;
    private final long symbolKlassAddress;
    private final long klassKlassAddress;
    private final long compilerICHolderKlassAddress;
    private final long constantPoolKlassAddress;
    private final long constantPoolCacheKlassAddress;
    private final long methodKlassAddress;
    private final long methodDataKlassAddress;
    private final long constMethodKlassAddress;
    private final long arrayKlassKlassAddress;
    private final long instanceKlassKlassAddress;
    private final long objArrayKlassKlassAddress;
    private final long systemObjArrayKlassKlassAddress;
    private final long typeArrayKlassKlassAddress;
    private final int klassOopOffset;
    private final int arrayLengthOffset;
    private final int layoutHelperOffset;
    private final HashMap<Long, Integer> shiftCache;
    private final Jvm jvm;

    JvmOops(Jvm jvm) {
        super(jvm.getDump());
        this.jvm = jvm;
        this.symbolOopLengthOffset = this.getOffset("jvm!symbolOopDesc._length");
        this.symbolOopNameOffset = this.getOffset("jvm!symbolOopDesc._body");
        this.klassNameOffset = this.getOffset("jvm!Klass._name");
        this.klassOopOffset = this.getOffset("jvm!oopDesc._klass");
        this.arrayLengthOffset = this.getOffset("jvm!arrayOopDesc._length");
        this.klassKlassAddress = this.memory.getAddress(this.getAddress("jvm!Universe::_klassKlassObj"));
        this.compilerICHolderKlassAddress = this.memory.getAddress(this.getAddress("jvm!Universe::_compiledICHolderKlassObj"));
        this.constantPoolKlassAddress = this.memory.getAddress(this.getAddress("jvm!Universe::_constantPoolKlassObj"));
        this.constantPoolCacheKlassAddress = this.memory.getAddress(this.getAddress("jvm!Universe::_constantPoolCacheKlassObj"));
        this.symbolKlassAddress = this.memory.getAddress(this.getAddress("jvm!Universe::_symbolKlassObj"));
        this.methodKlassAddress = this.memory.getAddress(this.getAddress("jvm!Universe::_methodKlassObj"));
        this.methodDataKlassAddress = this.memory.getAddress(this.getAddress("jvm!Universe::_methodDataKlassObj"));
        this.constMethodKlassAddress = this.memory.getAddress(this.getAddress("jvm!Universe::_constMethodKlassObj"));
        this.arrayKlassKlassAddress = this.memory.getAddress(this.getAddress("jvm!Universe::_arrayKlassKlassObj"));
        this.instanceKlassKlassAddress = this.memory.getAddress(this.getAddress("jvm!Universe::_instanceKlassKlassObj"));
        this.objArrayKlassKlassAddress = this.memory.getAddress(this.getAddress("jvm!Universe::_objArrayKlassKlassObj"));
        this.systemObjArrayKlassKlassAddress = this.memory.getAddress(this.getAddress("jvm!Universe::_systemObjArrayKlassObj"));
        this.typeArrayKlassKlassAddress = this.memory.getAddress(this.getAddress("jvm!Universe::_typeArrayKlassKlassObj"));
        this.layoutHelperOffset = this.getOffset("jvm!Klass._layout_helper");
        this.shiftCache = new HashMap();
    }

    public long getKlassOop(long address) {
        return this.memory.getAddress(address + (long)this.klassOopOffset);
    }

    public String getSymbolOopContent(long address) {
        assert (this.isSymbolKlass(this.getKlassOop(address)));
        return this.memory.getUTF8String(address + (long)this.symbolOopNameOffset, this.memory.getUint16(address + (long)this.symbolOopLengthOffset));
    }

    public long getKlassOopName(long address) {
        return this.memory.getAddress(this.klassOopToKlass(address) + (long)this.klassNameOffset);
    }

    public long klassOopToKlass(long address) {
        return address + (long)(2 * this.memory.getAddressSize());
    }

    public long klassToKlassOop(long address) {
        return address - (long)(2 * this.memory.getAddressSize());
    }

    public void visitKlassOops(MemoryCallback callback) {
        long dictAddress = this.getAddress("jvm!SystemDictionary::_dictionary");
        int oopEntryOffset = this.getOffset("jvm!HashtableEntry._literal");
        int nextEntryOffset = this.getOffset("jvm!BasicHashtableEntry._next");
        int hashTableSizeOffset = this.getOffset("jvm!BasicHashtable._table_size");
        int hashTableBucketsOffset = this.getOffset("jvm!BasicHashtable._buckets");
        long dict = this.memory.getAddress(dictAddress);
        int nrOfBuckets = this.memory.getInt32(dict + (long)hashTableSizeOffset);
        long buckets = this.memory.getAddress(dict + (long)hashTableBucketsOffset);
        for (int i = 0; i < nrOfBuckets; ++i) {
            long bucket = this.memory.getAddress(buckets + (long)(i * this.memory.getAddressSize()));
            while (bucket != 0L) {
                long klassOop = this.memory.getAddress(bucket + (long)oopEntryOffset);
                bucket = this.memory.getAddress(bucket + (long)nextEntryOffset);
                callback.visitAddress(klassOop);
            }
        }
    }

    public boolean isInSystemDictionary(final long address) {
        final boolean[] result = new boolean[1];
        this.visitKlassOops(new MemoryCallback(){

            @Override
            public void visitAddress(long addr) {
                if (addr == address) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    public long[] getKlassOopsByName(final String name) {
        final HashSet tmpResult = new HashSet();
        this.visitKlassOops(new MemoryCallback(){

            @Override
            public void visitAddress(long address) {
                long symbol = JvmOops.this.getKlassOopName(address);
                if (symbol != 0L && name.equals(JvmOops.this.getSymbolOopContent(symbol))) {
                    tmpResult.add(address);
                }
            }
        });
        long[] result = new long[tmpResult.size()];
        int index = 0;
        Iterator iterator = tmpResult.iterator();
        while (iterator.hasNext()) {
            long address;
            result[index] = address = ((Long)iterator.next()).longValue();
            ++index;
        }
        return result;
    }

    public long[] getAllSubKlasses(final long klassOop) {
        final HashSet tmpResult = new HashSet();
        final int superOffset = this.getOffset("jvm!Klass._super");
        this.visitKlassOops(new MemoryCallback(){

            @Override
            public void visitAddress(long address) {
                long klassKlassOop = JvmOops.this.getKlassOop(address);
                if (klassKlassOop != JvmOops.this.instanceKlassKlassAddress) {
                    return;
                }
                long superKlassOop = JvmOops.this.memory.getAddress(JvmOops.this.klassOopToKlass(address) + (long)superOffset);
                while (superKlassOop != 0L) {
                    if (superKlassOop == klassOop) {
                        tmpResult.add(address);
                        break;
                    }
                    superKlassOop = JvmOops.this.memory.getAddress(JvmOops.this.klassOopToKlass(superKlassOop) + (long)superOffset);
                }
            }
        });
        long[] result = new long[tmpResult.size()];
        int index = 0;
        Iterator iterator = tmpResult.iterator();
        while (iterator.hasNext()) {
            long address;
            result[index] = address = ((Long)iterator.next()).longValue();
            ++index;
        }
        return result;
    }

    public boolean isKlassKlass(long address) {
        return address == this.klassKlassAddress;
    }

    public boolean isSymbolKlass(long address) {
        return address == this.symbolKlassAddress;
    }

    public boolean isMethodKlass(long address) {
        return address == this.methodKlassAddress;
    }

    public boolean isMethodDataKlass(long address) {
        return address == this.methodDataKlassAddress;
    }

    public boolean isConstMethodKlass(long address) {
        return address == this.constMethodKlassAddress;
    }

    public boolean isConstantPoolKlass(long address) {
        return address == this.constantPoolKlassAddress;
    }

    public boolean isConstantPoolCacheKlass(long address) {
        return address == this.constantPoolCacheKlassAddress;
    }

    public boolean isArrayKlassKlass(long address) {
        return address == this.arrayKlassKlassAddress;
    }

    public boolean isObjArrayKlassKlass(long address) {
        return address == this.objArrayKlassKlassAddress;
    }

    public boolean isTypeArrayKlassKlass(long address) {
        return address == this.typeArrayKlassKlassAddress;
    }

    public boolean isSystemObjArrayKlassKlass(long address) {
        return address == this.systemObjArrayKlassKlassAddress;
    }

    public boolean isInstanaceKlassKlass(long address) {
        return address == this.instanceKlassKlassAddress;
    }

    public boolean isCompiledICHolderKlass(long address) {
        return address == this.compilerICHolderKlassAddress;
    }

    public boolean isSingletonKlass(long address) {
        return this.isKlassKlass(address) || this.isSymbolKlass(address) || this.isMethodKlass(address) || this.isConstMethodKlass(address) || this.isMethodDataKlass(address) || this.isArrayKlassKlass(address) || this.isObjArrayKlassKlass(address) || this.isSystemObjArrayKlassKlass(address) || this.isTypeArrayKlassKlass(address) || this.isInstanaceKlassKlass(address) || this.isConstantPoolKlass(address) || this.isConstantPoolCacheKlass(address) || this.isCompiledICHolderKlass(address);
    }

    public String getInstanceKlassName(long klassOop) {
        assert (this.isInstanaceKlassKlass(this.getKlassOop(klassOop)));
        return this.getSymbolOopContent(this.getKlassOopName(klassOop)).replace('/', '.');
    }

    public String getTypeArrayKlassName(long klassOop) {
        assert (this.isTypeArrayKlassKlass(this.getKlassOop(klassOop)));
        String raw = this.getSymbolOopContent(this.getKlassOopName(klassOop));
        if ("[B".equals(raw)) {
            return "byte[]";
        }
        if ("[Z".equals(raw)) {
            return "boolean[]";
        }
        if ("[S".equals(raw)) {
            return "short[]";
        }
        if ("[C".equals(raw)) {
            return "char[]";
        }
        if ("[I".equals(raw)) {
            return "int[]";
        }
        if ("[J".equals(raw)) {
            return "long[]";
        }
        if ("[F".equals(raw)) {
            return "float[]";
        }
        if ("[D".equals(raw)) {
            return "double[]";
        }
        return raw;
    }

    public long getOopSize(long oop) {
        long klassOop = this.getKlassOop(oop);
        long klassKlassOop = this.getKlassOop(klassOop);
        if (this.isTypeArrayKlassKlass(klassKlassOop)) {
            Integer shift = this.shiftCache.get(klassOop);
            if (shift == null) {
                String raw = this.getSymbolOopContent(this.getKlassOopName(klassOop));
                if ("[B".equals(raw)) {
                    shift = 0;
                } else if ("[Z".equals(raw)) {
                    shift = 0;
                } else if ("[S".equals(raw)) {
                    shift = 1;
                } else if ("[C".equals(raw)) {
                    shift = 1;
                } else if ("[I".equals(raw)) {
                    shift = 2;
                } else if ("[J".equals(raw)) {
                    shift = 4;
                } else if ("[F".equals(raw)) {
                    shift = 2;
                } else if ("[D".equals(raw)) {
                    shift = 4;
                }
                this.shiftCache.put(klassOop, shift);
            }
            int size = 1 << shift;
            long length = this.getArrayLength(oop);
            long start = oop + (long)this.arrayLengthOffset + (long)this.memory.getAddressSize() + (long)size - 1L & (long)(~(size - 1));
            long end = start + length * (long)size + 7L & 0xFFFFFFFFFFFFFFF8L;
            return end - oop;
        }
        if (this.isObjArrayKlassKlass(klassKlassOop) || this.isSystemObjArrayKlassKlass(klassKlassOop)) {
            int size = this.memory.getAddressSize();
            long length = this.getArrayLength(oop);
            long start = oop + (long)this.arrayLengthOffset + 4L + (long)size - 1L & (long)(~(size - 1));
            long end = start + length * (long)size + 7L & 0xFFFFFFFFFFFFFFF8L;
            return end - oop;
        }
        if (this.isInstanaceKlassKlass(klassKlassOop)) {
            int size = this.memory.getInt32(this.klassOopToKlass(klassOop) + (long)this.layoutHelperOffset);
            assert (size > 0);
            return size;
        }
        if (this.isSymbolKlass(klassOop)) {
            char length = this.memory.getUint16(oop + (long)this.symbolOopLengthOffset);
            long end = oop + (long)this.symbolOopNameOffset + (long)length + 7L & 0xFFFFFFFFFFFFFFF8L;
            return end - oop;
        }
        return -1L;
    }

    public int getArrayLength(long oop) {
        assert (this.isArrayKlassKlass(this.getKlassOop(this.getKlassOop(oop))) || this.isObjArrayKlassKlass(this.getKlassOop(this.getKlassOop(oop))) || this.isSystemObjArrayKlassKlass(this.getKlassOop(this.getKlassOop(oop))) || this.isTypeArrayKlassKlass(this.getKlassOop(this.getKlassOop(oop))));
        return this.memory.getInt32(oop + (long)this.arrayLengthOffset);
    }

    private String getInvalidOopReasonImpl(int level, long oop) {
        if ((oop & 7L) != 0L) {
            return "The " + JvmOops.getLevelName(level) + " is not properly aligned";
        }
        JvmHeap heap = this.jvm.getJvmHeap();
        if (!heap.isInUsedHeap(oop)) {
            return "The " + JvmOops.getLevelName(level) + " is not properly aligned";
        }
        if (!this.memory.isMapped(oop, 2 * this.memory.getAddressSize())) {
            return "The address of the " + JvmOops.getLevelName(level) + " is not mapped";
        }
        JvmOops oops = this.jvm.getJvmOops();
        if (oops.isSingletonKlass(oop)) {
            return null;
        }
        if (level == 3) {
            return "The " + JvmOops.getLevelName(level) + " must be a leaf klass";
        }
        long klassOop = this.getKlassOop(oop);
        String klassReason = this.getInvalidOopReasonImpl(level + 1, klassOop);
        if (klassReason != null) {
            return klassReason;
        }
        long klassKlassOop = this.getKlassOop(klassOop);
        if (this.isArrayKlassKlass(klassKlassOop) || this.isObjArrayKlassKlass(klassKlassOop) || this.isSystemObjArrayKlassKlass(klassKlassOop) || this.isInstanaceKlassKlass(klassKlassOop) || this.isTypeArrayKlassKlass(klassKlassOop)) {
            return null;
        }
        if (!heap.isInUsedPerm(oop)) {
            return "The " + JvmOops.getLevelName(level) + " must be in the perm generation";
        }
        return null;
    }

    private static String getLevelName(int level) {
        if (level == 0) {
            return "oop";
        }
        if (level == 1) {
            return "klass oop";
        }
        if (level == 2) {
            return "klass klass oop";
        }
        return "klass klass klass oop";
    }

    private boolean isValidOopImpl(int level, long oop) {
        if ((oop & 7L) != 0L) {
            return false;
        }
        JvmHeap heap = this.jvm.getJvmHeap();
        if (!heap.isInUsedHeap(oop)) {
            return false;
        }
        if (!this.memory.isMapped(oop, 2 * this.memory.getAddressSize())) {
            return false;
        }
        JvmOops oops = this.jvm.getJvmOops();
        if (oops.isSingletonKlass(oop)) {
            return true;
        }
        if (level == 3) {
            return false;
        }
        long klassOop = this.getKlassOop(oop);
        if (!this.isValidOopImpl(level, klassOop)) {
            return false;
        }
        long klassKlassOop = this.getKlassOop(klassOop);
        if (this.isArrayKlassKlass(klassKlassOop) || this.isObjArrayKlassKlass(klassKlassOop) || this.isSystemObjArrayKlassKlass(klassKlassOop) || this.isInstanaceKlassKlass(klassKlassOop) || this.isTypeArrayKlassKlass(klassKlassOop)) {
            return true;
        }
        return heap.isInUsedPerm(oop);
    }

    public boolean isValidOop(long oop) {
        return this.isValidOopImpl(0, oop);
    }

    public String getInvalidOopReason(long oop) {
        assert (!this.isValidOop(oop));
        return this.getInvalidOopReasonImpl(0, oop);
    }

    public String getOopType(long oop) {
        assert (this.isValidOop(oop));
        JvmOops jvmOops = this.jvm.getJvmOops();
        if (jvmOops.isKlassKlass(oop)) {
            return "The oop is the klassKlassOop";
        }
        if (jvmOops.isSymbolKlass(oop)) {
            return "The oop is the symbolKlassOop";
        }
        if (jvmOops.isMethodKlass(oop)) {
            return "The oop is the methodKlassOop";
        }
        if (jvmOops.isMethodDataKlass(oop)) {
            return "The oop is the methoDataKlassOop";
        }
        if (jvmOops.isConstMethodKlass(oop)) {
            return "The oop is the constMethodKlassOop";
        }
        if (jvmOops.isArrayKlassKlass(oop)) {
            return "The oop is the arrayKlassKlassOop";
        }
        if (jvmOops.isObjArrayKlassKlass(oop)) {
            return "The oop is the objArrayKlassKlassOop";
        }
        if (jvmOops.isSystemObjArrayKlassKlass(oop)) {
            return "The oop is the systemObjArrayKlassKlassOop";
        }
        if (jvmOops.isTypeArrayKlassKlass(oop)) {
            return "The oop is the typeArrayKlassKlassOop";
        }
        if (jvmOops.isInstanaceKlassKlass(oop)) {
            return "The oop is the instanceKlassKlassOop";
        }
        if (jvmOops.isConstantPoolKlass(oop)) {
            return "The oop is the constantPoolKlassOop";
        }
        if (jvmOops.isConstantPoolCacheKlass(oop)) {
            return "The oop is the constPoolCacheKlassOop";
        }
        if (jvmOops.isCompiledICHolderKlass(oop)) {
            return "The oop is the compiledICHolderKlassOop";
        }
        long klassOop = this.getKlassOop(oop);
        if (jvmOops.isSymbolKlass(klassOop)) {
            return "The oop is a symbolOop with the follwing content:";
        }
        if (jvmOops.isKlassKlass(klassOop)) {
            return "The oop is a klass klass but *not* one of the known !!!";
        }
        if (jvmOops.isMethodKlass(klassOop)) {
            return "The oop is a method oop";
        }
        if (jvmOops.isConstMethodKlass(klassOop)) {
            return "The oop is a const method oop";
        }
        if (jvmOops.isMethodDataKlass(klassOop)) {
            return "The oop is a method data oop";
        }
        if (jvmOops.isArrayKlassKlass(klassOop)) {
            return "The oop is an array klass oop";
        }
        if (jvmOops.isObjArrayKlassKlass(klassOop)) {
            return "The oop is an object array klass oop";
        }
        if (jvmOops.isSystemObjArrayKlassKlass(klassOop)) {
            return "The oop is a system object array klass oop";
        }
        if (jvmOops.isTypeArrayKlassKlass(klassOop)) {
            return "The oop is a type array klass oop";
        }
        if (jvmOops.isInstanaceKlassKlass(klassOop)) {
            return "The oop is an instance klass oop";
        }
        if (jvmOops.isConstantPoolKlass(klassOop)) {
            return "The oop is a constant pool oop";
        }
        if (jvmOops.isConstantPoolCacheKlass(klassOop)) {
            return "The oop is a constant pool cache oop";
        }
        if (jvmOops.isCompiledICHolderKlass(klassOop)) {
            return "The oop is a compiled IC holder oop";
        }
        long klassKlassOop = jvmOops.getKlassOop(klassOop);
        if (jvmOops.isObjArrayKlassKlass(klassKlassOop)) {
            return "The oop is an object array oop";
        }
        if (jvmOops.isSystemObjArrayKlassKlass(klassKlassOop)) {
            return "The oop is a system object array oop";
        }
        if (jvmOops.isArrayKlassKlass(klassKlassOop)) {
            return "The oop is an array oop";
        }
        if (jvmOops.isTypeArrayKlassKlass(klassKlassOop)) {
            return "The oop is a type array oop";
        }
        if (jvmOops.isInstanaceKlassKlass(klassKlassOop)) {
            return "The oop is an instance oop";
        }
        return "The type of the oop could not be determined";
    }

    public String getOopContentDescription(long oop) {
        long klassOop;
        assert (this.isValidOop(oop));
        JvmOops jvmOops = this.jvm.getJvmOops();
        if (jvmOops.isSymbolKlass(klassOop = jvmOops.getKlassOop(oop))) {
            return "symbol oop content: \"" + jvmOops.getSymbolOopContent(oop) + "\"";
        }
        if (jvmOops.isTypeArrayKlassKlass(klassOop)) {
            return "Represent type " + this.getTypeArrayKlassName(klassOop);
        }
        if (jvmOops.isInstanaceKlassKlass(klassOop)) {
            return "Represents the class " + jvmOops.getInstanceKlassName(oop);
        }
        long klassKlassOop = jvmOops.getKlassOop(klassOop);
        if (jvmOops.isObjArrayKlassKlass(klassKlassOop) || jvmOops.isSystemObjArrayKlassKlass(klassKlassOop) || jvmOops.isArrayKlassKlass(klassKlassOop)) {
            return "The array has " + jvmOops.getArrayLength(oop) + " elements";
        }
        if (jvmOops.isTypeArrayKlassKlass(klassKlassOop)) {
            return "The array is of type " + this.getTypeArrayKlassName(klassOop) + " has " + jvmOops.getArrayLength(oop) + " elements";
        }
        if (jvmOops.isInstanaceKlassKlass(klassKlassOop)) {
            return "The class of the instance is " + jvmOops.getInstanceKlassName(klassOop);
        }
        return null;
    }
}

