/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.tools.jvm.operation;

import com.sap.jvm.tools.dumps.tools.JvmDumpOperation;
import java.util.HashMap;

public class DumpMemory
extends JvmDumpOperation {
    private static final char[] toHexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DumpMemory() {
        super(false, "DumpMemory", "Dumps the content of a memory region", new JvmDumpOperation.ArgumentSpec(0, "type", "The type to display."), new JvmDumpOperation.ArgumentSpec(2, "start", "The start address."), new JvmDumpOperation.ArgumentSpec(3, "end", "The end address."));
    }

    @Override
    protected void performOperation(HashMap<String, JvmDumpOperation.Argument> args) {
        long start = args.get("start").getLongValue();
        long end = args.get("end").getLongValue();
        int typeSize = args.get("type").getIntValue();
        int entriesInLine = 0;
        int bytesPerLine = 32;
        StringBuilder hexLine = new StringBuilder();
        StringBuilder charLine = new StringBuilder();
        long address = start;
        while (true) {
            int i;
            if (this.memory.isMapped(address, typeSize)) {
                int val;
                if (typeSize == 1) {
                    val = this.memory.getInt8(address);
                    hexLine.append(DumpMemory.getHexChar(val >>> 4 & 0xF));
                    hexLine.append(DumpMemory.getHexChar(val & 0xF));
                } else if (typeSize == 2) {
                    val = this.memory.getInt16(address);
                    hexLine.append(DumpMemory.getHexChar(val >>> 12 & 0xF));
                    hexLine.append(DumpMemory.getHexChar(val >>> 8 & 0xF));
                    hexLine.append(DumpMemory.getHexChar(val >>> 4 & 0xF));
                    hexLine.append(DumpMemory.getHexChar(val & 0xF));
                } else if (typeSize == 4) {
                    val = this.memory.getInt32(address);
                    hexLine.append(DumpMemory.getHexChar(val >>> 28 & 0xF));
                    hexLine.append(DumpMemory.getHexChar(val >>> 24 & 0xF));
                    hexLine.append(DumpMemory.getHexChar(val >>> 20 & 0xF));
                    hexLine.append(DumpMemory.getHexChar(val >>> 16 & 0xF));
                    hexLine.append(DumpMemory.getHexChar(val >>> 12 & 0xF));
                    hexLine.append(DumpMemory.getHexChar(val >>> 8 & 0xF));
                    hexLine.append(DumpMemory.getHexChar(val >>> 4 & 0xF));
                    hexLine.append(DumpMemory.getHexChar(val & 0xF));
                } else if (typeSize == 8) {
                    long val2 = this.memory.getInt64(address);
                    hexLine.append(DumpMemory.getHexChar(val2 >>> 60 & 0xFL));
                    hexLine.append(DumpMemory.getHexChar(val2 >>> 56 & 0xFL));
                    hexLine.append(DumpMemory.getHexChar(val2 >>> 52 & 0xFL));
                    hexLine.append(DumpMemory.getHexChar(val2 >>> 48 & 0xFL));
                    hexLine.append(DumpMemory.getHexChar(val2 >>> 44 & 0xFL));
                    hexLine.append(DumpMemory.getHexChar(val2 >>> 40 & 0xFL));
                    hexLine.append(DumpMemory.getHexChar(val2 >>> 36 & 0xFL));
                    hexLine.append(DumpMemory.getHexChar(val2 >>> 32 & 0xFL));
                    hexLine.append(DumpMemory.getHexChar(val2 >>> 28 & 0xFL));
                    hexLine.append(DumpMemory.getHexChar(val2 >>> 24 & 0xFL));
                    hexLine.append(DumpMemory.getHexChar(val2 >>> 20 & 0xFL));
                    hexLine.append(DumpMemory.getHexChar(val2 >>> 16 & 0xFL));
                    hexLine.append(DumpMemory.getHexChar(val2 >>> 12 & 0xFL));
                    hexLine.append(DumpMemory.getHexChar(val2 >>> 8 & 0xFL));
                    hexLine.append(DumpMemory.getHexChar(val2 >>> 4 & 0xFL));
                    hexLine.append(DumpMemory.getHexChar(val2 & 0xFL));
                }
                hexLine.append(' ');
                for (i = 0; i < typeSize; ++i) {
                    byte val3 = this.memory.getInt8(address + (long)i);
                    char asChar = (char)(val3 & 0xFF);
                    if (Character.isISOControl(asChar)) {
                        charLine.append('.');
                        continue;
                    }
                    charLine.append(asChar);
                }
            } else {
                for (i = 0; i < typeSize * 2; ++i) {
                    hexLine.append('?');
                }
                hexLine.append(' ');
                for (i = 0; i < typeSize; ++i) {
                    charLine.append('.');
                }
            }
            if ((entriesInLine += typeSize) != bytesPerLine && (address += (long)typeSize) != end) continue;
            System.out.print("0x");
            System.out.print(Long.toHexString(address - (long)entriesInLine));
            System.out.print(": ");
            System.out.print(hexLine);
            System.out.print(" | ");
            System.out.println(charLine);
            if (address == end) {
                return;
            }
            hexLine = new StringBuilder();
            charLine = new StringBuilder();
            entriesInLine = 0;
        }
    }

    private static char getHexChar(long value) {
        return toHexArray[(int)value];
    }
}

