/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.tools.jvm.operation;

import com.sap.jvm.tools.dumps.tools.JvmDumpOperation;
import java.util.HashMap;

public class ExamineOop
extends JvmDumpOperation {
    public ExamineOop() {
        super(true, "ExamineOop", "Examines a possible oop", new JvmDumpOperation.ArgumentSpec(2, "address", "The address of the oop."));
    }

    @Override
    protected void performOperation(HashMap<String, JvmDumpOperation.Argument> args) {
        long address = args.get("address").getLongValue();
        if (!this.checkIsInHeap(address)) {
            return;
        }
        if (!this.memory.isMapped(address, 2 * this.memory.getAddressSize())) {
            System.out.println("The memory at that address is *not* mapped !");
            return;
        }
        if ((address & (long)(this.memory.getAddressSize() - 1)) != 0L) {
            System.out.println("The oop is not properly aligned");
        }
        long klassOop = this.jvmOops.getKlassOop(address);
        System.out.println("The klass oop of the oop is 0x" + Long.toHexString(klassOop));
        if (!this.jvmOops.isValidOop(address)) {
            System.out.println(this.jvmOops.getInvalidOopReason(address));
        } else {
            this.printOop(address, klassOop);
        }
    }

    private boolean checkIsInHeap(long address) {
        if (this.checkIsInUsedSpace(address, 0)) {
            System.out.println("The oop is in the used part of the eden space");
            return true;
        }
        if (this.checkIsInUnusedSpace(address, 0)) {
            System.out.println("The oop is in the *un*used part of the eden space !");
            return true;
        }
        if (this.checkIsInUsedSpace(address, 1)) {
            System.out.println("The oop is in the used part of the from space");
            return true;
        }
        if (this.checkIsInUnusedSpace(address, 1)) {
            System.out.println("The oop is in the *un*used part of the from space !");
            return true;
        }
        if (this.checkIsInUsedSpace(address, 2)) {
            System.out.println("The oop is in the used part of the to space");
            return true;
        }
        if (this.checkIsInUnusedSpace(address, 2)) {
            System.out.println("The oop is in the *un*used part of the to space !");
            return true;
        }
        if (this.checkIsInUsedSpace(address, 3)) {
            System.out.println("The oop is in the used part of the old generation");
            return true;
        }
        if (this.checkIsInUnusedSpace(address, 3)) {
            System.out.println("The oop is in the *un*used part of the old generation !");
            return true;
        }
        if (this.checkIsInUsedSpace(address, 4)) {
            System.out.println("The oop is in the used part of the perm generation");
            return true;
        }
        if (this.checkIsInUnusedSpace(address, 4)) {
            System.out.println("The oop is in the *un*used part of the pern generation !");
            return true;
        }
        System.out.println("The oop is not even located in the Java heap");
        return false;
    }

    private void printOop(long oop, long klassOop) {
        long size;
        System.out.println(this.jvmOops.getOopType(oop));
        String description = this.jvmOops.getOopContentDescription(oop);
        if (description != null) {
            System.out.println(description);
        }
        if ((size = this.jvmOops.getOopSize(oop)) <= 0L) {
            System.out.println("The size of the oop is unknown.");
        } else {
            System.out.println("The size of the oop is " + size + " bytes");
        }
    }

    private boolean checkIsInUsedSpace(long address, int space) {
        long start = this.jvmHeap.getSpaceStart(space);
        long end = start + this.jvmHeap.getSpaceUsedSize(space);
        return address >= start && address < end;
    }

    private boolean checkIsInUnusedSpace(long address, int space) {
        long start = this.jvmHeap.getSpaceStart(space);
        long end = start + this.jvmHeap.getSpaceUsedSize(space);
        return address >= start && address < end;
    }
}

