/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.tools.jvm.operation;

import com.sap.jvm.tools.dumps.tools.JvmDumpOperation;
import java.util.HashMap;

public class FindPrevOop
extends JvmDumpOperation {
    public FindPrevOop() {
        super(true, "FindPrevOop", "Finds the first oop left of the given address", new JvmDumpOperation.ArgumentSpec(2, "address", "The address from which to start"));
    }

    @Override
    protected void performOperation(HashMap<String, JvmDumpOperation.Argument> args) {
        long address = args.get("address").getLongValue() - (long)this.memory.getAddressSize();
        while (true) {
            if (!this.memory.isMapped(address, this.memory.getAddressSize())) {
                System.out.println("Stop since we hit unmapped memory.");
                break;
            }
            if (this.jvmOops.isValidOop(address)) {
                System.out.println("The previous oop is at 0x" + Long.toHexString(address));
                break;
            }
            address -= (long)this.memory.getAddressSize();
        }
    }
}

