/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.tools.jvm.operation;

import com.sap.jvm.tools.dumps.api.Module;
import com.sap.jvm.tools.dumps.tools.JvmDumpOperation;
import java.util.HashMap;

public class FindSymbolOfAddress
extends JvmDumpOperation {
    public FindSymbolOfAddress() {
        super(true, "FindSymbolOfAddress", "Prints the symbol for a given address", new JvmDumpOperation.ArgumentSpec(1, "module", "The module to search in."), new JvmDumpOperation.ArgumentSpec(2, "address", "The address to search for."));
    }

    @Override
    protected void performOperation(HashMap<String, JvmDumpOperation.Argument> args) {
        Module module = this.dump.getModuleFromName(args.get("module").getStringValue());
        long address = args.get("address").getLongValue();
        boolean found = false;
        for (String symbol : module.getSymbols()) {
            if (module.getSymbolAddress(symbol) != address) continue;
            System.out.println("This is the address of " + symbol);
            found = true;
        }
        if (!found) {
            System.out.println("Not matching symbol found");
        }
    }
}

