/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.tools.jvm.operation;

import com.sap.jvm.tools.dumps.tools.JvmDumpOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class SearchInCompleteHeap
extends JvmDumpOperation {
    public SearchInCompleteHeap() {
        super(false, "SearchInCompleteHeap", "Searches for a value in the complete heap", new JvmDumpOperation.ArgumentSpec(0, "type", "The type of the value to search for."), new JvmDumpOperation.ArgumentSpec(5, "value", "The value to search for."));
    }

    @Override
    protected void performOperation(HashMap<String, JvmDumpOperation.Argument> args) {
        int typeSize = args.get("type").getIntValue();
        long value = args.get("value").getLongValue();
        ArrayList<Long> result = new ArrayList<Long>();
        for (int i = 0; i < this.memory.getNrOfMappedRanges(); ++i) {
            long start = this.memory.getRangeStartAddress(i);
            long end = this.memory.getRangeSize(i) + start;
            if (typeSize == 1) {
                this.memory.findInt8InRange((byte)value, start, end - start, result);
                continue;
            }
            if (typeSize == 2) {
                this.memory.findInt16InRange((short)value, start, end - start, result);
                continue;
            }
            if (typeSize == 4) {
                this.memory.findInt32InRange((int)value, start, end - start, result);
                continue;
            }
            if (typeSize != 8) continue;
            this.memory.findInt64InRange(value, start, end - start, result);
        }
        System.out.println("Found " + result.size() + " occurances:");
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            long addr = (Long)iterator.next();
            System.out.println("0x" + Long.toHexString(addr));
        }
    }
}

