/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.tools.jvm.operation;

import com.sap.jvm.tools.dumps.api.Memory;
import com.sap.jvm.tools.dumps.tools.JvmDumpOperation;
import java.util.ArrayList;
import java.util.HashMap;

public class SearchInHeap
extends JvmDumpOperation {
    public SearchInHeap() {
        super(false, "SearchInHeap", "Searches for content in the heap", new JvmDumpOperation.ArgumentSpec(0, "type", "The type of the value to search."), new JvmDumpOperation.ArgumentSpec(5, "value", "The value to search."), new JvmDumpOperation.ArgumentSpec(2, "start", "The start address."), new JvmDumpOperation.ArgumentSpec(3, "end", "The end address."));
    }

    @Override
    protected void performOperation(HashMap<String, JvmDumpOperation.Argument> args) {
        long value = args.get("value").getLongValue();
        long from = args.get("start").getLongValue();
        long to = args.get("end").getLongValue();
        int typeSize = args.get("type").getIntValue();
        SearchInHeap.searchRange(typeSize, "range", value, from, to - from, this.memory);
    }

    public static void searchRange(int typeSize, String name, long value, long start, long size, Memory memory) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (typeSize == 8) {
            memory.findInt64InRange(value, start, size, result);
        } else if (typeSize == 4) {
            memory.findInt32InRange((int)value, start, size, result);
        } else if (typeSize == 2) {
            memory.findInt16InRange((short)value, start, size, result);
        } else if (typeSize == 1) {
            memory.findInt8InRange((byte)value, start, size, result);
        }
        System.out.println("Result for " + name + " [0x" + Long.toHexString(start) + ", 0x" + Long.toHexString(start + size) + "[");
        for (long address : result) {
            System.out.println("0x" + Long.toHexString(address));
        }
    }
}

