/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.dumps.tools.jvm.operation;

import com.sap.jvm.tools.dumps.tools.JvmDumpOperation;
import com.sap.jvm.tools.dumps.tools.jvm.JvmHeap;
import com.sap.jvm.tools.dumps.tools.jvm.operation.SearchInHeap;
import java.util.HashMap;

public class SearchInJavaHeap
extends JvmDumpOperation {
    public SearchInJavaHeap() {
        super(true, "SearchInJavaHeap", "Searches for content in the Java heap", new JvmDumpOperation.ArgumentSpec(7, "-unused", "If given we search in the unused partof the Java heap"), new JvmDumpOperation.ArgumentSpec(0, "type", "The type of the value to search."), new JvmDumpOperation.ArgumentSpec(5, "value", "The value to search."));
    }

    @Override
    protected void performOperation(HashMap<String, JvmDumpOperation.Argument> args) {
        JvmHeap heap = this.jvm.getJvmHeap();
        long value = args.get("value").getLongValue();
        int typeSize = args.get("type").getIntValue();
        boolean unused = args.get("-unused").getBooleanValue();
        if (unused) {
            SearchInHeap.searchRange(typeSize, "Unused Eden Space", value, heap.getSpaceStart(0) + heap.getSpaceUsedSize(0), heap.getSpaceEnd(0) - heap.getSpaceStart(0) - heap.getSpaceUsedSize(0), this.memory);
            SearchInHeap.searchRange(typeSize, "Unused From Space", value, heap.getSpaceStart(1) + heap.getSpaceUsedSize(1), heap.getSpaceEnd(1) - heap.getSpaceStart(1) - heap.getSpaceUsedSize(1), this.memory);
            SearchInHeap.searchRange(typeSize, "Unused To Space", value, heap.getSpaceStart(2) + heap.getSpaceUsedSize(2), heap.getSpaceEnd(2) - heap.getSpaceStart(2) - heap.getSpaceUsedSize(2), this.memory);
            SearchInHeap.searchRange(typeSize, "Unused Old Generation", value, heap.getSpaceStart(3) + heap.getSpaceUsedSize(3), heap.getSpaceEnd(3) - heap.getSpaceStart(3) - heap.getSpaceUsedSize(3), this.memory);
            SearchInHeap.searchRange(typeSize, "Unused Perm Generation", value, heap.getSpaceStart(4) + heap.getSpaceUsedSize(4), heap.getSpaceEnd(4) - heap.getSpaceStart(4) - heap.getSpaceUsedSize(4), this.memory);
        } else {
            SearchInHeap.searchRange(typeSize, "Eden Space", value, heap.getSpaceStart(0), heap.getSpaceUsedSize(0), this.memory);
            SearchInHeap.searchRange(typeSize, "From Space", value, heap.getSpaceStart(1), heap.getSpaceUsedSize(1), this.memory);
            SearchInHeap.searchRange(typeSize, "To Space", value, heap.getSpaceStart(2), heap.getSpaceUsedSize(2), this.memory);
            SearchInHeap.searchRange(typeSize, "Old Generation", value, heap.getSpaceStart(3), heap.getSpaceUsedSize(3), this.memory);
            SearchInHeap.searchRange(typeSize, "Perm Generation", value, heap.getSpaceStart(4), heap.getSpaceUsedSize(4), this.memory);
        }
    }
}

