/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.example.debug.expr;

import com.sap.jvm.jdi.ArrayReference;
import com.sap.jvm.jdi.ArrayType;
import com.sap.jvm.jdi.BooleanValue;
import com.sap.jvm.jdi.ClassLoaderReference;
import com.sap.jvm.jdi.ClassNotLoadedException;
import com.sap.jvm.jdi.ClassObjectReference;
import com.sap.jvm.jdi.ClassType;
import com.sap.jvm.jdi.IncompatibleThreadStateException;
import com.sap.jvm.jdi.IntegerValue;
import com.sap.jvm.jdi.InvalidTypeException;
import com.sap.jvm.jdi.InvocationException;
import com.sap.jvm.jdi.Method;
import com.sap.jvm.jdi.PrimitiveValue;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.StackFrame;
import com.sap.jvm.jdi.StringReference;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.jdi.Type;
import com.sap.jvm.jdi.Value;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.tools.example.debug.expr.ExpressionParserConstants;
import com.sap.jvm.tools.example.debug.expr.ExpressionParserTokenManager;
import com.sap.jvm.tools.example.debug.expr.JavaCharStream;
import com.sap.jvm.tools.example.debug.expr.LValue;
import com.sap.jvm.tools.example.debug.expr.ParseException;
import com.sap.jvm.tools.example.debug.expr.Token;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ExpressionParser
implements ExpressionParserConstants {
    Stack<LValue> stack = new Stack();
    VirtualMachine vm = null;
    GetFrame frameGetter = null;
    private static GetFrame lastFrameGetter;
    private static LValue lastLValue;
    private int arrayDimension = -1;
    private int arrayDimensionSpecified = -1;
    public ExpressionParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[44];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[9];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    LValue peek() {
        return this.stack.peek();
    }

    LValue pop() {
        return this.stack.pop();
    }

    void push(LValue lval) {
        this.stack.push(lval);
    }

    public static Value getMassagedValue() throws ParseException {
        return lastLValue.getMassagedValue(lastFrameGetter);
    }

    public static Value evaluate(String expr, VirtualMachine vm, GetFrame frameGetter) throws ParseException, InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        StringBufferInputStream in = new StringBufferInputStream(expr);
        ExpressionParser parser = new ExpressionParser(in);
        parser.vm = vm;
        parser.frameGetter = frameGetter;
        parser.Expression();
        lastFrameGetter = frameGetter;
        lastLValue = parser.pop();
        return lastLValue.getValue();
    }

    public static void main(String[] args) {
        ExpressionParser parser;
        System.out.print("Java Expression Parser:  ");
        if (args.length == 0) {
            System.out.println("Reading from standard input . . .");
            parser = new ExpressionParser(System.in);
        } else if (args.length == 1) {
            System.out.println("Reading from file " + args[0] + " . . .");
            try {
                parser = new ExpressionParser(new FileInputStream(args[0]));
            }
            catch (FileNotFoundException e) {
                System.out.println("Java Parser Version 1.0.2:  File " + args[0] + " not found.");
                return;
            }
        } else {
            System.out.println("Usage is one of:");
            System.out.println("         java ExpressionParser < inputfile");
            System.out.println("OR");
            System.out.println("         java ExpressionParser inputfile");
            return;
        }
        try {
            parser.Expression();
            System.out.print("Java Expression Parser:  ");
            System.out.println("Java program parsed successfully.");
        }
        catch (ParseException e) {
            System.out.print("Java Expression Parser:  ");
            System.out.println("Encountered errors during parse.");
        }
    }

    public final void Type() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 12: 
            case 15: 
            case 21: 
            case 27: 
            case 34: 
            case 36: 
            case 45: {
                this.PrimitiveType();
                break;
            }
            case 67: {
                this.Name();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 74: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(74);
            this.jj_consume_token(75);
        }
    }

    public final void PrimitiveType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String Name() throws ParseException {
        StringBuilder sb = new StringBuilder();
        this.jj_consume_token(67);
        sb.append(this.token);
        while (this.jj_2_1(2)) {
            this.jj_consume_token(78);
            this.jj_consume_token(67);
            sb.append('.');
            sb.append(this.token);
        }
        return sb.toString();
    }

    public final void NameList() throws ParseException {
        this.Name();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 77: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(77);
            this.Name();
        }
    }

    public final void Expression() throws ParseException {
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            this.Assignment();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: 
                case 38: 
                case 39: 
                case 47: 
                case 50: 
                case 54: 
                case 59: 
                case 63: 
                case 65: 
                case 66: 
                case 67: 
                case 70: 
                case 82: 
                case 83: 
                case 92: 
                case 93: 
                case 94: 
                case 95: {
                    this.ConditionalExpression();
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void Assignment() throws ParseException {
        this.PrimaryExpression();
        this.AssignmentOperator();
        this.Expression();
        LValue exprVal = this.pop();
        this.pop().setValue(exprVal);
        this.push(exprVal);
    }

    public final void AssignmentOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 79: {
                this.jj_consume_token(79);
                break;
            }
            case 107: {
                this.jj_consume_token(107);
                break;
            }
            case 108: {
                this.jj_consume_token(108);
                break;
            }
            case 112: {
                this.jj_consume_token(112);
                break;
            }
            case 105: {
                this.jj_consume_token(105);
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                break;
            }
            case 113: {
                this.jj_consume_token(113);
                break;
            }
            case 114: {
                this.jj_consume_token(114);
                break;
            }
            case 115: {
                this.jj_consume_token(115);
                break;
            }
            case 109: {
                this.jj_consume_token(109);
                break;
            }
            case 111: {
                this.jj_consume_token(111);
                break;
            }
            case 110: {
                this.jj_consume_token(110);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ConditionalExpression() throws ParseException {
        this.ConditionalOrExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 84: {
                this.jj_consume_token(84);
                this.Expression();
                this.jj_consume_token(85);
                this.ConditionalExpression();
                LValue falseBranch = this.pop();
                LValue trueBranch = this.pop();
                Value cond = this.pop().interiorGetValue();
                if (cond instanceof BooleanValue) {
                    this.push(((BooleanValue)cond).booleanValue() ? trueBranch : falseBranch);
                    break;
                }
                throw new ParseException("Condition must be boolean");
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
    }

    public final void ConditionalOrExpression() throws ParseException {
        block8: {
            this.ConditionalAndExpression();
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 90: {
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(90);
                Value top = this.peek().interiorGetValue();
                if (top instanceof BooleanValue && ((BooleanValue)top).value()) {
                    int size = this.stack.size();
                    try {
                        this.ConditionalAndExpression();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    while (this.stack.size() > size) {
                        this.pop();
                    }
                    this.pop();
                    this.push(LValue.make(this.vm, true));
                    return;
                }
                this.ConditionalAndExpression();
                Value right = this.pop().interiorGetValue();
                Value left = this.pop().interiorGetValue();
                if (!(left instanceof BooleanValue) || !(right instanceof BooleanValue)) break;
                BooleanValue l = (BooleanValue)left;
                BooleanValue r = (BooleanValue)right;
                this.push(LValue.make(this.vm, l.value() || r.value()));
            }
            throw new ParseException("Operands of || have to be boolean");
        }
    }

    public final void ConditionalAndExpression() throws ParseException {
        block8: {
            this.InclusiveOrExpression();
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 91: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(91);
                Value top = this.peek().interiorGetValue();
                if (top instanceof BooleanValue && !((BooleanValue)top).value()) {
                    int size = this.stack.size();
                    try {
                        this.InclusiveOrExpression();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    while (this.stack.size() > size) {
                        this.pop();
                    }
                    this.pop();
                    this.push(LValue.make(this.vm, false));
                    return;
                }
                this.InclusiveOrExpression();
                Value right = this.pop().interiorGetValue();
                Value left = this.pop().interiorGetValue();
                if (!(left instanceof BooleanValue) || !(right instanceof BooleanValue)) break;
                BooleanValue l = (BooleanValue)left;
                BooleanValue r = (BooleanValue)right;
                this.push(LValue.make(this.vm, l.value() && r.value()));
            }
            throw new ParseException("Operands of && have to be boolean");
        }
    }

    public final void InclusiveOrExpression() throws ParseException {
        this.ExclusiveOrExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 99: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(99);
            Token tok = this.token;
            this.ExclusiveOrExpression();
            LValue top = this.pop();
            this.push(LValue.operation(this.vm, tok, this.pop(), top, this.frameGetter));
        }
    }

    public final void ExclusiveOrExpression() throws ParseException {
        this.AndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(100);
            Token tok = this.token;
            this.AndExpression();
            LValue top = this.pop();
            this.push(LValue.operation(this.vm, tok, this.pop(), top, this.frameGetter));
        }
    }

    public final void AndExpression() throws ParseException {
        this.EqualityExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 98: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(98);
            Token tok = this.token;
            this.EqualityExpression();
            LValue top = this.pop();
            this.push(LValue.operation(this.vm, tok, this.pop(), top, this.frameGetter));
        }
    }

    public final void EqualityExpression() throws ParseException {
        this.InstanceOfExpression();
        block7: while (true) {
            Token tok;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 86: 
                case 89: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 86: {
                    tok = this.jj_consume_token(86);
                    break;
                }
                case 89: {
                    tok = this.jj_consume_token(89);
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.InstanceOfExpression();
            LValue left = this.pop();
            this.push(LValue.booleanOperation(this.vm, tok, this.pop(), left));
        }
    }

    public final void InstanceOfExpression() throws ParseException {
        this.RelationalExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                this.jj_consume_token(33);
                this.Type();
                Value value = this.pop().interiorGetValue();
                if (value == null) {
                    this.push(LValue.make(this.vm, false));
                    break;
                }
                Type type = value.type();
                String className = this.token.image;
                List<ReferenceType> classes = this.vm.classesByName(className);
                if (classes.size() == 0 && className.indexOf(46) == -1) {
                    classes = LValue.getContextClass(this.vm, this.frameGetter, className);
                }
                boolean result = false;
                for (ReferenceType rt : classes) {
                    if (!LValue.isAssignableTo(type, rt)) continue;
                    result = true;
                    break;
                }
                this.push(LValue.make(this.vm, result));
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
    }

    public final void RelationalExpression() throws ParseException {
        this.ShiftExpression();
        block9: while (true) {
            Token tok;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 80: 
                case 81: 
                case 87: 
                case 88: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 81: {
                    tok = this.jj_consume_token(81);
                    break;
                }
                case 80: {
                    tok = this.jj_consume_token(80);
                    break;
                }
                case 87: {
                    tok = this.jj_consume_token(87);
                    break;
                }
                case 88: {
                    tok = this.jj_consume_token(88);
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.ShiftExpression();
            LValue left = this.pop();
            this.push(LValue.booleanOperation(this.vm, tok, this.pop(), left));
        }
    }

    public final void ShiftExpression() throws ParseException {
        this.AdditiveExpression();
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 102: 
                case 103: 
                case 104: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 102: {
                    this.jj_consume_token(102);
                    break;
                }
                case 103: {
                    this.jj_consume_token(103);
                    break;
                }
                case 104: {
                    this.jj_consume_token(104);
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Token tok = this.token;
            this.AdditiveExpression();
            LValue top = this.pop();
            this.push(LValue.operation(this.vm, tok, this.pop(), top, this.frameGetter));
        }
    }

    public final void AdditiveExpression() throws ParseException {
        this.MultiplicativeExpression();
        block7: while (true) {
            Token tok;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 94: 
                case 95: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 94: {
                    tok = this.jj_consume_token(94);
                    break;
                }
                case 95: {
                    tok = this.jj_consume_token(95);
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.MultiplicativeExpression();
            LValue left = this.pop();
            this.push(LValue.operation(this.vm, tok, this.pop(), left, this.frameGetter));
        }
    }

    public final void MultiplicativeExpression() throws ParseException {
        this.UnaryExpression();
        block8: while (true) {
            Token tok;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 96: 
                case 97: 
                case 101: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 96: {
                    tok = this.jj_consume_token(96);
                    break;
                }
                case 97: {
                    tok = this.jj_consume_token(97);
                    break;
                }
                case 101: {
                    tok = this.jj_consume_token(101);
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.UnaryExpression();
            LValue left = this.pop();
            this.push(LValue.operation(this.vm, tok, this.pop(), left, this.frameGetter));
        }
    }

    public final void UnaryExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 94: 
            case 95: {
                Token tok;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 94: {
                        tok = this.jj_consume_token(94);
                        break;
                    }
                    case 95: {
                        tok = this.jj_consume_token(95);
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.UnaryExpression();
                this.push(LValue.operation(this.vm, tok, this.pop(), this.frameGetter));
                break;
            }
            case 92: {
                this.PreIncrementExpression();
                break;
            }
            case 93: {
                this.PreDecrementExpression();
                break;
            }
            case 24: 
            case 38: 
            case 39: 
            case 47: 
            case 50: 
            case 54: 
            case 59: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 82: 
            case 83: {
                this.UnaryExpressionNotPlusMinus();
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void PreIncrementExpression() throws ParseException {
        this.jj_consume_token(92);
        this.PrimaryExpression();
        LValue lvalue = this.pop();
        Token tok = new Token();
        tok.image = "+";
        LValue result = LValue.operation(this.vm, tok, lvalue, LValue.make(this.vm, 1), this.frameGetter);
        lvalue.setValue(result);
        this.push(result);
    }

    public final void PreDecrementExpression() throws ParseException {
        this.jj_consume_token(93);
        this.PrimaryExpression();
        LValue lvalue = this.pop();
        Token tok = new Token();
        tok.image = "-";
        LValue result = LValue.operation(this.vm, tok, lvalue, LValue.make(this.vm, 1), this.frameGetter);
        lvalue.setValue(result);
        this.push(result);
    }

    public final void UnaryExpressionNotPlusMinus() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 82: 
            case 83: {
                Token tok;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 83: {
                        tok = this.jj_consume_token(83);
                        break;
                    }
                    case 82: {
                        tok = this.jj_consume_token(82);
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.UnaryExpression();
                this.push(LValue.operation(this.vm, tok, this.pop(), this.frameGetter));
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                if (this.jj_2_3(Integer.MAX_VALUE)) {
                    this.CastExpression();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: 
                    case 38: 
                    case 39: 
                    case 47: 
                    case 50: 
                    case 54: 
                    case 59: 
                    case 63: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 70: {
                        this.PostfixExpression();
                        break block0;
                    }
                }
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void CastLookahead() throws ParseException {
        if (this.jj_2_4(2)) {
            this.jj_consume_token(70);
            this.PrimitiveType();
        } else if (this.jj_2_5(Integer.MAX_VALUE)) {
            this.jj_consume_token(70);
            this.Name();
            this.jj_consume_token(74);
            this.jj_consume_token(75);
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 70: {
                    this.jj_consume_token(70);
                    this.Name();
                    this.jj_consume_token(71);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 83: {
                            this.jj_consume_token(83);
                            break block0;
                        }
                        case 82: {
                            this.jj_consume_token(82);
                            break block0;
                        }
                        case 70: {
                            this.jj_consume_token(70);
                            break block0;
                        }
                        case 67: {
                            this.jj_consume_token(67);
                            break block0;
                        }
                        case 50: {
                            this.jj_consume_token(50);
                            break block0;
                        }
                        case 47: {
                            this.jj_consume_token(47);
                            break block0;
                        }
                        case 38: {
                            this.jj_consume_token(38);
                            break block0;
                        }
                        case 24: 
                        case 39: 
                        case 54: 
                        case 59: 
                        case 63: 
                        case 65: 
                        case 66: {
                            this.Literal();
                            break block0;
                        }
                    }
                    this.jj_la1[28] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void PostfixExpression() throws ParseException {
        this.PrimaryExpression();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 92: 
            case 93: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 92: {
                        this.jj_consume_token(92);
                        LValue lvalue = this.pop();
                        Token tok = new Token();
                        tok.image = "+";
                        LValue result = LValue.operation(this.vm, tok, lvalue, LValue.make(this.vm, 0), this.frameGetter);
                        LValue increment = LValue.operation(this.vm, tok, lvalue, LValue.make(this.vm, 1), this.frameGetter);
                        lvalue.setValue(increment);
                        this.push(result);
                        break block0;
                    }
                    case 93: {
                        this.jj_consume_token(93);
                        LValue lvalue = this.pop();
                        Token tok = new Token();
                        tok.image = "-";
                        LValue result = LValue.operation(this.vm, tok, lvalue, LValue.make(this.vm, 0), this.frameGetter);
                        LValue decrement = LValue.operation(this.vm, tok, lvalue, LValue.make(this.vm, 1), this.frameGetter);
                        lvalue.setValue(decrement);
                        this.push(result);
                        break block0;
                    }
                }
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
    }

    public final void CastExpression() throws ParseException {
        if (this.jj_2_6(2)) {
            this.jj_consume_token(70);
            this.PrimitiveType();
            Token tok = this.token;
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 74: {
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        break block19;
                    }
                }
                this.jj_consume_token(74);
                this.jj_consume_token(75);
            }
            this.jj_consume_token(71);
            this.UnaryExpression();
            Value jdiValue = this.pop().interiorGetValue();
            if (!(jdiValue instanceof PrimitiveValue)) {
                throw new ParseException("Cannot cast non-primitive value to primitive type");
            }
            PrimitiveValue value = (PrimitiveValue)jdiValue;
            switch (tok.kind) {
                case 10: {
                    this.push(LValue.make(this.vm, value.booleanValue()));
                    break;
                }
                case 15: {
                    this.push(LValue.make(this.vm, value.charValue()));
                    break;
                }
                case 12: {
                    this.push(LValue.make(this.vm, value.byteValue()));
                    break;
                }
                case 45: {
                    this.push(LValue.make(this.vm, value.shortValue()));
                    break;
                }
                case 34: {
                    this.push(LValue.make(this.vm, value.intValue()));
                    break;
                }
                case 36: {
                    this.push(LValue.make(this.vm, value.longValue()));
                    break;
                }
                case 27: {
                    this.push(LValue.make(this.vm, value.floatValue()));
                    break;
                }
                case 21: {
                    this.push(LValue.make(this.vm, value.doubleValue()));
                    break;
                }
                default: {
                    throw new ParseException("Unknown primitive type: " + tok.image + " (" + tok.kind + ")");
                }
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 70: {
                    this.jj_consume_token(70);
                    this.Name();
                    block20: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 74: {
                                break;
                            }
                            default: {
                                this.jj_la1[33] = this.jj_gen;
                                break block20;
                            }
                        }
                        this.jj_consume_token(74);
                        this.jj_consume_token(75);
                    }
                    this.jj_consume_token(71);
                    this.UnaryExpressionNotPlusMinus();
                    if (!(this.peek().interiorGetValue() instanceof PrimitiveValue)) break;
                    throw new ParseException("Cannot cast primitive value to reference type");
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void PrimaryExpression() throws ParseException {
        this.PrimaryPrefix();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 70: 
                case 74: 
                case 78: {
                    break;
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                    break block3;
                }
            }
            this.PrimarySuffix();
        }
    }

    public final void PrimaryPrefix() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 39: 
            case 54: 
            case 59: 
            case 63: 
            case 65: 
            case 66: {
                this.Literal();
                break;
            }
            case 67: {
                String name = this.Name();
                this.push(LValue.makeName(this.vm, this.frameGetter, name));
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                this.push(LValue.makeThisObject(this.vm, this.frameGetter, this.token));
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                this.jj_consume_token(78);
                String name = this.Name();
                this.push(LValue.makeSuperName(this.vm, this.frameGetter, name));
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                this.Expression();
                this.jj_consume_token(71);
                break;
            }
            case 38: {
                this.AllocationExpression();
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void PrimarySuffix() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 74: {
                this.jj_consume_token(74);
                this.Expression();
                this.jj_consume_token(75);
                LValue index = this.pop();
                this.push(this.pop().arrayElementLValue(index));
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                this.jj_consume_token(67);
                this.push(this.pop().memberLValue(this.frameGetter, this.token.image));
                break;
            }
            case 70: {
                List<Value> argList = this.Arguments();
                this.peek().invokeWith(argList);
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Literal() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                this.jj_consume_token(59);
                this.push(LValue.makeInteger(this.vm, this.token));
                break;
            }
            case 63: {
                this.jj_consume_token(63);
                this.push(LValue.makeFloat(this.vm, this.token));
                break;
            }
            case 65: {
                this.jj_consume_token(65);
                this.push(LValue.makeCharacter(this.vm, this.token));
                break;
            }
            case 66: {
                this.jj_consume_token(66);
                this.push(LValue.makeString(this.vm, this.token));
                break;
            }
            case 24: 
            case 54: {
                this.BooleanLiteral();
                this.push(LValue.makeBoolean(this.vm, this.token));
                break;
            }
            case 39: {
                this.NullLiteral();
                this.push(LValue.makeNull(this.vm, this.token));
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void BooleanLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                this.jj_consume_token(54);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void NullLiteral() throws ParseException {
        this.jj_consume_token(39);
    }

    public final List<Value> Arguments() throws ParseException {
        ArrayList<Value> argList = new ArrayList<Value>();
        this.jj_consume_token(70);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 38: 
            case 39: 
            case 47: 
            case 50: 
            case 54: 
            case 59: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 82: 
            case 83: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                this.ArgumentList(argList);
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
        this.jj_consume_token(71);
        return argList;
    }

    public final void ArgumentList(List<Value> argList) throws ParseException {
        this.Expression();
        argList.add(this.pop().interiorGetValue());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 77: {
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(77);
            this.Expression();
            argList.add(this.pop().interiorGetValue());
        }
    }

    public final void AllocationExpression() throws ParseException {
        if (this.jj_2_7(2)) {
            this.jj_consume_token(38);
            this.PrimitiveType();
            String className = this.token.toString();
            this.ArrayDimensions();
            this.createArray(className, true);
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 38: {
                    this.jj_consume_token(38);
                    String className = this.Name();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 70: {
                            List<Value> argList = this.Arguments();
                            this.push(LValue.makeNewObject(this.vm, this.frameGetter, className, argList));
                            break block0;
                        }
                        case 74: {
                            this.ArrayDimensions();
                            this.createArray(className, false);
                            break block0;
                        }
                    }
                    this.jj_la1[42] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void ArrayDimensions() throws ParseException {
        int dimension = 0;
        int dimensionSpecified = 0;
        do {
            this.jj_consume_token(74);
            this.Expression();
            this.jj_consume_token(75);
            ++dimension;
            ++dimensionSpecified;
        } while (this.jj_2_8(2));
        while (this.jj_2_9(2)) {
            this.jj_consume_token(74);
            this.jj_consume_token(75);
            ++dimension;
        }
        this.arrayDimension = dimension;
        this.arrayDimensionSpecified = dimensionSpecified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    private boolean jj_3R_94() {
        if (this.jj_scan_token(93)) {
            return true;
        }
        return this.jj_3R_20();
    }

    private boolean jj_3R_86() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_93() {
        if (this.jj_scan_token(92)) {
            return true;
        }
        return this.jj_3R_20();
    }

    private boolean jj_3R_91() {
        return this.jj_3R_95();
    }

    private boolean jj_3R_23() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(10)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(15)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(12)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(45)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(34)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(36)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(27)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(21)) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_90() {
        return this.jj_3R_94();
    }

    private boolean jj_3R_89() {
        return this.jj_3R_93();
    }

    private boolean jj_3R_85() {
        return this.jj_3R_23();
    }

    private boolean jj_3R_60() {
        return this.jj_3R_58();
    }

    private boolean jj_3R_88() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(94)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(95)) {
                return true;
            }
        }
        return this.jj_3R_83();
    }

    private boolean jj_3R_83() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_88()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_89()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_90()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_91()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_82() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_85()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_86()) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_87());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_59() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_96() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(96)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(97)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(101)) {
                    return true;
                }
            }
        }
        return this.jj_3R_83();
    }

    private boolean jj_3R_80() {
        Token xsp;
        if (this.jj_3R_83()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_96());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_92() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(94)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(95)) {
                return true;
            }
        }
        return this.jj_3R_80();
    }

    private boolean jj_3_8() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_3R_25()) {
            return true;
        }
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_58() {
        Token xsp;
        if (this.jj_3_8()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_8());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_9());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_84() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(102)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(103)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(104)) {
                    return true;
                }
            }
        }
        return this.jj_3R_78();
    }

    private boolean jj_3R_78() {
        Token xsp;
        if (this.jj_3R_80()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_92());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_54() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_59()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_60()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_76() {
        Token xsp;
        if (this.jj_3R_78()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_84());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_81() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(81)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(80)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(87)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(88)) {
                        return true;
                    }
                }
            }
        }
        return this.jj_3R_76();
    }

    private boolean jj_3R_43() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_54()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        return this.jj_3R_58();
    }

    private boolean jj_3R_67() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        return this.jj_3R_25();
    }

    private boolean jj_3R_64() {
        Token xsp;
        if (this.jj_3R_25()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_67());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_61() {
        return this.jj_3R_64();
    }

    private boolean jj_3R_79() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_3R_82();
    }

    private boolean jj_3R_74() {
        Token xsp;
        if (this.jj_3R_76()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_81());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_55() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_61()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(71);
    }

    private boolean jj_3R_72() {
        if (this.jj_3R_74()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_79()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_77() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(86)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(89)) {
                return true;
            }
        }
        return this.jj_3R_72();
    }

    private boolean jj_3R_75() {
        if (this.jj_scan_token(98)) {
            return true;
        }
        return this.jj_3R_70();
    }

    private boolean jj_3R_70() {
        Token xsp;
        if (this.jj_3R_72()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_77());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_57() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(54)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(24)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_53() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_39() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_68() {
        Token xsp;
        if (this.jj_3R_70()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_75());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_73() {
        if (this.jj_scan_token(100)) {
            return true;
        }
        return this.jj_3R_68();
    }

    private boolean jj_3R_52() {
        return this.jj_3R_57();
    }

    private boolean jj_3R_51() {
        return this.jj_scan_token(66);
    }

    private boolean jj_3R_50() {
        return this.jj_scan_token(65);
    }

    private boolean jj_3R_65() {
        Token xsp;
        if (this.jj_3R_68()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_73());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_71() {
        if (this.jj_scan_token(99)) {
            return true;
        }
        return this.jj_3R_65();
    }

    private boolean jj_3R_49() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3R_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_48()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_49()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_50()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_51()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_52()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_53()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_48() {
        return this.jj_scan_token(59);
    }

    private boolean jj_3R_62() {
        Token xsp;
        if (this.jj_3R_65()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_71());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_69() {
        if (this.jj_scan_token(91)) {
            return true;
        }
        return this.jj_3R_62();
    }

    private boolean jj_3R_46() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_45() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        return this.jj_scan_token(67);
    }

    private boolean jj_3R_56() {
        Token xsp;
        if (this.jj_3R_62()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_69());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_66() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        return this.jj_3R_56();
    }

    private boolean jj_3R_44() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_3R_25()) {
            return true;
        }
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_38() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_44()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_45()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_46()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_37() {
        return this.jj_3R_43();
    }

    private boolean jj_3R_27() {
        return this.jj_3R_38();
    }

    private boolean jj_3R_36() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_3R_25()) {
            return true;
        }
        return this.jj_scan_token(71);
    }

    private boolean jj_3R_47() {
        Token xsp;
        if (this.jj_3R_56()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_66());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_104() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_35() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        return this.jj_scan_token(67);
    }

    private boolean jj_3R_34() {
        return this.jj_scan_token(50);
    }

    private boolean jj_3R_63() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_3R_25()) {
            return true;
        }
        if (this.jj_scan_token(85)) {
            return true;
        }
        return this.jj_3R_41();
    }

    private boolean jj_3R_33() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_105() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_32() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_33()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_34()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_35()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_36()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_37()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_20() {
        Token xsp;
        if (this.jj_3R_26()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_27());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_41() {
        if (this.jj_3R_47()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_63()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_106() {
        return this.jj_scan_token(93);
    }

    private boolean jj_3R_102() {
        Token xsp;
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_105());
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(71)) {
            return true;
        }
        return this.jj_3R_95();
    }

    private boolean jj_3R_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(79)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(107)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(108)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(112)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(105)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(106)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(113)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(114)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(115)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(109)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(111)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(110)) {
                                                        return true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_103() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(92)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_106()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_100() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_6()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_102()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_6() {
        Token xsp;
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_104());
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(71)) {
            return true;
        }
        return this.jj_3R_83();
    }

    private boolean jj_3_2() {
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_3R_21();
    }

    private boolean jj_3R_40() {
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_3R_21()) {
            return true;
        }
        return this.jj_3R_25();
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_101() {
        if (this.jj_3R_20()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_103()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_31() {
        return this.jj_3R_41();
    }

    private boolean jj_3R_30() {
        return this.jj_3R_40();
    }

    private boolean jj_3R_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_31()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_29() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        if (this.jj_scan_token(71)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(83)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(82)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(70)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(67)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(50)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(47)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(38)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_39()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_28() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        if (this.jj_scan_token(74)) {
            return true;
        }
        return this.jj_scan_token(75);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        return this.jj_3R_23();
    }

    private boolean jj_3R_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_28()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_29()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_3() {
        return this.jj_3R_22();
    }

    private boolean jj_3R_99() {
        return this.jj_3R_101();
    }

    private boolean jj_3R_87() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_98() {
        return this.jj_3R_100();
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        return this.jj_scan_token(67);
    }

    private boolean jj_3_9() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        return this.jj_scan_token(75);
    }

    private boolean jj_3R_97() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(83)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(82)) {
                return true;
            }
        }
        return this.jj_3R_83();
    }

    private boolean jj_3R_95() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_97()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_98()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_99()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_24() {
        Token xsp;
        if (this.jj_scan_token(67)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_1());
        this.jj_scanpos = xsp;
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{136352768, 0, 136352768, 0, 0x1000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1000000, 0, 0, 0x1000000, 0x1000000, 0, 0, 0, 0, 0, 0, 0, 0x1000000, 0, 0x1000000, 0x1000000, 0x1000000, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{8212, 0, 8212, 0, -2008776512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2008776512, 0, 0, -2008776512, -2008776512, 0, 0, 0, 0, 0, 0, 0, -2008776512, 0, -2009071488, 0x400000, -2008776512, 0, 0, 64};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{8, 1024, 0, 8192, -267648946, 32768, 0x100000, 0x4000000, 0x8000000, 0, 0, 0, 0x2400000, 0x2400000, 0, 25362432, 25362432, 0, 0, -1073741824, -1073741824, 0, 0, -1073741824, -267648946, 786432, 786432, 78, 786510, 64, 0x30000000, 0x30000000, 1024, 1024, 64, 17472, 78, 17472, 6, 0, -267648946, 8192, 1088, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 1048064, 0, 0, 0, 8, 16, 4, 0, 0, 0, 0, 0, 448, 448, 0, 0, 35, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public ExpressionParser(InputStream stream) {
        this(stream, null);
    }

    public ExpressionParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ExpressionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionParser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new ExpressionParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionParser(ExpressionParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ExpressionParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[116];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 44; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 116; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 9; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createArray(String className, boolean primitive) throws ParseException {
        ArrayReference newObject;
        block18: {
            if (this.arrayDimensionSpecified <= 0) {
                throw new ParseException("No array dimension specified");
            }
            if (this.arrayDimensionSpecified > this.arrayDimension) {
                throw new ParseException("Incorrect array specification: array dimensions=" + this.arrayDimension + ", dimensions specified=" + this.arrayDimensionSpecified);
            }
            StringBuilder arrayClassName = new StringBuilder(className);
            for (int i = 0; i < this.arrayDimension; ++i) {
                arrayClassName.append("[]");
            }
            String nameWithDimension = arrayClassName.toString();
            int[] dimensions = new int[this.arrayDimensionSpecified];
            for (int i = this.arrayDimensionSpecified - 1; i >= 0; --i) {
                try {
                    Value value = this.stack.pop().getValue();
                    if (!(value instanceof PrimitiveValue)) {
                        throw new ParseException("Non primitive array dimension: " + value);
                    }
                    dimensions[i] = ((PrimitiveValue)value).intValue();
                    continue;
                }
                catch (InvocationException e) {
                    throw new ParseException("Impossible invocation exception: " + e.getMessage());
                }
                catch (IncompatibleThreadStateException e) {
                    throw new ParseException("Impossible thread state exception: " + e.getMessage());
                }
                catch (InvalidTypeException e) {
                    throw new ParseException("Impossible type exception: " + e.getMessage());
                }
                catch (ClassNotLoadedException e) {
                    throw new ParseException("Impossible class not loaded exception: " + e.getMessage());
                }
            }
            int dimension = this.arrayDimension;
            ArrayType arrayType = this.getArrayType(arrayClassName.toString(), className, dimension, primitive);
            try {
                newObject = arrayType.newInstance(dimensions[0]);
                if (dimensions.length <= 1) break block18;
                newObject.disableCollection();
                try {
                    ArrayList<ArrayReference> arrays = new ArrayList<ArrayReference>();
                    arrays.add(newObject);
                    for (int i = 1; i < dimensions.length; ++i) {
                        ArrayReference[] tmp = arrays.toArray(new ArrayReference[arrays.size()]);
                        arrays.clear();
                        arrayClassName.setLength(arrayClassName.length() - 2);
                        arrayType = this.getArrayType(arrayClassName.toString(), className, --dimension, primitive);
                        for (ArrayReference ref : tmp) {
                            for (int j = 0; j < ref.length(); ++j) {
                                ArrayReference newArray = arrayType.newInstance(dimensions[i]);
                                ref.setValue(j, (Value)newArray);
                                arrays.add(newArray);
                            }
                        }
                    }
                }
                finally {
                    newObject.enableCollection();
                }
            }
            catch (Exception e) {
                throw new ParseException("Unable to create " + nameWithDimension + " instance");
            }
        }
        this.push(LValue.makeNewArray(newObject));
    }

    private final ArrayType getArrayType(String name, String componentType, int dimension, boolean primitive) throws ParseException {
        ReferenceType refType;
        List<ReferenceType> classes;
        block12: {
            classes = this.vm.classesByName(name);
            if (classes.size() == 0 && name.indexOf(46) == -1) {
                classes = LValue.getContextClass(this.vm, this.frameGetter, name);
            }
            if (classes.size() == 0 || classes.size() > 1) {
                classes = new ArrayList<ReferenceType>();
                try {
                    if (primitive) {
                        classes.add(ExpressionParser.loadClass(this.vm, this.frameGetter, this.getPrimitiveJniArray(componentType, dimension)));
                    } else {
                        classes.add(this.loadArrayClass(componentType, dimension));
                    }
                }
                catch (ParseException e) {
                    boolean throwException = true;
                    if (!primitive && componentType.indexOf(46) == -1) {
                        try {
                            classes.add(this.loadArrayClass("java.lang." + componentType, dimension));
                            throwException = false;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    if (!throwException) break block12;
                    throw e;
                }
            }
        }
        if (!((refType = classes.get(0)) instanceof ArrayType)) {
            throw new ParseException("Cannot create instance of non-array type" + name);
        }
        if (primitive) {
            StringBuilder readableName = new StringBuilder(componentType);
            for (int i = 1; i < dimension; ++i) {
                readableName.append('[').append(']');
                List<ReferenceType> tmpClasses = this.vm.classesByName(readableName.toString());
                if (tmpClasses.size() != 0) continue;
                String arrayName = this.getPrimitiveJniArray(componentType, dimension - 1);
                ExpressionParser.loadClass(this.vm, this.frameGetter, arrayName);
            }
        }
        return (ArrayType)refType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final ReferenceType loadClass(VirtualMachine vm, GetFrame frameGetter, String name) throws ParseException {
        Value loadedClass;
        List<ReferenceType> classes = vm.classesByName("java.lang.Class");
        if (classes.size() == 0) {
            throw new ParseException("No class named: java.lang.Class");
        }
        if (classes.size() > 1) {
            throw new ParseException("More than one class named: java.lang.Class");
        }
        ReferenceType refType = classes.get(0);
        if (!(refType instanceof ClassType)) {
            throw new ParseException("Class java.lang.Class is not a class");
        }
        ClassType clazz = (ClassType)refType;
        Method forName = clazz.concreteMethodByName("forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
        if (forName == null) {
            throw new ParseException("Method java.lang.Class.forName(...) not found");
        }
        StringReference className = vm.mirrorOf(name);
        className.disableCollection();
        try {
            BooleanValue trueValue = vm.mirrorOf(true);
            ArrayList<Value> arguments = new ArrayList<Value>();
            StackFrame frame = frameGetter.get();
            ClassLoaderReference loader = frame.location().method().declaringType().classLoader();
            ThreadReference thread = frame.thread();
            arguments.add(className);
            arguments.add(trueValue);
            arguments.add(loader);
            loadedClass = clazz.invokeMethod(thread, forName, arguments, 1);
        }
        catch (InvocationException e) {
            if (!"java.lang.ClassNotFoundException".equals(e.exception().referenceType().name())) throw new ParseException("Unable to complete expression. Exception " + e.exception() + " thrown");
            if (name.indexOf(46) != -1) throw new ParseException("No class named: " + name);
            String javaLangName = "java.lang." + name;
            try {
                ReferenceType frame = ExpressionParser.loadClass(vm, frameGetter, javaLangName);
                return frame;
            }
            catch (ParseException e1) {
                if (("No class named: " + javaLangName).equals(e1.getMessage())) throw new ParseException("No class named: " + name);
                throw e1;
            }
        }
        catch (IncompatibleThreadStateException itse) {
            throw new ParseException("Unable to complete expression. Thread not suspended for method invoke");
        }
        catch (InvalidTypeException ite) {
            throw new ParseException("Unable to complete expression. Method argument type mismatch");
        }
        catch (ClassNotLoadedException tnle) {
            throw new ParseException("Unable to complete expression. Method argument type " + tnle.className() + " not yet loaded");
        }
        finally {
            className.enableCollection();
        }
        if (loadedClass instanceof ClassObjectReference) return ((ClassObjectReference)loadedClass).reflectedType();
        throw new ParseException("Class loading failure for name: " + name);
    }

    private final ReferenceType loadArrayClass(String name, int dimension) throws ParseException {
        ReferenceType refType;
        String arrayClass = "java.lang.reflect.Array";
        List<ReferenceType> classes = this.vm.classesByName("java.lang.reflect.Array");
        if (classes.size() == 0 || classes.size() > 1) {
            classes = new ArrayList<ReferenceType>();
            classes.add(ExpressionParser.loadClass(this.vm, this.frameGetter, "java.lang.reflect.Array"));
        }
        if (!((refType = classes.get(0)) instanceof ClassType)) {
            throw new ParseException("Class java.lang.Array is not a class");
        }
        ClassType clazz = (ClassType)refType;
        Method newInstance = clazz.concreteMethodByName("newInstance", "(Ljava/lang/Class;I)Ljava/lang/Object;");
        if (newInstance == null) {
            throw new ParseException("Method java.lang.reflect.Array.newInstance(...) not found");
        }
        String className = name;
        Type loadedClass = null;
        for (int i = 0; i < dimension; ++i) {
            classes = this.vm.classesByName(className);
            if (classes.size() == 0 || classes.size() > 1) {
                classes = new ArrayList<ReferenceType>();
                if (i == 0) {
                    classes.add(ExpressionParser.loadClass(this.vm, this.frameGetter, className));
                } else {
                    classes.add((ReferenceType)loadedClass);
                }
            }
            refType = classes.get(0);
            ClassObjectReference component = refType.classObject();
            IntegerValue length = this.vm.mirrorOf(0);
            ArrayList<Value> arguments = new ArrayList<Value>();
            arguments.add(component);
            arguments.add(length);
            try {
                ThreadReference thread = this.frameGetter.get().thread();
                Value array = clazz.invokeMethod(thread, newInstance, arguments, 1);
                loadedClass = array.type();
            }
            catch (InvocationException e) {
                throw new ParseException("Unable to complete expression. Exception " + e.exception() + " thrown");
            }
            catch (IncompatibleThreadStateException itse) {
                throw new ParseException("Unable to complete expression. Thread not suspended for method invoke");
            }
            catch (InvalidTypeException ite) {
                throw new ParseException("Unable to complete expression. Method argument type mismatch");
            }
            catch (ClassNotLoadedException tnle) {
                throw new ParseException("Unable to complete expression. Method argument type " + tnle.className() + " not yet loaded");
            }
            className = className + "[]";
        }
        return (ReferenceType)loadedClass;
    }

    private final String getPrimitiveJniArray(String name, int dimension) throws ParseException {
        StringBuilder buffer = new StringBuilder(dimension + 1);
        for (int i = 0; i < dimension; ++i) {
            buffer.append('[');
        }
        buffer.append(this.getPrimitiveJniName(name));
        return buffer.toString();
    }

    private final char getPrimitiveJniName(String name) throws ParseException {
        if ("boolean".equals(name)) {
            return 'Z';
        }
        if ("byte".equals(name)) {
            return 'B';
        }
        if ("char".equals(name)) {
            return 'C';
        }
        if ("short".equals(name)) {
            return 'S';
        }
        if ("int".equals(name)) {
            return 'I';
        }
        if ("long".equals(name)) {
            return 'J';
        }
        if ("float".equals(name)) {
            return 'F';
        }
        if ("double".equals(name)) {
            return 'D';
        }
        throw new ParseException("Unknown primitive type: " + name);
    }

    static {
        ExpressionParser.jj_la1_init_0();
        ExpressionParser.jj_la1_init_1();
        ExpressionParser.jj_la1_init_2();
        ExpressionParser.jj_la1_init_3();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    public static interface GetFrame {
        public StackFrame get() throws IncompatibleThreadStateException;

        public Value getVisibleSyntheticVariableByName(StackFrame var1, String var2);
    }
}

