/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.example.debug.expr;

import com.sap.jvm.jdi.AbsentInformationException;
import com.sap.jvm.jdi.ArrayReference;
import com.sap.jvm.jdi.ArrayType;
import com.sap.jvm.jdi.BooleanType;
import com.sap.jvm.jdi.BooleanValue;
import com.sap.jvm.jdi.ByteValue;
import com.sap.jvm.jdi.CharValue;
import com.sap.jvm.jdi.ClassNotLoadedException;
import com.sap.jvm.jdi.ClassType;
import com.sap.jvm.jdi.DoubleValue;
import com.sap.jvm.jdi.Field;
import com.sap.jvm.jdi.FloatValue;
import com.sap.jvm.jdi.IncompatibleThreadStateException;
import com.sap.jvm.jdi.IntegerValue;
import com.sap.jvm.jdi.InterfaceType;
import com.sap.jvm.jdi.InvalidTypeException;
import com.sap.jvm.jdi.InvocationException;
import com.sap.jvm.jdi.LocalVariable;
import com.sap.jvm.jdi.LongValue;
import com.sap.jvm.jdi.Method;
import com.sap.jvm.jdi.ObjectReference;
import com.sap.jvm.jdi.PrimitiveType;
import com.sap.jvm.jdi.PrimitiveValue;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.ShortValue;
import com.sap.jvm.jdi.StackFrame;
import com.sap.jvm.jdi.StringReference;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.jdi.Type;
import com.sap.jvm.jdi.Value;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.tools.example.debug.expr.ExpressionParser;
import com.sap.jvm.tools.example.debug.expr.ParseException;
import com.sap.jvm.tools.example.debug.expr.Token;
import com.sap.jvm.tools.jdi.MethodImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

abstract class LValue {
    private static final boolean DO_AUTOBOX_ON_CALL = !"false".equals(System.getProperty("com.sap.jvm.debugging.doAutoboxOnCall"));
    protected Value jdiValue;
    static final int STATIC = 0;
    static final int INSTANCE = 1;
    static List<String> primitiveTypeNames = new ArrayList<String>();
    static final int SAME = 0;
    static final int ASSIGNABLE = 1;
    static final int DIFFERENT = 2;

    LValue() {
    }

    abstract Value getValue() throws InvocationException, IncompatibleThreadStateException, InvalidTypeException, ClassNotLoadedException, ParseException;

    abstract void setValue0(Value var1) throws ParseException, InvalidTypeException, ClassNotLoadedException;

    abstract void invokeWith(List<Value> var1) throws ParseException;

    void setValue(Value value) throws ParseException {
        try {
            this.setValue0(value);
        }
        catch (InvalidTypeException exc) {
            throw new ParseException("Attempt to set value of incorrect type" + exc);
        }
        catch (ClassNotLoadedException exc) {
            throw new ParseException("Attempt to set value before " + exc.className() + " was loaded" + exc);
        }
    }

    void setValue(LValue lval) throws ParseException {
        this.setValue(lval.interiorGetValue());
    }

    LValue memberLValue(ExpressionParser.GetFrame frameGetter, String fieldName) throws ParseException {
        try {
            return this.memberLValue(fieldName, frameGetter.get().thread(), frameGetter);
        }
        catch (IncompatibleThreadStateException exc) {
            throw new ParseException("Thread not suspended");
        }
    }

    LValue memberLValue(String fieldName, ThreadReference thread, ExpressionParser.GetFrame frameGetter) throws ParseException {
        Value val = this.interiorGetValue();
        if (val instanceof ArrayReference && "length".equals(fieldName)) {
            return new LValueArrayLength((ArrayReference)val);
        }
        return new LValueInstanceMember(val, fieldName, thread, frameGetter);
    }

    Value getMassagedValue(ExpressionParser.GetFrame frameGetter) throws ParseException {
        Value vv = this.interiorGetValue();
        if (vv instanceof ObjectReference && !(vv instanceof StringReference) && !(vv instanceof ArrayReference)) {
            StackFrame frame;
            try {
                frame = frameGetter.get();
            }
            catch (IncompatibleThreadStateException exc) {
                throw new ParseException("Thread not suspended");
            }
            ThreadReference thread = frame.thread();
            LValue toStringMember = this.memberLValue("toString", thread, frameGetter);
            toStringMember.invokeWith(new ArrayList<Value>());
            return toStringMember.interiorGetValue();
        }
        return vv;
    }

    Value interiorGetValue() throws ParseException {
        Value value;
        try {
            value = this.getValue();
        }
        catch (InvocationException e) {
            throw new ParseException("Unable to complete expression. Exception " + e.exception() + " thrown");
        }
        catch (IncompatibleThreadStateException itse) {
            throw new ParseException("Unable to complete expression. Thread not suspended for method invoke");
        }
        catch (InvalidTypeException ite) {
            throw new ParseException("Unable to complete expression. Method argument type mismatch");
        }
        catch (ClassNotLoadedException tnle) {
            throw new ParseException("Unable to complete expression. Method argument type " + tnle.className() + " not yet loaded");
        }
        return value;
    }

    LValue arrayElementLValue(LValue lval) throws ParseException {
        Value indexValue = lval.interiorGetValue();
        if (!(indexValue instanceof IntegerValue || indexValue instanceof ShortValue || indexValue instanceof ByteValue || indexValue instanceof CharValue)) {
            throw new ParseException("Array index must be a integer type");
        }
        int index = ((PrimitiveValue)indexValue).intValue();
        return new LValueArrayElement(this.interiorGetValue(), index);
    }

    public String toString() {
        try {
            return this.interiorGetValue().toString();
        }
        catch (ParseException e) {
            return "<Parse Exception>";
        }
    }

    static Field fieldByName(ReferenceType refType, String name, int kind) {
        Field field = refType.fieldByName(name);
        if (field != null) {
            boolean isStatic = field.isStatic();
            if (kind == 0 && !isStatic || kind == 1 && isStatic) {
                field = null;
            }
        }
        return field;
    }

    static List<Method> methodsByName(ReferenceType refType, String name, int kind) {
        List<Method> list = refType.methodsByName(name);
        Iterator<Method> iter = list.iterator();
        while (iter.hasNext()) {
            Method method = iter.next();
            boolean isStatic = method.isStatic();
            if ((kind != 0 || isStatic) && (kind != 1 || !isStatic)) continue;
            iter.remove();
        }
        return list;
    }

    static int argumentsMatch(List<Type> argTypes, List<Value> arguments) {
        if (argTypes.size() != arguments.size()) {
            return 2;
        }
        Iterator<Type> typeIter = argTypes.iterator();
        Iterator<Value> valIter = arguments.iterator();
        int result = 0;
        while (typeIter.hasNext()) {
            Type argType = typeIter.next();
            Value value = valIter.next();
            if (value == null && primitiveTypeNames.contains(argType.name())) {
                return 2;
            }
            if (value.type().equals(argType)) continue;
            if (LValue.isAssignableTo(value.type(), argType)) {
                result = 1;
                continue;
            }
            return 2;
        }
        return result;
    }

    static boolean isComponentAssignable(Type fromType, Type toType) {
        if (fromType instanceof PrimitiveType) {
            return fromType.equals(toType);
        }
        if (toType instanceof PrimitiveType) {
            return false;
        }
        return LValue.isAssignableTo(fromType, toType);
    }

    static boolean isArrayAssignableTo(ArrayType fromType, Type toType) {
        if (toType instanceof ArrayType) {
            try {
                Type toComponentType = ((ArrayType)toType).componentType();
                return LValue.isComponentAssignable(fromType.componentType(), toComponentType);
            }
            catch (ClassNotLoadedException e) {
                return false;
            }
        }
        if (toType instanceof InterfaceType) {
            return toType.name().equals("java.lang.Cloneable");
        }
        return toType.name().equals("java.lang.Object");
    }

    static boolean isAssignableTo(Type fromType, Type toType) {
        List<InterfaceType> interfaces;
        if (fromType.equals(toType)) {
            return true;
        }
        if (fromType instanceof BooleanType) {
            return toType instanceof BooleanType;
        }
        if (toType instanceof BooleanType) {
            return false;
        }
        if (fromType instanceof PrimitiveType) {
            return toType instanceof PrimitiveType;
        }
        if (toType instanceof PrimitiveType) {
            return false;
        }
        if (fromType instanceof ArrayType) {
            return LValue.isArrayAssignableTo((ArrayType)fromType, toType);
        }
        if (fromType instanceof ClassType) {
            ClassType superclazz = ((ClassType)fromType).superclass();
            if (superclazz != null && LValue.isAssignableTo(superclazz, toType)) {
                return true;
            }
            interfaces = ((ClassType)fromType).interfaces();
        } else {
            interfaces = ((InterfaceType)fromType).superinterfaces();
        }
        for (InterfaceType interfaze : interfaces) {
            if (!LValue.isAssignableTo(interfaze, toType)) continue;
            return true;
        }
        return false;
    }

    static Method resolveOverload(List<Method> overloads, List<Value> arguments) throws ParseException {
        if (overloads.size() == 1) {
            return overloads.get(0);
        }
        Method retVal = null;
        int assignableCount = 0;
        for (Method mm : overloads) {
            List<Type> argTypes;
            try {
                argTypes = mm.argumentTypes();
            }
            catch (ClassNotLoadedException ee) {
                continue;
            }
            int compare = LValue.argumentsMatch(argTypes, arguments);
            if (compare == 0) {
                return mm;
            }
            if (compare == 2) continue;
            retVal = mm;
            ++assignableCount;
        }
        if (retVal != null) {
            if (assignableCount == 1) {
                return retVal;
            }
            throw new ParseException("Arguments match multiple methods");
        }
        throw new ParseException("Arguments match no method");
    }

    static LValue make(VirtualMachine vm, boolean val) {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue make(VirtualMachine vm, byte val) {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue make(VirtualMachine vm, char val) {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue make(VirtualMachine vm, short val) {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue make(VirtualMachine vm, int val) {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue make(VirtualMachine vm, long val) {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue make(VirtualMachine vm, float val) {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue make(VirtualMachine vm, double val) {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue make(VirtualMachine vm, String val) throws ParseException {
        return new LValueConstant(vm.mirrorOf(val));
    }

    static LValue makeBoolean(VirtualMachine vm, Token token) {
        return LValue.make(vm, token.image.charAt(0) == 't');
    }

    static LValue makeCharacter(VirtualMachine vm, Token token) {
        return LValue.make(vm, token.image.charAt(1));
    }

    static LValue makeFloat(VirtualMachine vm, Token token) {
        if (token.image.endsWith("F") || token.image.endsWith("f")) {
            return LValue.make(vm, Float.valueOf(token.image).floatValue());
        }
        return LValue.makeDouble(vm, token);
    }

    static LValue makeDouble(VirtualMachine vm, Token token) {
        return LValue.make(vm, Double.valueOf(token.image));
    }

    static LValue makeInteger(VirtualMachine vm, Token token) {
        String image = token.image;
        if (image.endsWith("L") || image.endsWith("l")) {
            image = image.substring(0, image.length() - 1);
            return LValue.make(vm, Long.decode(image));
        }
        long longValue = Long.decode(image);
        int intValue = (int)longValue;
        if ((long)intValue == longValue) {
            return LValue.make(vm, intValue);
        }
        return LValue.make(vm, longValue);
    }

    static LValue makeShort(VirtualMachine vm, Token token) {
        return LValue.make(vm, Short.parseShort(token.image));
    }

    static LValue makeLong(VirtualMachine vm, Token token) {
        if (token.image.endsWith("L") || token.image.endsWith("l")) {
            if (token.image.startsWith("0x") || token.image.startsWith("0X")) {
                return LValue.make(vm, Long.parseLong(token.image.substring(2, token.image.length() - 1), 16));
            }
            return LValue.make(vm, Long.parseLong(token.image.substring(0, token.image.length() - 1)));
        }
        if (token.image.startsWith("0x") || token.image.startsWith("0X")) {
            return LValue.make(vm, Long.parseLong(token.image.substring(2), 16));
        }
        return LValue.make(vm, Long.parseLong(token.image));
    }

    static LValue makeByte(VirtualMachine vm, Token token) {
        return LValue.make(vm, Byte.parseByte(token.image));
    }

    static LValue makeString(VirtualMachine vm, Token token) throws ParseException {
        int len = token.image.length();
        return LValue.make(vm, token.image.substring(1, len - 1));
    }

    static LValue makeNull(VirtualMachine vm, Token token) throws ParseException {
        return new LValueConstant(null);
    }

    static LValue makeThisObject(VirtualMachine vm, ExpressionParser.GetFrame frameGetter, Token token) throws ParseException {
        if (frameGetter == null) {
            throw new ParseException("No current thread");
        }
        try {
            StackFrame frame = frameGetter.get();
            ObjectReference thisObject = frame.thisObject();
            if (thisObject == null) {
                throw new ParseException("No 'this'.  In native or static method");
            }
            return new LValueConstant(thisObject);
        }
        catch (IncompatibleThreadStateException exc) {
            throw new ParseException("Thread not suspended");
        }
    }

    static LValue makeNewObject(VirtualMachine vm, ExpressionParser.GetFrame frameGetter, String className, List<Value> arguments) throws ParseException {
        ObjectReference newObject;
        List<ReferenceType> classes = vm.classesByName(className);
        if (classes.size() == 0 && className.indexOf(46) == -1) {
            classes = LValue.getContextClass(vm, frameGetter, className);
        }
        if ((classes = LValue.loadClassIfNecessary(classes, vm, frameGetter, className)).size() == 0) {
            throw new ParseException("No class named: " + className);
        }
        if (classes.size() > 1) {
            throw new ParseException("More than one class named: " + className);
        }
        ReferenceType refType = classes.get(0);
        if (!(refType instanceof ClassType)) {
            throw new ParseException("Cannot create instance of interface " + className);
        }
        ClassType classType = (ClassType)refType;
        ArrayList<Method> methods = new ArrayList<Method>(classType.methods());
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Method method = (Method)iter.next();
            if (method.isConstructor()) continue;
            iter.remove();
        }
        Method constructor = LValue.resolveOverload(methods, arguments);
        try {
            ThreadReference thread = frameGetter.get().thread();
            newObject = classType.newInstance(thread, constructor, arguments, 1);
        }
        catch (InvocationException ie) {
            throw new ParseException("Exception in " + className + " constructor: " + ie.exception().referenceType().name());
        }
        catch (IncompatibleThreadStateException exc) {
            throw new ParseException("Thread not suspended");
        }
        catch (Exception e) {
            throw new ParseException("Unable to create " + className + " instance");
        }
        return new LValueConstant(newObject);
    }

    static LValue makeNewArray(ArrayReference array) {
        return new LValueConstant(array);
    }

    static LValue makeSuperName(VirtualMachine vm, ExpressionParser.GetFrame frameGetter, String name) throws ParseException {
        StringTokenizer izer = new StringTokenizer(name, ".");
        String first = izer.nextToken();
        if (frameGetter != null) {
            try {
                LValueInstanceMember fv;
                StackFrame frame = frameGetter.get();
                ThreadReference thread = frame.thread();
                ObjectReference thisObject = frame.thisObject();
                LValueConstant thisLValue = new LValueConstant(thisObject);
                try {
                    fv = new LValueInstanceMember(thisLValue.interiorGetValue(), first, thread, true, frameGetter);
                }
                catch (ParseException exc) {
                    fv = null;
                }
                if (fv != null) {
                    return LValue.nFields(fv, izer, thread, frameGetter);
                }
            }
            catch (IncompatibleThreadStateException exc) {
                throw new ParseException("Thread not suspended");
            }
        }
        throw new ParseException("Name unknown: " + name);
    }

    private static LValue nFields(LValue lval, StringTokenizer izer, ThreadReference thread, ExpressionParser.GetFrame frameGetter) throws ParseException {
        if (!izer.hasMoreTokens()) {
            return lval;
        }
        return LValue.nFields(lval.memberLValue(izer.nextToken(), thread, frameGetter), izer, thread, frameGetter);
    }

    static LValue makeName(VirtualMachine vm, ExpressionParser.GetFrame frameGetter, String name) throws ParseException {
        StringTokenizer izer = new StringTokenizer(name, ".");
        String first = izer.nextToken();
        if (frameGetter != null) {
            try {
                Value val;
                LocalVariable var;
                StackFrame frame = frameGetter.get();
                ThreadReference thread = frame.thread();
                try {
                    var = frame.visibleVariableByName(first);
                }
                catch (AbsentInformationException e) {
                    var = null;
                }
                if (var == null && (val = frameGetter.getVisibleSyntheticVariableByName(frame, first)) != null) {
                    return LValue.nFields(new LValueConstant(val), izer, thread, frameGetter);
                }
                if (var != null) {
                    return LValue.nFields(new LValueLocal(frameGetter, var), izer, thread, frameGetter);
                }
                ObjectReference thisObject = frame.thisObject();
                while (thisObject != null) {
                    LValueConstant thisLValue = new LValueConstant(thisObject);
                    LValue fv = null;
                    try {
                        fv = thisLValue.memberLValue(first, thread, frameGetter);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    if (fv != null) {
                        return LValue.nFields(fv, izer, thread, frameGetter);
                    }
                    String typeName = thisObject.referenceType().name();
                    if (thisObject.referenceType().isStatic() || typeName.lastIndexOf(36) < 0) break;
                    try {
                        fv = thisLValue.memberLValue("val$" + first, thread, frameGetter);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    if (fv != null) {
                        return LValue.nFields(fv, izer, thread, frameGetter);
                    }
                    String fieldName = null;
                    Field field = thisObject.referenceType().fieldByName("this$0");
                    if (field != null) {
                        fieldName = field.name();
                    } else {
                        for (Field f : thisObject.referenceType().fields()) {
                            if (!f.name().startsWith("this$")) continue;
                            fieldName = f.name();
                            break;
                        }
                        if (fieldName == null) break;
                    }
                    try {
                        fv = thisLValue.memberLValue(fieldName, thread, frameGetter);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    if (fv == null) break;
                    try {
                        thisObject = (ObjectReference)fv.getValue();
                    }
                    catch (ClassNotLoadedException classNotLoadedException) {
                        break;
                    }
                    catch (InvocationException invocationException) {
                        break;
                    }
                    catch (InvalidTypeException invalidTypeException) {
                        // empty catch block
                        break;
                    }
                }
                ReferenceType type = frame.location().declaringType();
                try {
                    LValueStaticMember lval = new LValueStaticMember(type, first, thread, frameGetter);
                    return LValue.nFields(lval, izer, thread, frameGetter);
                }
                catch (ParseException lval) {
                    String typeName = type.name();
                    int index = typeName.lastIndexOf(36);
                    while (index >= 0) {
                        typeName = typeName.substring(0, index);
                        for (ReferenceType outerType : vm.visibleClasses(type.classLoader())) {
                            if (!outerType.name().equals(typeName)) continue;
                            try {
                                LValueStaticMember lval2 = new LValueStaticMember(outerType, first, thread, frameGetter);
                                return LValue.nFields(lval2, izer, thread, frameGetter);
                            }
                            catch (ParseException lval2) {
                            }
                        }
                        index = typeName.lastIndexOf(36);
                    }
                    boolean firstIteration = true;
                    while (izer.hasMoreTokens()) {
                        List<ReferenceType> classes = vm.classesByName(first);
                        if (firstIteration && classes.size() == 0) {
                            classes = LValue.getContextClass(vm, frameGetter, first);
                        }
                        firstIteration = false;
                        if ((classes = LValue.loadClassIfNecessary(classes, vm, frameGetter, first)).size() > 0) {
                            if (classes.size() > 1) {
                                throw new ParseException("More than one class named: " + first);
                            }
                            ReferenceType refType = classes.get(0);
                            LValueStaticMember lval3 = new LValueStaticMember(refType, izer.nextToken(), thread, frameGetter);
                            return LValue.nFields(lval3, izer, thread, frameGetter);
                        }
                        first = first + '.' + izer.nextToken();
                    }
                }
            }
            catch (IncompatibleThreadStateException exc) {
                throw new ParseException("Thread not suspended");
            }
        }
        throw new ParseException("Name unknown: " + name);
    }

    static String stringValue(LValue lval, ExpressionParser.GetFrame frameGetter) throws ParseException {
        Value val = lval.getMassagedValue(frameGetter);
        if (val == null) {
            return "null";
        }
        if (val instanceof StringReference) {
            return ((StringReference)val).value();
        }
        return val.toString();
    }

    static LValue booleanOperation(VirtualMachine vm, Token token, LValue rightL, LValue leftL) throws ParseException {
        boolean res;
        String op = token.image;
        Value right = rightL.interiorGetValue();
        Value left = leftL.interiorGetValue();
        if (!(right instanceof PrimitiveValue) || !(left instanceof PrimitiveValue)) {
            if (op.equals("==")) {
                if (left == null || right == null) {
                    return LValue.make(vm, left == right);
                }
                return LValue.make(vm, right.equals(left));
            }
            if (op.equals("!=")) {
                if (left == null || right == null) {
                    return LValue.make(vm, left != right);
                }
                return LValue.make(vm, !right.equals(left));
            }
            throw new ParseException("Operands or '" + op + "' must be primitive");
        }
        double rr = ((PrimitiveValue)right).doubleValue();
        double ll = ((PrimitiveValue)left).doubleValue();
        if (op.equals("<")) {
            res = rr < ll;
        } else if (op.equals(">")) {
            res = rr > ll;
        } else if (op.equals("<=")) {
            res = rr <= ll;
        } else if (op.equals(">=")) {
            res = rr >= ll;
        } else if (op.equals("==")) {
            res = rr == ll;
        } else if (op.equals("!=")) {
            res = rr != ll;
        } else {
            throw new ParseException("Unknown operation: " + op);
        }
        return LValue.make(vm, res);
    }

    static LValue operation(VirtualMachine vm, Token token, LValue rightL, LValue leftL, ExpressionParser.GetFrame frameGetter) throws ParseException {
        int res;
        String op = token.image;
        Value right = rightL.interiorGetValue();
        Value left = leftL.interiorGetValue();
        if ((right instanceof StringReference || left instanceof StringReference) && op.equals("+")) {
            return LValue.make(vm, LValue.stringValue(rightL, frameGetter) + LValue.stringValue(leftL, frameGetter));
        }
        if (right instanceof ObjectReference || left instanceof ObjectReference) {
            if (op.equals("==")) {
                return LValue.make(vm, right.equals(left));
            }
            if (op.equals("!=")) {
                return LValue.make(vm, !right.equals(left));
            }
            throw new ParseException("Invalid operation '" + op + "' on an Object");
        }
        if (right instanceof BooleanValue || left instanceof BooleanValue) {
            throw new ParseException("Invalid operation '" + op + "' on a Boolean");
        }
        PrimitiveValue primRight = (PrimitiveValue)right;
        PrimitiveValue primLeft = (PrimitiveValue)left;
        if (primRight instanceof DoubleValue || primLeft instanceof DoubleValue) {
            double res2;
            double rr = primRight.doubleValue();
            double ll = primLeft.doubleValue();
            if (op.equals("+")) {
                res2 = rr + ll;
            } else if (op.equals("-")) {
                res2 = rr - ll;
            } else if (op.equals("*")) {
                res2 = rr * ll;
            } else if (op.equals("/")) {
                res2 = rr / ll;
            } else {
                throw new ParseException("Unknown operation: " + op);
            }
            return LValue.make(vm, res2);
        }
        if (primRight instanceof FloatValue || primLeft instanceof FloatValue) {
            float res3;
            float rr = primRight.floatValue();
            float ll = primLeft.floatValue();
            if (op.equals("+")) {
                res3 = rr + ll;
            } else if (op.equals("-")) {
                res3 = rr - ll;
            } else if (op.equals("*")) {
                res3 = rr * ll;
            } else if (op.equals("/")) {
                res3 = rr / ll;
            } else {
                throw new ParseException("Unknown operation: " + op);
            }
            return LValue.make(vm, res3);
        }
        if (primRight instanceof LongValue || primLeft instanceof LongValue) {
            long res4;
            long rr = primRight.longValue();
            long ll = primLeft.longValue();
            if (op.equals("+")) {
                res4 = rr + ll;
            } else if (op.equals("-")) {
                res4 = rr - ll;
            } else if (op.equals("*")) {
                res4 = rr * ll;
            } else if (op.equals("/")) {
                res4 = rr / ll;
            } else if (op.equals("|")) {
                res4 = rr | ll;
            } else if (op.equals("^")) {
                res4 = rr ^ ll;
            } else if (op.equals("&")) {
                res4 = rr & ll;
            } else if (op.equals("<<")) {
                res4 = rr << (int)ll;
            } else if (op.equals(">>")) {
                res4 = rr >> (int)ll;
            } else if (op.equals(">>>")) {
                res4 = rr >>> (int)ll;
            } else {
                throw new ParseException("Unknown operation: " + op);
            }
            return LValue.make(vm, res4);
        }
        int rr = primRight.intValue();
        int ll = primLeft.intValue();
        if (op.equals("+")) {
            res = rr + ll;
        } else if (op.equals("-")) {
            res = rr - ll;
        } else if (op.equals("*")) {
            res = rr * ll;
        } else if (op.equals("/")) {
            res = rr / ll;
        } else if (op.equals("|")) {
            res = rr | ll;
        } else if (op.equals("^")) {
            res = rr ^ ll;
        } else if (op.equals("&")) {
            res = rr & ll;
        } else if (op.equals("<<")) {
            res = rr << ll;
        } else if (op.equals(">>")) {
            res = rr >> ll;
        } else if (op.equals(">>>")) {
            res = rr >>> ll;
        } else {
            throw new ParseException("Unknown operation: " + op);
        }
        return LValue.make(vm, res);
    }

    static LValue operation(VirtualMachine vm, Token token, LValue rightL, ExpressionParser.GetFrame frameGetter) throws ParseException {
        int res;
        String op = token.image;
        Value right = rightL.interiorGetValue();
        if (right instanceof ObjectReference) {
            throw new ParseException("Invalid operation '" + op + "' on an Object");
        }
        if (right instanceof BooleanValue) {
            if (op.equals("!")) {
                boolean rr = ((BooleanValue)right).value();
                return LValue.make(vm, !rr);
            }
            throw new ParseException("Invalid operation '" + op + "' on a Boolean");
        }
        PrimitiveValue primRight = (PrimitiveValue)right;
        if (primRight instanceof DoubleValue) {
            double res2;
            double rr = primRight.doubleValue();
            if (op.equals("+")) {
                res2 = rr;
            } else if (op.equals("-")) {
                res2 = -rr;
            } else {
                throw new ParseException("Unknown operation: " + op);
            }
            return LValue.make(vm, res2);
        }
        if (primRight instanceof FloatValue) {
            float res3;
            float rr = primRight.floatValue();
            if (op.equals("+")) {
                res3 = rr;
            } else if (op.equals("-")) {
                res3 = -rr;
            } else {
                throw new ParseException("Unknown operation: " + op);
            }
            return LValue.make(vm, res3);
        }
        if (primRight instanceof LongValue) {
            long res4;
            long rr = primRight.longValue();
            if (op.equals("+")) {
                res4 = rr;
            } else if (op.equals("-")) {
                res4 = -rr;
            } else if (op.equals("~")) {
                res4 = rr ^ 0xFFFFFFFFFFFFFFFFL;
            } else {
                throw new ParseException("Unknown operation: " + op);
            }
            return LValue.make(vm, res4);
        }
        int rr = primRight.intValue();
        if (op.equals("+")) {
            res = rr;
        } else if (op.equals("-")) {
            res = -rr;
        } else if (op.equals("~")) {
            res = ~rr;
        } else {
            throw new ParseException("Unknown operation: " + op);
        }
        return LValue.make(vm, res);
    }

    static List<Value> autoboxMethodArgs(Method method, List<Value> methodArguments, ExpressionParser.GetFrame frame) {
        if (!DO_AUTOBOX_ON_CALL) {
            return methodArguments;
        }
        List<Value> result = methodArguments;
        MethodImpl methodImpl = (MethodImpl)method;
        List<String> signature = null;
        for (int i = 0; i < methodArguments.size(); ++i) {
            String arg;
            Value val = methodArguments.get(i);
            if (!(val instanceof PrimitiveValue)) continue;
            if (signature == null) {
                signature = methodImpl.argumentSignatures();
            }
            if ((arg = signature.get(i)).length() <= 1 || arg.charAt(0) == '[') continue;
            String boxedName = null;
            if (val instanceof BooleanValue) {
                if (arg.equals("Ljava/lang/Object;") || arg.equals("Ljava/lang/Boolean;") || arg.equals("Ljava/io/Serializable;") || arg.equals("Ljava/lang/Comparable;")) {
                    boxedName = "java.lang.Boolean";
                }
            } else if (val instanceof ByteValue) {
                if (arg.equals("Ljava/lang/Object;") || arg.equals("Ljava/lang/Byte;") || arg.equals("Ljava/io/Serializable;") || arg.equals("Ljava/lang/Comparable;") || arg.equals("Ljava/lang/Number;")) {
                    boxedName = "java.lang.Byte";
                }
            } else if (val instanceof ShortValue) {
                if (arg.equals("Ljava/lang/Object;") || arg.equals("Ljava/lang/Short;") || arg.equals("Ljava/io/Serializable;") || arg.equals("Ljava/lang/Comparable;") || arg.equals("Ljava/lang/Number;")) {
                    boxedName = "java.lang.Short";
                }
            } else if (val instanceof CharValue) {
                if (arg.equals("Ljava/lang/Object;") || arg.equals("Ljava/lang/Character;") || arg.equals("Ljava/io/Serializable;") || arg.equals("Ljava/lang/Comparable;")) {
                    boxedName = "java.lang.Character";
                }
            } else if (val instanceof IntegerValue) {
                if (arg.equals("Ljava/lang/Object;") || arg.equals("Ljava/lang/Integer;") || arg.equals("Ljava/io/Serializable;") || arg.equals("Ljava/lang/Comparable;") || arg.equals("Ljava/lang/Number;")) {
                    boxedName = "java.lang.Integer";
                }
            } else if (val instanceof LongValue) {
                if (arg.equals("Ljava/lang/Object;") || arg.equals("Ljava/lang/Long;") || arg.equals("Ljava/io/Serializable;") || arg.equals("Ljava/lang/Comparable;") || arg.equals("Ljava/lang/Number;")) {
                    boxedName = "java.lang.Long";
                }
            } else if (val instanceof FloatValue) {
                if (arg.equals("Ljava/lang/Object;") || arg.equals("Ljava/lang/Float;") || arg.equals("Ljava/io/Serializable;") || arg.equals("Ljava/lang/Comparable;") || arg.equals("Ljava/lang/Number;")) {
                    boxedName = "java.lang.Float";
                }
            } else if (val instanceof DoubleValue && (arg.equals("Ljava/lang/Object;") || arg.equals("Ljava/lang/Double;") || arg.equals("Ljava/io/Serializable;") || arg.equals("Ljava/lang/Comparable;") || arg.equals("Ljava/lang/Number;"))) {
                boxedName = "java.lang.Double";
            }
            if (boxedName == null) continue;
            ArrayList<Value> newResult = new ArrayList<Value>(result);
            ArrayList<Value> args = new ArrayList<Value>();
            args.add(val);
            try {
                LValue boxed = LValue.makeNewObject(method.virtualMachine(), frame, boxedName, args);
                newResult.set(i, boxed.getValue());
                result = newResult;
                continue;
            }
            catch (ParseException parseException) {
                continue;
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                continue;
            }
            catch (InvalidTypeException invalidTypeException) {
                continue;
            }
            catch (InvocationException invocationException) {
                continue;
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                // empty catch block
            }
        }
        return result;
    }

    static List<ReferenceType> getContextClass(VirtualMachine vm, ExpressionParser.GetFrame frameGetter, String shortName) {
        String contextName;
        int lastDot;
        String name = "java.lang." + shortName;
        List<ReferenceType> result = vm.classesByName(name);
        result = LValue.loadClassIfNecessary(result, vm, frameGetter, name);
        ReferenceType context = null;
        if (result.size() == 0) {
            try {
                context = frameGetter.get().location().declaringType();
                name = context.getFullNameFromContext(shortName);
                if (name != null) {
                    result = vm.classesByName(name);
                    result = LValue.loadClassIfNecessary(result, vm, frameGetter, name);
                }
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                // empty catch block
            }
        }
        if (result.size() == 0 && context != null && (lastDot = (contextName = context.name()).lastIndexOf(46)) > 0) {
            name = contextName.substring(0, lastDot + 1) + shortName;
            result = vm.classesByName(name);
            result = LValue.loadClassIfNecessary(result, vm, frameGetter, name);
        }
        return result;
    }

    private static List<ReferenceType> loadClassIfNecessary(List<ReferenceType> input, VirtualMachine vm, ExpressionParser.GetFrame frameGetter, String name) {
        if (input.size() == 0 || input.size() > 1) {
            try {
                ReferenceType clazz = ExpressionParser.loadClass(vm, frameGetter, name);
                ArrayList<ReferenceType> result = new ArrayList<ReferenceType>();
                result.add(clazz);
                return result;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return input;
    }

    static {
        primitiveTypeNames.add("boolean");
        primitiveTypeNames.add("byte");
        primitiveTypeNames.add("char");
        primitiveTypeNames.add("short");
        primitiveTypeNames.add("int");
        primitiveTypeNames.add("long");
        primitiveTypeNames.add("float");
        primitiveTypeNames.add("double");
    }

    private static class LValueConstant
    extends LValue {
        final Value value;

        LValueConstant(Value value) {
            this.value = value;
        }

        @Override
        Value getValue() {
            if (this.jdiValue == null) {
                this.jdiValue = this.value;
            }
            return this.jdiValue;
        }

        @Override
        void setValue0(Value val) throws ParseException {
            throw new ParseException("Cannot set constant: " + this.value);
        }

        @Override
        void invokeWith(List<Value> arguments) throws ParseException {
            throw new ParseException("Constant is not a method");
        }
    }

    private static class LValueArrayElement
    extends LValue {
        final ArrayReference array;
        final int index;

        LValueArrayElement(Value value, int index) throws ParseException {
            if (!(value instanceof ArrayReference)) {
                throw new ParseException("Must be array type: " + value);
            }
            this.array = (ArrayReference)value;
            this.index = index;
        }

        @Override
        Value getValue() {
            if (this.jdiValue == null) {
                this.jdiValue = this.array.getValue(this.index);
            }
            return this.jdiValue;
        }

        @Override
        void setValue0(Value val) throws InvalidTypeException, ClassNotLoadedException {
            this.array.setValue(this.index, val);
            this.jdiValue = val;
        }

        @Override
        void invokeWith(List<Value> arguments) throws ParseException {
            throw new ParseException("Array element is not a method");
        }
    }

    private static class LValueArrayLength
    extends LValue {
        final ArrayReference arrayRef;

        LValueArrayLength(ArrayReference value) {
            this.arrayRef = value;
        }

        @Override
        Value getValue() {
            if (this.jdiValue == null) {
                this.jdiValue = this.arrayRef.virtualMachine().mirrorOf(this.arrayRef.length());
            }
            return this.jdiValue;
        }

        @Override
        void setValue0(Value value) throws ParseException {
            throw new ParseException("Cannot set constant: " + value);
        }

        @Override
        void invokeWith(List<Value> arguments) throws ParseException {
            throw new ParseException("Array element is not a method");
        }
    }

    private static class LValueStaticMember
    extends LValue {
        final ExpressionParser.GetFrame frame;
        final ReferenceType refType;
        final ThreadReference thread;
        final Field matchingField;
        final List<Method> overloads;
        Method matchingMethod = null;
        List<Value> methodArguments = null;

        LValueStaticMember(ReferenceType refType, String memberName, ThreadReference thread, ExpressionParser.GetFrame frame) throws ParseException {
            this.refType = refType;
            this.thread = thread;
            this.frame = frame;
            this.matchingField = LValue.fieldByName(refType, memberName, 0);
            this.overloads = LValue.methodsByName(refType, memberName, 0);
            if (this.matchingField == null && this.overloads.size() == 0) {
                throw new ParseException("No static field or method with the name " + memberName + " in " + refType.name());
            }
        }

        @Override
        Value getValue() throws InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, ParseException {
            if (this.jdiValue != null) {
                return this.jdiValue;
            }
            if (this.matchingMethod == null) {
                if (this.matchingField == null) {
                    throw new ParseException("Not a static field");
                }
                this.jdiValue = this.refType.getValue(this.matchingField);
                return this.jdiValue;
            }
            if (this.refType instanceof ClassType) {
                ClassType clazz = (ClassType)this.refType;
                this.jdiValue = clazz.invokeMethod(this.thread, this.matchingMethod, LValueStaticMember.autoboxMethodArgs(this.matchingMethod, this.methodArguments, this.frame), 1);
                return this.jdiValue;
            }
            if (this.refType instanceof InterfaceType) {
                InterfaceType iface = (InterfaceType)this.refType;
                this.jdiValue = iface.invokeMethod(this.thread, this.matchingMethod, this.methodArguments, 0);
                return this.jdiValue;
            }
            throw new InvalidTypeException("Cannot invoke static method on " + this.refType.name());
        }

        @Override
        void setValue0(Value val) throws ParseException, InvalidTypeException, ClassNotLoadedException {
            if (this.matchingMethod != null) {
                throw new ParseException("Cannot assign to a method invocation");
            }
            if (!(this.refType instanceof ClassType)) {
                throw new ParseException("Cannot set interface field: " + this.refType);
            }
            ((ClassType)this.refType).setValue(this.matchingField, val);
            this.jdiValue = val;
        }

        @Override
        void invokeWith(List<Value> arguments) throws ParseException {
            if (this.matchingMethod != null) {
                throw new ParseException("Invalid consecutive invocations");
            }
            this.methodArguments = arguments;
            this.matchingMethod = LValue.resolveOverload(this.overloads, arguments);
        }
    }

    private static class LValueInstanceMember
    extends LValue {
        final ExpressionParser.GetFrame frame;
        final ObjectReference obj;
        final ThreadReference thread;
        final Field matchingField;
        final List<Method> overloads;
        Method matchingMethod = null;
        List<Value> methodArguments = null;

        LValueInstanceMember(Value value, String memberName, ThreadReference thread, ExpressionParser.GetFrame frame) throws ParseException {
            this(value, memberName, thread, false, frame);
        }

        LValueInstanceMember(Value value, String memberName, ThreadReference thread, boolean useSuperType, ExpressionParser.GetFrame frame) throws ParseException {
            if (!(value instanceof ObjectReference)) {
                throw new ParseException("Cannot access field of primitive type: " + value);
            }
            this.obj = (ObjectReference)value;
            this.thread = thread;
            this.frame = frame;
            ReferenceType refType = this.obj.referenceType();
            if (useSuperType && refType instanceof ClassType) {
                refType = ((ClassType)refType).superclass();
            }
            this.matchingField = LValue.fieldByName(refType, memberName, 1);
            this.overloads = LValue.methodsByName(refType, memberName, 1);
            if (this.matchingField == null && this.overloads.size() == 0) {
                throw new ParseException("No instance field or method with the name " + memberName + " in " + refType.name());
            }
        }

        @Override
        Value getValue() throws InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, ParseException {
            if (this.jdiValue != null) {
                return this.jdiValue;
            }
            if (this.matchingMethod == null) {
                if (this.matchingField == null) {
                    throw new ParseException("No such field in " + this.obj.referenceType().name());
                }
                this.jdiValue = this.obj.getValue(this.matchingField);
                return this.jdiValue;
            }
            this.jdiValue = this.obj.invokeMethod(this.thread, this.matchingMethod, LValueInstanceMember.autoboxMethodArgs(this.matchingMethod, this.methodArguments, this.frame), 1);
            return this.jdiValue;
        }

        @Override
        void setValue0(Value val) throws ParseException, InvalidTypeException, ClassNotLoadedException {
            if (this.matchingMethod != null) {
                throw new ParseException("Cannot assign to a method invocation");
            }
            this.obj.setValue(this.matchingField, val);
            this.jdiValue = val;
        }

        @Override
        void invokeWith(List<Value> arguments) throws ParseException {
            if (this.matchingMethod != null) {
                throw new ParseException("Invalid consecutive invocations");
            }
            this.methodArguments = arguments;
            this.matchingMethod = LValue.resolveOverload(this.overloads, arguments);
        }
    }

    private static class LValueLocal
    extends LValue {
        final ExpressionParser.GetFrame frame;
        final LocalVariable var;

        LValueLocal(ExpressionParser.GetFrame frame, LocalVariable var) {
            this.frame = frame;
            this.var = var;
        }

        @Override
        Value getValue() {
            if (this.jdiValue == null) {
                try {
                    this.jdiValue = this.frame.get().getValue(this.var);
                }
                catch (IncompatibleThreadStateException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.jdiValue;
        }

        @Override
        void setValue0(Value val) throws InvalidTypeException, ClassNotLoadedException {
            try {
                this.frame.get().setValue(this.var, val);
            }
            catch (IncompatibleThreadStateException e) {
                throw new RuntimeException(e);
            }
            this.jdiValue = val;
        }

        @Override
        void invokeWith(List<Value> arguments) throws ParseException {
            throw new ParseException(this.var.name() + " is not a method");
        }
    }
}

