/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.ArrayReference;
import com.sap.jvm.jdi.ClassNotLoadedException;
import com.sap.jvm.jdi.InvalidTypeException;
import com.sap.jvm.jdi.Method;
import com.sap.jvm.jdi.Type;
import com.sap.jvm.jdi.Value;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.tools.jdi.ArrayTypeImpl;
import com.sap.jvm.tools.jdi.ClassTypeImpl;
import com.sap.jvm.tools.jdi.JDWP;
import com.sap.jvm.tools.jdi.JDWPException;
import com.sap.jvm.tools.jdi.JNITypeParser;
import com.sap.jvm.tools.jdi.ObjectReferenceImpl;
import com.sap.jvm.tools.jdi.ValueContainer;
import com.sap.jvm.tools.jdi.ValueImpl;
import com.sap.jvm.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.List;

public class ArrayReferenceImpl
extends ObjectReferenceImpl
implements ArrayReference {
    int length = -1;

    ArrayReferenceImpl(VirtualMachine aVm, long aRef) {
        super(aVm, aRef);
    }

    @Override
    protected ClassTypeImpl invokableReferenceType(Method method) {
        return (ClassTypeImpl)method.declaringType();
    }

    ArrayTypeImpl arrayType() {
        return (ArrayTypeImpl)this.type();
    }

    @Override
    public int length() {
        if (this.length == -1) {
            try {
                this.length = JDWP.ArrayReference.Length.process((VirtualMachineImpl)this.vm, (ArrayReferenceImpl)this).arrayLength;
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.length;
    }

    @Override
    public Value getValue(int index) {
        List<Value> list = this.getValues(index, 1);
        return list.get(0);
    }

    @Override
    public List<Value> getValues() {
        return this.getValues(0, -1);
    }

    private void validateArrayAccess(int index, int length) {
        if (index < 0 || index > this.length()) {
            throw new IndexOutOfBoundsException("Invalid array index: " + index);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Invalid array range length: " + length);
        }
        if (index + length > this.length()) {
            throw new IndexOutOfBoundsException("Invalid array range: " + index + " to " + (index + length - 1));
        }
    }

    private static <T> T cast(Object x) {
        return (T)x;
    }

    @Override
    public List<Value> getValues(int index, int length) {
        List vals;
        if (length == -1) {
            length = this.length() - index;
        }
        this.validateArrayAccess(index, length);
        if (length == 0) {
            return new ArrayList<Value>();
        }
        try {
            vals = (List)ArrayReferenceImpl.cast(JDWP.ArrayReference.GetValues.process((VirtualMachineImpl)this.vm, (ArrayReferenceImpl)this, (int)index, (int)length).values);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return vals;
    }

    @Override
    public void setValue(int index, Value value) throws InvalidTypeException, ClassNotLoadedException {
        ArrayList<Value> list = new ArrayList<Value>(1);
        list.add(value);
        this.setValues(index, list, 0, 1);
    }

    @Override
    public void setValues(List<? extends Value> values) throws InvalidTypeException, ClassNotLoadedException {
        this.setValues(0, values, 0, -1);
    }

    @Override
    public void setValues(int index, List<? extends Value> values, int srcIndex, int length) throws InvalidTypeException, ClassNotLoadedException {
        if (length == -1) {
            length = Math.min(this.length() - index, values.size() - srcIndex);
        }
        this.validateMirrorsOrNulls(values);
        this.validateArrayAccess(index, length);
        if (srcIndex < 0 || srcIndex > values.size()) {
            throw new IndexOutOfBoundsException("Invalid source index: " + srcIndex);
        }
        if (srcIndex + length > values.size()) {
            throw new IndexOutOfBoundsException("Invalid source range: " + srcIndex + " to " + (srcIndex + length - 1));
        }
        boolean somethingToSet = false;
        ValueImpl[] setValues = new ValueImpl[length];
        for (int i = 0; i < length; ++i) {
            ValueImpl value = (ValueImpl)values.get(srcIndex + i);
            try {
                setValues[i] = ValueImpl.prepareForAssignment(value, new Component());
                somethingToSet = true;
                continue;
            }
            catch (ClassNotLoadedException e) {
                if (value == null) continue;
                throw e;
            }
        }
        if (somethingToSet) {
            try {
                JDWP.ArrayReference.SetValues.process(this.vm, this, index, setValues);
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
    }

    @Override
    public String toString() {
        return "instance of " + this.arrayType().componentTypeName() + "[" + this.length() + "] (id=" + this.uniqueID() + ")";
    }

    @Override
    byte typeValueKey() {
        return 91;
    }

    @Override
    void validateAssignment(ValueContainer destination) throws InvalidTypeException, ClassNotLoadedException {
        block3: {
            try {
                super.validateAssignment(destination);
            }
            catch (ClassNotLoadedException e) {
                boolean valid = false;
                JNITypeParser destParser = new JNITypeParser(destination.signature());
                JNITypeParser srcParser = new JNITypeParser(this.arrayType().signature());
                int destDims = destParser.dimensionCount();
                if (destDims <= srcParser.dimensionCount()) {
                    String destComponentSignature = destParser.componentSignature(destDims);
                    Type destComponentType = destination.findType(destComponentSignature);
                    String srcComponentSignature = srcParser.componentSignature(destDims);
                    Type srcComponentType = this.arrayType().findComponentType(srcComponentSignature);
                    valid = ArrayTypeImpl.isComponentAssignable(destComponentType, srcComponentType);
                }
                if (valid) break block3;
                throw new InvalidTypeException("Cannot assign " + this.arrayType().name() + " to " + destination.typeName());
            }
        }
    }

    class Component
    implements ValueContainer {
        Component() {
        }

        @Override
        public Type type() throws ClassNotLoadedException {
            return ArrayReferenceImpl.this.arrayType().componentType();
        }

        @Override
        public String typeName() {
            return ArrayReferenceImpl.this.arrayType().componentTypeName();
        }

        @Override
        public String signature() {
            return ArrayReferenceImpl.this.arrayType().componentSignature();
        }

        @Override
        public Type findType(String signature) throws ClassNotLoadedException {
            return ArrayReferenceImpl.this.arrayType().findComponentType(signature);
        }
    }
}

