/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.ClassLoaderReference;
import com.sap.jvm.jdi.ClassNotLoadedException;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.Type;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.tools.jdi.JDWP;
import com.sap.jvm.tools.jdi.JDWPException;
import com.sap.jvm.tools.jdi.JNITypeParser;
import com.sap.jvm.tools.jdi.ObjectReferenceImpl;
import com.sap.jvm.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClassLoaderReferenceImpl
extends ObjectReferenceImpl
implements ClassLoaderReference {
    @Override
    protected ObjectReferenceImpl.Cache newCache() {
        return new Cache();
    }

    ClassLoaderReferenceImpl(VirtualMachine aVm, long ref) {
        super(aVm, ref);
        this.vm.state().addListener(this);
    }

    @Override
    protected String description() {
        return "ClassLoaderReference " + this.uniqueID();
    }

    @Override
    public List<ReferenceType> definedClasses() {
        ArrayList<ReferenceType> definedClasses = new ArrayList<ReferenceType>();
        for (ReferenceType type : this.vm.allClasses()) {
            if (!type.isPrepared() || !this.equals(type.classLoader())) continue;
            definedClasses.add(type);
        }
        return definedClasses;
    }

    @Override
    public List<ReferenceType> visibleClasses() {
        List<ReferenceType> classes = null;
        try {
            Cache local = (Cache)this.getCache();
            if (local != null) {
                classes = local.visibleClasses;
            }
            if (classes == null) {
                JDWP.ClassLoaderReference.VisibleClasses.ClassInfo[] jdwpClasses = JDWP.ClassLoaderReference.VisibleClasses.process((VirtualMachineImpl)this.vm, (ClassLoaderReferenceImpl)this).classes;
                classes = new ArrayList<ReferenceType>(jdwpClasses.length);
                for (int i = 0; i < jdwpClasses.length; ++i) {
                    classes.add(this.vm.referenceType(jdwpClasses[i].typeID, jdwpClasses[i].refTypeTag));
                }
                classes = Collections.unmodifiableList(classes);
                if (local != null) {
                    local.visibleClasses = classes;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace(this.description() + " temporarily caching visible classes (count = " + classes.size() + ")");
                    }
                }
            }
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return classes;
    }

    Type findType(String signature) throws ClassNotLoadedException {
        List<ReferenceType> types = this.visibleClasses();
        for (ReferenceType type : types) {
            if (!type.signature().equals(signature)) continue;
            return type;
        }
        JNITypeParser parser = new JNITypeParser(signature);
        throw new ClassNotLoadedException(parser.typeName(), "Class " + parser.typeName() + " not loaded");
    }

    @Override
    byte typeValueKey() {
        return 108;
    }

    private static class Cache
    extends ObjectReferenceImpl.Cache {
        List<ReferenceType> visibleClasses = null;

        private Cache() {
        }
    }
}

