/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.FloatValue;
import com.sap.jvm.jdi.InvalidTypeException;
import com.sap.jvm.jdi.Type;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.tools.jdi.PrimitiveValueImpl;

public class FloatValueImpl
extends PrimitiveValueImpl
implements FloatValue {
    private float value;

    FloatValueImpl(VirtualMachine aVm, float aValue) {
        super(aVm);
        this.value = aValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof FloatValue) {
            return this.value == ((FloatValue)obj).value() && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.intValue();
    }

    @Override
    public int compareTo(FloatValue obj) {
        float other = obj.value();
        if (this.value() < other) {
            return -1;
        }
        if (this.value() == other) {
            return 0;
        }
        return 1;
    }

    @Override
    public Type type() {
        return this.vm.theFloatType();
    }

    @Override
    public float value() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return (double)this.value != 0.0;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public char charValue() {
        return (char)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > 127.0f || this.value < -128.0f) {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    @Override
    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535.0f || this.value < 0.0f) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    @Override
    short checkedShortValue() throws InvalidTypeException {
        if (this.value > 32767.0f || this.value < -32768.0f) {
            throw new InvalidTypeException("Can't convert " + this.value + " to short");
        }
        return super.checkedShortValue();
    }

    @Override
    int checkedIntValue() throws InvalidTypeException {
        int intValue = (int)this.value;
        if ((float)intValue != this.value) {
            throw new InvalidTypeException("Can't convert " + this.value + " to int");
        }
        return super.checkedIntValue();
    }

    @Override
    long checkedLongValue() throws InvalidTypeException {
        long longValue = (long)this.value;
        if ((float)longValue != this.value) {
            throw new InvalidTypeException("Can't convert " + this.value + " to long");
        }
        return super.checkedLongValue();
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    byte typeValueKey() {
        return 70;
    }
}

