/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.Bootstrap;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.jdi.connect.Connector;
import com.sap.jvm.jdi.connect.IllegalConnectorArgumentsException;
import com.sap.jvm.jdi.connect.ListeningConnector;
import com.sap.jvm.jdi.connect.Transport;
import com.sap.jvm.jdi.connect.spi.Connection;
import com.sap.jvm.jdi.connect.spi.TransportService;
import com.sap.jvm.tools.jdi.ConnectorImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GenericListeningConnector
extends ConnectorImpl
implements ListeningConnector {
    static final String ARG_ADDRESS = "address";
    static final String ARG_TIMEOUT = "timeout";
    Map<Map<String, ? extends Connector.Argument>, TransportService.ListenKey> listenMap;
    TransportService transportService;
    Transport transport;

    private GenericListeningConnector(TransportService ts, boolean addAddressArgument) {
        this.transportService = ts;
        this.transport = new Transport(){

            @Override
            public String name() {
                return GenericListeningConnector.this.transportService.name();
            }
        };
        if (addAddressArgument) {
            this.addStringArgument(ARG_ADDRESS, this.getString("generic_listening.address.label"), this.getString("generic_listening.address"), "", false);
        }
        this.addIntegerArgument(ARG_TIMEOUT, this.getString("generic_listening.timeout.label"), this.getString("generic_listening.timeout"), "", false, 0, Integer.MAX_VALUE);
        this.listenMap = new HashMap<Map<String, ? extends Connector.Argument>, TransportService.ListenKey>(10);
    }

    protected GenericListeningConnector(TransportService ts) {
        this(ts, false);
    }

    public static GenericListeningConnector create(TransportService ts) {
        return new GenericListeningConnector(ts, true);
    }

    public String startListening(String address, Map<String, ? extends Connector.Argument> args) throws IOException, IllegalConnectorArgumentsException {
        TransportService.ListenKey listener = this.listenMap.get(args);
        if (listener != null) {
            throw new IllegalConnectorArgumentsException("Already listening", new ArrayList<String>(args.keySet()));
        }
        listener = this.transportService.startListening(address);
        this.listenMap.put(args, listener);
        return listener.address();
    }

    @Override
    public String startListening(Map<String, ? extends Connector.Argument> args) throws IOException, IllegalConnectorArgumentsException {
        String address = this.argument(ARG_ADDRESS, args).value();
        return this.startListening(address, args);
    }

    @Override
    public void stopListening(Map<String, ? extends Connector.Argument> args) throws IOException, IllegalConnectorArgumentsException {
        TransportService.ListenKey listener = this.listenMap.get(args);
        if (listener == null) {
            throw new IllegalConnectorArgumentsException("Not listening", new ArrayList<String>(args.keySet()));
        }
        this.transportService.stopListening(listener);
        this.listenMap.remove(args);
    }

    @Override
    public VirtualMachine accept(Map<String, ? extends Connector.Argument> args) throws IOException, IllegalConnectorArgumentsException {
        Connection connection;
        TransportService.ListenKey listener;
        String ts = this.argument(ARG_TIMEOUT, args).value();
        int timeout = 0;
        if (ts.length() > 0) {
            timeout = Integer.decode(ts);
        }
        if ((listener = this.listenMap.get(args)) != null) {
            connection = this.transportService.accept(listener, timeout, 0L);
        } else {
            this.startListening(args);
            listener = this.listenMap.get(args);
            assert (listener != null);
            connection = this.transportService.accept(listener, timeout, 0L);
            this.stopListening(args);
        }
        return Bootstrap.virtualMachineManager().createVirtualMachine(connection);
    }

    @Override
    public boolean supportsMultipleConnections() {
        return this.transportService.capabilities().supportsMultipleConnections();
    }

    @Override
    public String name() {
        return this.transport.name() + "Listen";
    }

    @Override
    public String description() {
        return this.transportService.description();
    }

    @Override
    public Transport transport() {
        return this.transport;
    }
}

