/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.ClassNotLoadedException;
import com.sap.jvm.jdi.ClassType;
import com.sap.jvm.jdi.IncompatibleThreadStateException;
import com.sap.jvm.jdi.InterfaceType;
import com.sap.jvm.jdi.InvalidTypeException;
import com.sap.jvm.jdi.InvocationException;
import com.sap.jvm.jdi.Method;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.jdi.Value;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.tools.jdi.ClassTypeImpl;
import com.sap.jvm.tools.jdi.CommandSender;
import com.sap.jvm.tools.jdi.InterfaceTypeImpl;
import com.sap.jvm.tools.jdi.JDWPException;
import com.sap.jvm.tools.jdi.MethodImpl;
import com.sap.jvm.tools.jdi.ObjectReferenceImpl;
import com.sap.jvm.tools.jdi.PacketStream;
import com.sap.jvm.tools.jdi.ReferenceTypeImpl;
import com.sap.jvm.tools.jdi.ThreadReferenceImpl;
import com.sap.jvm.tools.jdi.ValueImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class InvokableTypeImpl
extends ReferenceTypeImpl {
    InvokableTypeImpl(VirtualMachine aVm, long aRef) {
        super(aVm, aRef);
    }

    public final Value invokeMethod(ThreadReference threadIntf, Method methodIntf, List<? extends Value> origArguments, int options) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        InvocationResult ret;
        this.validateMirror(threadIntf);
        this.validateMirror(methodIntf);
        this.validateMirrorsOrNulls(origArguments);
        MethodImpl method = (MethodImpl)methodIntf;
        ThreadReferenceImpl thread = (ThreadReferenceImpl)threadIntf;
        this.validateMethodInvocation(method);
        List<Value> arguments = method.validateAndPrepareArgumentsForInvoke(origArguments);
        ValueImpl[] args = arguments.toArray(new ValueImpl[0]);
        Thread currentThread = Thread.currentThread();
        String threadName = currentThread.getName();
        String nameWithAddons = threadName + " [calling method " + method + " with arguments " + arguments.toString() + "]";
        currentThread.setName(nameWithAddons);
        try {
            PacketStream stream = this.sendInvokeCommand(thread, method, args, options);
            ret = this.waitForReply(stream);
        }
        catch (JDWPException exc) {
            if (exc.errorCode() == 10) {
                throw new IncompatibleThreadStateException();
            }
            throw exc.toJDIException();
        }
        finally {
            currentThread.setName(threadName);
        }
        if ((options & 1) == 0) {
            this.vm.notifySuspend();
        }
        if (ret.getException() != null) {
            throw new InvocationException(ret.getException());
        }
        return ret.getResult();
    }

    @Override
    boolean isAssignableTo(ReferenceType type) {
        ClassTypeImpl superclazz = (ClassTypeImpl)this.superclass();
        if (this.equals(type)) {
            return true;
        }
        if (superclazz != null && superclazz.isAssignableTo(type)) {
            return true;
        }
        List<InterfaceType> interfaces = this.interfaces();
        for (InterfaceTypeImpl interfaceTypeImpl : interfaces) {
            if (!interfaceTypeImpl.isAssignableTo(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    final void addVisibleMethods(Map<String, Method> methodMap, Set<InterfaceType> seenInterfaces) {
        for (InterfaceTypeImpl interfaceTypeImpl : this.interfaces()) {
            if (seenInterfaces.contains(interfaceTypeImpl)) continue;
            interfaceTypeImpl.addVisibleMethods(methodMap, seenInterfaces);
            seenInterfaces.add(interfaceTypeImpl);
        }
        ClassTypeImpl classTypeImpl = (ClassTypeImpl)this.superclass();
        if (classTypeImpl != null) {
            classTypeImpl.addVisibleMethods(methodMap, seenInterfaces);
        }
        this.addToMethodMap(methodMap, this.methods());
    }

    final void addInterfaces(List<InterfaceType> list) {
        List<InterfaceType> immediate = this.interfaces();
        list.addAll(this.interfaces());
        for (InterfaceTypeImpl interfaceTypeImpl : immediate) {
            interfaceTypeImpl.addInterfaces(list);
        }
        ClassTypeImpl classTypeImpl = (ClassTypeImpl)this.superclass();
        if (classTypeImpl != null) {
            classTypeImpl.addInterfaces(list);
        }
    }

    final List<InterfaceType> getAllInterfaces() {
        ArrayList<InterfaceType> all = new ArrayList<InterfaceType>();
        this.addInterfaces(all);
        return all;
    }

    @Override
    public final List<Method> allMethods() {
        ArrayList<Method> list = new ArrayList<Method>(this.methods());
        for (ClassType clazz = this.superclass(); clazz != null; clazz = clazz.superclass()) {
            list.addAll(clazz.methods());
        }
        for (InterfaceType interfaze : this.getAllInterfaces()) {
            list.addAll(interfaze.methods());
        }
        return list;
    }

    final List<ReferenceType> inheritedTypes() {
        ArrayList<ReferenceType> inherited = new ArrayList<ReferenceType>();
        if (this.superclass() != null) {
            inherited.add(0, this.superclass());
        }
        for (ReferenceType referenceType : this.interfaces()) {
            inherited.add(referenceType);
        }
        return inherited;
    }

    private PacketStream sendInvokeCommand(ThreadReferenceImpl thread, MethodImpl method, ValueImpl[] args, int options) {
        if ((this.vm.traceFlags & 1) != 0) {
            for (ValueImpl arg : args) {
                arg.toString();
            }
        }
        CommandSender sender = this.getInvokeMethodSender(thread, method, args, options);
        PacketStream stream = (options & 1) != 0 ? thread.sendResumingCommand(sender) : this.vm.sendResumingCommand(sender);
        return stream;
    }

    private void validateMethodInvocation(Method method) throws InvalidTypeException, InvocationException {
        if (!this.canInvoke(method)) {
            throw new IllegalArgumentException("Invalid method");
        }
        if (!method.isStatic()) {
            throw new IllegalArgumentException("Cannot invoke instance method on a class/interface type");
        }
        if (method.isStaticInitializer()) {
            throw new IllegalArgumentException("Cannot invoke static initializer");
        }
    }

    abstract CommandSender getInvokeMethodSender(ThreadReferenceImpl var1, MethodImpl var2, ValueImpl[] var3, int var4);

    abstract InvocationResult waitForReply(PacketStream var1) throws JDWPException;

    abstract ClassType superclass();

    abstract List<InterfaceType> interfaces();

    abstract boolean canInvoke(Method var1);

    static interface InvocationResult {
        public ObjectReferenceImpl getException();

        public ValueImpl getResult();
    }
}

