/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.InvalidTypeException;
import com.sap.jvm.jdi.LongValue;
import com.sap.jvm.jdi.Type;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.tools.jdi.PrimitiveValueImpl;

public class LongValueImpl
extends PrimitiveValueImpl
implements LongValue {
    private long value;

    LongValueImpl(VirtualMachine aVm, long aValue) {
        super(aVm);
        this.value = aValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof LongValue) {
            return this.value == ((LongValue)obj).value() && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.intValue();
    }

    @Override
    public int compareTo(LongValue obj) {
        long other = obj.value();
        if (this.value() < other) {
            return -1;
        }
        if (this.value() == other) {
            return 0;
        }
        return 1;
    }

    @Override
    public Type type() {
        return this.vm.theLongType();
    }

    @Override
    public long value() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return this.value != 0L;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public char charValue() {
        return (char)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > 127L || this.value < -128L) {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    @Override
    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535L || this.value < 0L) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    @Override
    short checkedShortValue() throws InvalidTypeException {
        if (this.value > 32767L || this.value < -32768L) {
            throw new InvalidTypeException("Can't convert " + this.value + " to short");
        }
        return super.checkedShortValue();
    }

    @Override
    int checkedIntValue() throws InvalidTypeException {
        if (this.value > Integer.MAX_VALUE || this.value < Integer.MIN_VALUE) {
            throw new InvalidTypeException("Can't convert " + this.value + " to int");
        }
        return super.checkedIntValue();
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    byte typeValueKey() {
        return 74;
    }
}

