/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.Mirror;
import com.sap.jvm.jdi.VMMismatchException;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.tools.jdi.VirtualMachineImpl;
import java.util.Collection;

abstract class MirrorImpl
implements Mirror {
    protected VirtualMachineImpl vm;

    MirrorImpl(VirtualMachine aVm) {
        this.vm = (VirtualMachineImpl)aVm;
    }

    @Override
    public VirtualMachine virtualMachine() {
        return this.vm;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Mirror) {
            Mirror other = (Mirror)obj;
            return this.vm.equals(other.virtualMachine());
        }
        return false;
    }

    public int hashCode() {
        return this.vm.hashCode();
    }

    void validateMirror(Mirror mirror) {
        if (!this.vm.equals(mirror.virtualMachine())) {
            throw new VMMismatchException(mirror.toString());
        }
    }

    void validateMirrorOrNull(Mirror mirror) {
        if (mirror != null && !this.vm.equals(mirror.virtualMachine())) {
            throw new VMMismatchException(mirror.toString());
        }
    }

    void validateMirrors(Collection<? extends Mirror> mirrors) {
        for (MirrorImpl mirrorImpl : mirrors) {
            if (this.vm.equals(mirrorImpl.vm)) continue;
            throw new VMMismatchException(mirrorImpl.toString());
        }
    }

    void validateMirrorsOrNulls(Collection<? extends Mirror> mirrors) {
        for (MirrorImpl mirrorImpl : mirrors) {
            if (mirrorImpl == null || this.vm.equals(mirrorImpl.vm)) continue;
            throw new VMMismatchException(mirrorImpl.toString());
        }
    }
}

