/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.InternalException;
import com.sap.jvm.jdi.InvalidStackFrameException;
import com.sap.jvm.jdi.MonitorInfo;
import com.sap.jvm.jdi.ObjectReference;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.tools.jdi.MirrorImpl;
import com.sap.jvm.tools.jdi.ThreadAction;
import com.sap.jvm.tools.jdi.ThreadListener;
import com.sap.jvm.tools.jdi.ThreadReferenceImpl;
import com.sap.jvm.tools.jdi.VMState;

public class MonitorInfoImpl
extends MirrorImpl
implements MonitorInfo,
ThreadListener {
    private boolean isValid = true;
    ObjectReference monitor;
    ThreadReference thread;
    int stack_depth;

    MonitorInfoImpl(VirtualMachine vm, ObjectReference mon, ThreadReferenceImpl thread, int dpth) {
        super(vm);
        this.monitor = mon;
        this.thread = thread;
        this.stack_depth = dpth;
        thread.addListener(this);
    }

    @Override
    public boolean threadResumable(ThreadAction action) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            if (this.isValid) {
                this.isValid = false;
                return false;
            }
            throw new InternalException("Invalid stack frame thread listener");
        }
    }

    private void validateMonitorInfo() {
        if (!this.isValid) {
            throw new InvalidStackFrameException("Thread has been resumed");
        }
    }

    @Override
    public ObjectReference monitor() {
        this.validateMonitorInfo();
        return this.monitor;
    }

    @Override
    public int stackDepth() {
        this.validateMonitorInfo();
        return this.stack_depth;
    }

    @Override
    public ThreadReference thread() {
        this.validateMonitorInfo();
        return this.thread;
    }
}

