/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.BooleanValue;
import com.sap.jvm.jdi.ByteValue;
import com.sap.jvm.jdi.CharValue;
import com.sap.jvm.jdi.ClassType;
import com.sap.jvm.jdi.DoubleValue;
import com.sap.jvm.jdi.Field;
import com.sap.jvm.jdi.FloatValue;
import com.sap.jvm.jdi.IntegerValue;
import com.sap.jvm.jdi.InterfaceType;
import com.sap.jvm.jdi.InternalException;
import com.sap.jvm.jdi.InvalidTypeException;
import com.sap.jvm.jdi.Location;
import com.sap.jvm.jdi.LongValue;
import com.sap.jvm.jdi.ObjectReference;
import com.sap.jvm.jdi.PrimitiveValue;
import com.sap.jvm.jdi.ShortValue;
import com.sap.jvm.jdi.Value;
import com.sap.jvm.tools.jdi.ArrayReferenceImpl;
import com.sap.jvm.tools.jdi.BooleanValueImpl;
import com.sap.jvm.tools.jdi.ByteValueImpl;
import com.sap.jvm.tools.jdi.CharValueImpl;
import com.sap.jvm.tools.jdi.ClassLoaderReferenceImpl;
import com.sap.jvm.tools.jdi.ClassObjectReferenceImpl;
import com.sap.jvm.tools.jdi.DoubleValueImpl;
import com.sap.jvm.tools.jdi.FloatValueImpl;
import com.sap.jvm.tools.jdi.IntegerValueImpl;
import com.sap.jvm.tools.jdi.JDWPException;
import com.sap.jvm.tools.jdi.LocationImpl;
import com.sap.jvm.tools.jdi.LongValueImpl;
import com.sap.jvm.tools.jdi.MethodImpl;
import com.sap.jvm.tools.jdi.ModuleReferenceImpl;
import com.sap.jvm.tools.jdi.ObjectReferenceImpl;
import com.sap.jvm.tools.jdi.Packet;
import com.sap.jvm.tools.jdi.ReferenceTypeImpl;
import com.sap.jvm.tools.jdi.ShortValueImpl;
import com.sap.jvm.tools.jdi.StringReferenceImpl;
import com.sap.jvm.tools.jdi.ThreadGroupReferenceImpl;
import com.sap.jvm.tools.jdi.ThreadReferenceImpl;
import com.sap.jvm.tools.jdi.ValueImpl;
import com.sap.jvm.tools.jdi.VirtualMachineImpl;
import com.sap.jvm.tools.jdi.VoidValueImpl;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

class PacketStream {
    final VirtualMachineImpl vm;
    private int inCursor = 0;
    final Packet pkt;
    private ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
    private boolean isCommitted = false;

    PacketStream(VirtualMachineImpl vm, int cmdSet, int cmd) {
        this.vm = vm;
        this.pkt = new Packet();
        this.pkt.cmdSet = (short)cmdSet;
        this.pkt.cmd = (short)cmd;
    }

    PacketStream(VirtualMachineImpl vm, Packet pkt) {
        this.vm = vm;
        this.pkt = pkt;
        this.isCommitted = true;
    }

    int id() {
        return this.pkt.id;
    }

    void send() {
        if (!this.isCommitted) {
            this.pkt.data = this.dataStream.toByteArray();
            this.vm.sendToTarget(this.pkt);
            this.isCommitted = true;
        }
    }

    void waitForReply() throws JDWPException {
        if (!this.isCommitted) {
            throw new InternalException("waitForReply without send");
        }
        this.vm.waitForTargetReply(this.pkt);
        if (this.pkt.errorCode != 0) {
            throw new JDWPException(this.pkt.errorCode);
        }
    }

    void writeBoolean(boolean data) {
        if (data) {
            this.dataStream.write(1);
        } else {
            this.dataStream.write(0);
        }
    }

    void writeByte(byte data) {
        this.dataStream.write(data);
    }

    void writeChar(char data) {
        this.dataStream.write((byte)(data >>> 8 & 0xFF));
        this.dataStream.write((byte)(data >>> 0 & 0xFF));
    }

    void writeShort(short data) {
        this.dataStream.write((byte)(data >>> 8 & 0xFF));
        this.dataStream.write((byte)(data >>> 0 & 0xFF));
    }

    void writeInt(int data) {
        this.dataStream.write((byte)(data >>> 24 & 0xFF));
        this.dataStream.write((byte)(data >>> 16 & 0xFF));
        this.dataStream.write((byte)(data >>> 8 & 0xFF));
        this.dataStream.write((byte)(data >>> 0 & 0xFF));
    }

    void writeLong(long data) {
        this.dataStream.write((byte)(data >>> 56 & 0xFFL));
        this.dataStream.write((byte)(data >>> 48 & 0xFFL));
        this.dataStream.write((byte)(data >>> 40 & 0xFFL));
        this.dataStream.write((byte)(data >>> 32 & 0xFFL));
        this.dataStream.write((byte)(data >>> 24 & 0xFFL));
        this.dataStream.write((byte)(data >>> 16 & 0xFFL));
        this.dataStream.write((byte)(data >>> 8 & 0xFFL));
        this.dataStream.write((byte)(data >>> 0 & 0xFFL));
    }

    void writeFloat(float data) {
        this.writeInt(Float.floatToIntBits(data));
    }

    void writeDouble(double data) {
        this.writeLong(Double.doubleToLongBits(data));
    }

    void writeID(int size, long data) {
        switch (size) {
            case 8: {
                this.writeLong(data);
                break;
            }
            case 4: {
                this.writeInt((int)data);
                break;
            }
            case 2: {
                this.writeShort((short)data);
                break;
            }
            default: {
                throw new UnsupportedOperationException("JDWP: ID size not supported: " + size);
            }
        }
    }

    void writeNullObjectRef() {
        this.writeObjectRef(0L);
    }

    void writeObjectRef(long data) {
        this.writeID(this.vm.sizeofObjectRef, data);
    }

    void writeClassRef(long data) {
        this.writeID(this.vm.sizeofClassRef, data);
    }

    void writeMethodRef(long data) {
        this.writeID(this.vm.sizeofMethodRef, data);
    }

    void writeModuleRef(long data) {
        this.writeID(this.vm.sizeofModuleRef, data);
    }

    void writeFieldRef(long data) {
        this.writeID(this.vm.sizeofFieldRef, data);
    }

    void writeFrameRef(long data) {
        this.writeID(this.vm.sizeofFrameRef, data);
    }

    void writeByteArray(byte[] data) {
        this.dataStream.write(data, 0, data.length);
    }

    void writeString(String string) {
        try {
            byte[] stringBytes = string.getBytes("UTF8");
            this.writeInt(stringBytes.length);
            this.writeByteArray(stringBytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalException("Cannot convert string to UTF8 bytes");
        }
    }

    void writeLocation(Location location) {
        byte tag;
        ReferenceTypeImpl refType = (ReferenceTypeImpl)location.declaringType();
        if (refType instanceof ClassType) {
            tag = 1;
        } else if (refType instanceof InterfaceType) {
            tag = 2;
        } else {
            throw new InternalException("Invalid Location");
        }
        this.writeByte(tag);
        this.writeClassRef(refType.ref());
        this.writeMethodRef(((MethodImpl)location.method()).ref());
        this.writeLong(location.codeIndex());
    }

    void writeValue(Value val) {
        try {
            this.writeValueChecked(val);
        }
        catch (InvalidTypeException exc) {
            throw new RuntimeException("Internal error: Invalid Tag/Type pair");
        }
    }

    void writeValueChecked(Value val) throws InvalidTypeException {
        this.writeByte(ValueImpl.typeValueKey(val));
        this.writeUntaggedValue(val);
    }

    void writeUntaggedValue(Value val) {
        try {
            this.writeUntaggedValueChecked(val);
        }
        catch (InvalidTypeException exc) {
            throw new RuntimeException("Internal error: Invalid Tag/Type pair");
        }
    }

    void writeUntaggedValueChecked(Value val) throws InvalidTypeException {
        byte tag = ValueImpl.typeValueKey(val);
        if (PacketStream.isObjectTag(tag)) {
            if (val == null) {
                this.writeObjectRef(0L);
            } else {
                if (!(val instanceof ObjectReference)) {
                    throw new InvalidTypeException();
                }
                this.writeObjectRef(((ObjectReferenceImpl)val).ref());
            }
        } else {
            switch (tag) {
                case 66: {
                    if (!(val instanceof ByteValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeByte(((PrimitiveValue)val).byteValue());
                    break;
                }
                case 67: {
                    if (!(val instanceof CharValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeChar(((PrimitiveValue)val).charValue());
                    break;
                }
                case 70: {
                    if (!(val instanceof FloatValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeFloat(((PrimitiveValue)val).floatValue());
                    break;
                }
                case 68: {
                    if (!(val instanceof DoubleValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeDouble(((PrimitiveValue)val).doubleValue());
                    break;
                }
                case 73: {
                    if (!(val instanceof IntegerValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeInt(((PrimitiveValue)val).intValue());
                    break;
                }
                case 74: {
                    if (!(val instanceof LongValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeLong(((PrimitiveValue)val).longValue());
                    break;
                }
                case 83: {
                    if (!(val instanceof ShortValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeShort(((PrimitiveValue)val).shortValue());
                    break;
                }
                case 90: {
                    if (!(val instanceof BooleanValue)) {
                        throw new InvalidTypeException();
                    }
                    this.writeBoolean(((PrimitiveValue)val).booleanValue());
                }
            }
        }
    }

    byte readByte() {
        byte ret = this.pkt.data[this.inCursor];
        ++this.inCursor;
        return ret;
    }

    boolean readBoolean() {
        byte ret = this.readByte();
        return ret != 0;
    }

    char readChar() {
        int b1 = this.pkt.data[this.inCursor++] & 0xFF;
        int b2 = this.pkt.data[this.inCursor++] & 0xFF;
        return (char)((b1 << 8) + b2);
    }

    short readShort() {
        int b1 = this.pkt.data[this.inCursor++] & 0xFF;
        int b2 = this.pkt.data[this.inCursor++] & 0xFF;
        return (short)((b1 << 8) + b2);
    }

    int readInt() {
        int b1 = this.pkt.data[this.inCursor++] & 0xFF;
        int b2 = this.pkt.data[this.inCursor++] & 0xFF;
        int b3 = this.pkt.data[this.inCursor++] & 0xFF;
        int b4 = this.pkt.data[this.inCursor++] & 0xFF;
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    long readLong() {
        long b1 = this.pkt.data[this.inCursor++] & 0xFF;
        long b2 = this.pkt.data[this.inCursor++] & 0xFF;
        long b3 = this.pkt.data[this.inCursor++] & 0xFF;
        long b4 = this.pkt.data[this.inCursor++] & 0xFF;
        long b5 = this.pkt.data[this.inCursor++] & 0xFF;
        long b6 = this.pkt.data[this.inCursor++] & 0xFF;
        long b7 = this.pkt.data[this.inCursor++] & 0xFF;
        long b8 = this.pkt.data[this.inCursor++] & 0xFF;
        return (b1 << 56) + (b2 << 48) + (b3 << 40) + (b4 << 32) + (b5 << 24) + (b6 << 16) + (b7 << 8) + b8;
    }

    float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    String readString() {
        String ret;
        int len = this.readInt();
        try {
            ret = new String(this.pkt.data, this.inCursor, len, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e);
            ret = "Conversion error!";
        }
        this.inCursor += len;
        return ret;
    }

    private long readID(int size) {
        switch (size) {
            case 8: {
                return this.readLong();
            }
            case 4: {
                return this.readInt();
            }
            case 2: {
                return this.readShort();
            }
        }
        throw new UnsupportedOperationException("JDWP: ID size not supported: " + size);
    }

    long readObjectRef() {
        return this.readID(this.vm.sizeofObjectRef);
    }

    long readClassRef() {
        return this.readID(this.vm.sizeofClassRef);
    }

    ObjectReferenceImpl readTaggedObjectReference() {
        byte typeKey = this.readByte();
        return this.vm.objectMirror(this.readObjectRef(), typeKey);
    }

    ObjectReferenceImpl readObjectReference() {
        return this.vm.objectMirror(this.readObjectRef());
    }

    StringReferenceImpl readStringReference() {
        long ref = this.readObjectRef();
        return this.vm.stringMirror(ref);
    }

    ArrayReferenceImpl readArrayReference() {
        long ref = this.readObjectRef();
        return this.vm.arrayMirror(ref);
    }

    ThreadReferenceImpl readThreadReference() {
        long ref = this.readObjectRef();
        return this.vm.threadMirror(ref);
    }

    ThreadGroupReferenceImpl readThreadGroupReference() {
        long ref = this.readObjectRef();
        return this.vm.threadGroupMirror(ref);
    }

    ClassLoaderReferenceImpl readClassLoaderReference() {
        long ref = this.readObjectRef();
        return this.vm.classLoaderMirror(ref);
    }

    ClassObjectReferenceImpl readClassObjectReference() {
        long ref = this.readObjectRef();
        return this.vm.classObjectMirror(ref);
    }

    ReferenceTypeImpl readReferenceType() {
        byte tag = this.readByte();
        long ref = this.readObjectRef();
        return this.vm.referenceType(ref, tag);
    }

    ModuleReferenceImpl readModule() {
        long ref = this.readModuleRef();
        return this.vm.moduleMirror(ref);
    }

    long readMethodRef() {
        return this.readID(this.vm.sizeofMethodRef);
    }

    long readModuleRef() {
        return this.readID(this.vm.sizeofModuleRef);
    }

    long readFieldRef() {
        return this.readID(this.vm.sizeofFieldRef);
    }

    Field readField() {
        ReferenceTypeImpl refType = this.readReferenceType();
        long fieldRef = this.readFieldRef();
        return refType.getFieldMirror(fieldRef);
    }

    long readFrameRef() {
        return this.readID(this.vm.sizeofFrameRef);
    }

    ValueImpl readValue() {
        byte typeKey = this.readByte();
        return this.readUntaggedValue(typeKey);
    }

    ValueImpl readUntaggedValue(byte typeKey) {
        ValueImpl val = null;
        if (PacketStream.isObjectTag(typeKey)) {
            val = this.vm.objectMirror(this.readObjectRef(), typeKey);
        } else {
            switch (typeKey) {
                case 66: {
                    val = new ByteValueImpl(this.vm, this.readByte());
                    break;
                }
                case 67: {
                    val = new CharValueImpl(this.vm, this.readChar());
                    break;
                }
                case 70: {
                    val = new FloatValueImpl(this.vm, this.readFloat());
                    break;
                }
                case 68: {
                    val = new DoubleValueImpl(this.vm, this.readDouble());
                    break;
                }
                case 73: {
                    val = new IntegerValueImpl(this.vm, this.readInt());
                    break;
                }
                case 74: {
                    val = new LongValueImpl(this.vm, this.readLong());
                    break;
                }
                case 83: {
                    val = new ShortValueImpl(this.vm, this.readShort());
                    break;
                }
                case 90: {
                    val = new BooleanValueImpl(this.vm, this.readBoolean());
                    break;
                }
                case 86: {
                    val = new VoidValueImpl(this.vm);
                }
            }
        }
        return val;
    }

    Location readLocation() {
        byte tag = this.readByte();
        long classRef = this.readObjectRef();
        long methodRef = this.readMethodRef();
        long codeIndex = this.readLong();
        if (classRef != 0L) {
            ReferenceTypeImpl refType = this.vm.referenceType(classRef, tag);
            return new LocationImpl(this.vm, refType, methodRef, codeIndex);
        }
        return null;
    }

    byte[] readByteArray(int length) {
        byte[] array = new byte[length];
        System.arraycopy(this.pkt.data, this.inCursor, array, 0, length);
        this.inCursor += length;
        return array;
    }

    List<Value> readArrayRegion() {
        byte typeKey = this.readByte();
        int length = this.readInt();
        ArrayList<Value> list = new ArrayList<Value>(length);
        boolean gettingObjects = PacketStream.isObjectTag(typeKey);
        for (int i = 0; i < length; ++i) {
            if (gettingObjects) {
                typeKey = this.readByte();
            }
            ValueImpl value = this.readUntaggedValue(typeKey);
            list.add(value);
        }
        return list;
    }

    void writeArrayRegion(List<Value> srcValues) {
        this.writeInt(srcValues.size());
        for (int i = 0; i < srcValues.size(); ++i) {
            Value value = srcValues.get(i);
            this.writeUntaggedValue(value);
        }
    }

    int skipBytes(int n) {
        this.inCursor += n;
        return n;
    }

    byte command() {
        return (byte)this.pkt.cmd;
    }

    static boolean isObjectTag(byte tag) {
        return tag == 76 || tag == 91 || tag == 115 || tag == 116 || tag == 103 || tag == 108 || tag == 99;
    }
}

