/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.connect.Connector;
import com.sap.jvm.jdi.connect.IllegalConnectorArgumentsException;
import com.sap.jvm.jdi.connect.Transport;
import com.sap.jvm.tools.jdi.GenericListeningConnector;
import com.sap.jvm.tools.jdi.SocketTransportService;
import java.io.IOException;
import java.util.Map;

public class SocketListeningConnector
extends GenericListeningConnector {
    static final String ARG_PORT = "port";
    static final String ARG_LOCALADDR = "localAddress";

    public SocketListeningConnector() {
        super(new SocketTransportService());
        this.addIntegerArgument(ARG_PORT, this.getString("socket_listening.port.label"), this.getString("socket_listening.port"), "", false, 0, Integer.MAX_VALUE);
        this.addStringArgument(ARG_LOCALADDR, this.getString("socket_listening.localaddr.label"), this.getString("socket_listening.localaddr"), "", false);
        this.transport = new Transport(){

            @Override
            public String name() {
                return "dt_socket";
            }
        };
    }

    @Override
    public String startListening(Map<String, ? extends Connector.Argument> args) throws IOException, IllegalConnectorArgumentsException {
        String port = this.argument(ARG_PORT, args).value();
        String localaddr = this.argument(ARG_LOCALADDR, args).value();
        if (port.length() == 0) {
            port = "0";
        }
        localaddr = localaddr.length() > 0 ? localaddr + ":" + port : port;
        return super.startListening(localaddr, args);
    }

    @Override
    public String name() {
        return "com.sun.jdi.SocketListen";
    }

    @Override
    public String description() {
        return this.getString("socket_listening.description");
    }
}

