/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.connect.TransportTimeoutException;
import com.sap.jvm.jdi.connect.spi.Connection;
import com.sap.jvm.jdi.connect.spi.TransportService;
import com.sap.jvm.tools.jdi.SocketConnection;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ResourceBundle;

public class SocketTransportService
extends TransportService {
    private ResourceBundle messages = null;

    void handshake(Socket s, long timeout) throws IOException {
        int n;
        s.setSoTimeout((int)timeout);
        byte[] hello = "JDWP-Handshake".getBytes("UTF-8");
        s.getOutputStream().write(hello);
        byte[] b = new byte[hello.length];
        for (int received = 0; received < hello.length; received += n) {
            try {
                n = s.getInputStream().read(b, received, hello.length - received);
            }
            catch (SocketTimeoutException x) {
                throw new IOException("handshake timeout");
            }
            if (n >= 0) continue;
            s.close();
            throw new IOException("handshake failed - connection prematurally closed");
        }
        for (int i = 0; i < hello.length; ++i) {
            if (b[i] == hello[i]) continue;
            throw new IOException("handshake failed - unrecognized message from target VM");
        }
        s.setSoTimeout(0);
    }

    @Override
    public String name() {
        return "Socket";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String description() {
        SocketTransportService socketTransportService = this;
        synchronized (socketTransportService) {
            if (this.messages == null) {
                this.messages = ResourceBundle.getBundle("com.sap.jvm.tools.jdi.resources.jdi");
            }
        }
        return this.messages.getString("socket_transportservice.description");
    }

    @Override
    public TransportService.Capabilities capabilities() {
        return new TransportService.Capabilities(){

            @Override
            public boolean supportsMultipleConnections() {
                return true;
            }

            @Override
            public boolean supportsAttachTimeout() {
                return true;
            }

            @Override
            public boolean supportsAcceptTimeout() {
                return true;
            }

            @Override
            public boolean supportsHandshakeTimeout() {
                return true;
            }
        };
    }

    @Override
    public Connection attach(String address, long attachTimeout, long handshakeTimeout) throws IOException {
        int port;
        String portStr;
        String host;
        if (address == null) {
            throw new NullPointerException("address is null");
        }
        if (attachTimeout < 0L || handshakeTimeout < 0L) {
            throw new IllegalArgumentException("timeout is negative");
        }
        int splitIndex = address.indexOf(58);
        if (splitIndex < 0) {
            host = "localhost";
            portStr = address;
        } else {
            host = address.substring(0, splitIndex);
            portStr = address.substring(splitIndex + 1);
        }
        if (host.equals("*")) {
            host = InetAddress.getLocalHost().getHostName();
        }
        try {
            port = Integer.decode(portStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse port number in address");
        }
        InetSocketAddress sa = new InetSocketAddress(host, port);
        Socket s = new Socket();
        try {
            s.connect(sa, (int)attachTimeout);
        }
        catch (SocketTimeoutException exc) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new TransportTimeoutException("timed out trying to establish connection");
        }
        try {
            this.handshake(s, handshakeTimeout);
        }
        catch (IOException exc) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw exc;
        }
        return new SocketConnection(s);
    }

    TransportService.ListenKey startListening(String localaddress, int port) throws IOException {
        InetSocketAddress sa = localaddress == null ? new InetSocketAddress(port) : new InetSocketAddress(localaddress, port);
        ServerSocket ss = new ServerSocket();
        ss.bind(sa);
        return new SocketListenKey(ss);
    }

    @Override
    public TransportService.ListenKey startListening(String address) throws IOException {
        int port;
        if (address == null || address.length() == 0) {
            address = "0";
        }
        int splitIndex = address.indexOf(58);
        String localaddr = null;
        if (splitIndex >= 0) {
            localaddr = address.substring(0, splitIndex);
            address = address.substring(splitIndex + 1);
        }
        try {
            port = Integer.decode(address);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse port number in address");
        }
        return this.startListening(localaddr, port);
    }

    @Override
    public TransportService.ListenKey startListening() throws IOException {
        return this.startListening(null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopListening(TransportService.ListenKey listener) throws IOException {
        if (!(listener instanceof SocketListenKey)) {
            throw new IllegalArgumentException("Invalid listener");
        }
        TransportService.ListenKey listenKey = listener;
        synchronized (listenKey) {
            ServerSocket ss = ((SocketListenKey)listener).socket();
            if (ss.isClosed()) {
                throw new IllegalArgumentException("Invalid listener");
            }
            ss.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection accept(TransportService.ListenKey listener, long acceptTimeout, long handshakeTimeout) throws IOException {
        Socket s;
        ServerSocket ss;
        if (acceptTimeout < 0L || handshakeTimeout < 0L) {
            throw new IllegalArgumentException("timeout is negative");
        }
        if (!(listener instanceof SocketListenKey)) {
            throw new IllegalArgumentException("Invalid listener");
        }
        TransportService.ListenKey listenKey = listener;
        synchronized (listenKey) {
            ss = ((SocketListenKey)listener).socket();
            if (ss.isClosed()) {
                throw new IllegalArgumentException("Invalid listener");
            }
        }
        ss.setSoTimeout((int)acceptTimeout);
        try {
            s = ss.accept();
        }
        catch (SocketTimeoutException x) {
            throw new TransportTimeoutException("timeout waiting for connection");
        }
        this.handshake(s, handshakeTimeout);
        return new SocketConnection(s);
    }

    public String toString() {
        return this.name();
    }

    static class SocketListenKey
    extends TransportService.ListenKey {
        ServerSocket ss;

        SocketListenKey(ServerSocket ss) {
            this.ss = ss;
        }

        ServerSocket socket() {
            return this.ss;
        }

        @Override
        public String address() {
            String hostaddr;
            String hostname;
            InetAddress address = this.ss.getInetAddress();
            if (address.isAnyLocalAddress()) {
                try {
                    address = InetAddress.getLocalHost();
                }
                catch (UnknownHostException uhe) {
                    byte[] loopback = new byte[]{127, 0, 0, 1};
                    try {
                        address = InetAddress.getByAddress("127.0.0.1", loopback);
                    }
                    catch (UnknownHostException x) {
                        throw new InternalError("unable to get local hostname");
                    }
                }
            }
            String result = (hostname = address.getHostName()).equals(hostaddr = address.getHostAddress()) ? (address instanceof Inet6Address ? "[" + hostaddr + "]" : hostaddr) : hostname;
            return result + ":" + this.ss.getLocalPort();
        }

        public String toString() {
            return this.address();
        }
    }
}

