/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.AbsentInformationException;
import com.sap.jvm.jdi.ClassNotLoadedException;
import com.sap.jvm.jdi.IncompatibleThreadStateException;
import com.sap.jvm.jdi.InternalException;
import com.sap.jvm.jdi.InvalidStackFrameException;
import com.sap.jvm.jdi.InvalidTypeException;
import com.sap.jvm.jdi.LocalVariable;
import com.sap.jvm.jdi.Location;
import com.sap.jvm.jdi.ObjectReference;
import com.sap.jvm.jdi.StackFrame;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.jdi.Type;
import com.sap.jvm.jdi.Value;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.tools.jdi.CommandSender;
import com.sap.jvm.tools.jdi.JDWP;
import com.sap.jvm.tools.jdi.JDWPException;
import com.sap.jvm.tools.jdi.LocalVariableImpl;
import com.sap.jvm.tools.jdi.MethodImpl;
import com.sap.jvm.tools.jdi.MirrorImpl;
import com.sap.jvm.tools.jdi.PacketStream;
import com.sap.jvm.tools.jdi.ThreadAction;
import com.sap.jvm.tools.jdi.ThreadListener;
import com.sap.jvm.tools.jdi.ThreadReferenceImpl;
import com.sap.jvm.tools.jdi.VMState;
import com.sap.jvm.tools.jdi.ValueImpl;
import com.sap.jvm.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StackFrameImpl
extends MirrorImpl
implements StackFrame,
ThreadListener {
    private boolean isValid = true;
    private final ThreadReferenceImpl thread;
    private final long id;
    private final Location location;
    private Map<String, LocalVariable> visibleVariables = null;
    private ObjectReference thisObject = null;

    StackFrameImpl(VirtualMachine vm, ThreadReferenceImpl thread, long id, Location location) {
        super(vm);
        this.thread = thread;
        this.id = id;
        this.location = location;
        thread.addListener(this);
    }

    @Override
    public boolean threadResumable(ThreadAction action) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            if (this.isValid) {
                this.isValid = false;
                return false;
            }
            throw new InternalException("Invalid stack frame thread listener");
        }
    }

    void validateStackFrame() {
        if (!this.isValid) {
            throw new InvalidStackFrameException("Thread has been resumed");
        }
    }

    @Override
    public Location location() {
        this.validateStackFrame();
        return this.location;
    }

    @Override
    public ThreadReference thread() {
        this.validateStackFrame();
        return this.thread;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof StackFrameImpl) {
            StackFrameImpl other = (StackFrameImpl)obj;
            return this.id == other.id && this.thread().equals(other.thread()) && this.location().equals(other.location()) && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (this.thread().hashCode() << 4) + (int)this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectReference thisObject() {
        this.validateStackFrame();
        MethodImpl currentMethod = (MethodImpl)this.location.method();
        if (currentMethod.isStatic() || currentMethod.isNative()) {
            return null;
        }
        if (this.thisObject == null) {
            PacketStream ps;
            VMState vMState = this.vm.state();
            synchronized (vMState) {
                this.validateStackFrame();
                ps = JDWP.StackFrame.ThisObject.enqueueCommand(this.vm, this.thread, this.id);
            }
            try {
                this.thisObject = JDWP.StackFrame.ThisObject.waitForReply((VirtualMachineImpl)this.vm, (PacketStream)ps).objectThis;
            }
            catch (JDWPException exc) {
                switch (exc.errorCode()) {
                    case 10: 
                    case 13: 
                    case 30: {
                        throw new InvalidStackFrameException();
                    }
                }
                throw exc.toJDIException();
            }
        }
        return this.thisObject;
    }

    private void createVisibleVariables() throws AbsentInformationException {
        if (this.visibleVariables == null) {
            List<LocalVariable> allVariables = this.location.method().variables();
            HashMap<String, LocalVariable> map = new HashMap<String, LocalVariable>(allVariables.size());
            for (LocalVariable variable : allVariables) {
                LocalVariable existing;
                String name = variable.name();
                if (!variable.isVisible(this) || (existing = (LocalVariable)map.get(name)) != null && !((LocalVariableImpl)variable).hides(existing)) continue;
                map.put(name, variable);
            }
            this.visibleVariables = map;
        }
    }

    @Override
    public List<LocalVariable> visibleVariables() throws AbsentInformationException {
        this.validateStackFrame();
        this.createVisibleVariables();
        ArrayList<LocalVariable> mapAsList = new ArrayList<LocalVariable>(this.visibleVariables.values());
        Collections.sort(mapAsList);
        return mapAsList;
    }

    @Override
    public LocalVariable visibleVariableByName(String name) throws AbsentInformationException {
        this.validateStackFrame();
        this.createVisibleVariables();
        return this.visibleVariables.get(name);
    }

    @Override
    public Value getValue(LocalVariable variable) {
        ArrayList<LocalVariable> list = new ArrayList<LocalVariable>(1);
        list.add(variable);
        return this.getValues(list).get(variable);
    }

    @Override
    public Value getStackValue(int slot, Type type) {
        HashMap<Integer, Type> map = new HashMap<Integer, Type>();
        map.put(slot, type);
        return this.getStackValues(map).get(slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<LocalVariable, Value> getValues(List<? extends LocalVariable> variables) {
        ValueImpl[] values;
        PacketStream ps;
        Object variable;
        this.validateStackFrame();
        this.validateMirrors(variables);
        int count = variables.size();
        JDWP.StackFrame.GetValues.SlotInfo[] slots = new JDWP.StackFrame.GetValues.SlotInfo[count];
        for (int i = 0; i < count; ++i) {
            variable = (LocalVariableImpl)variables.get(i);
            if (!((LocalVariableImpl)variable).isVisible(this)) {
                throw new IllegalArgumentException(((LocalVariableImpl)variable).name() + " is not valid at this frame location");
            }
            slots[i] = new JDWP.StackFrame.GetValues.SlotInfo(((LocalVariableImpl)variable).slot(), (byte)((LocalVariableImpl)variable).signature().charAt(0));
        }
        variable = this.vm.state();
        synchronized (variable) {
            this.validateStackFrame();
            ps = JDWP.StackFrame.GetValues.enqueueCommand(this.vm, this.thread, this.id, slots);
        }
        try {
            values = JDWP.StackFrame.GetValues.waitForReply((VirtualMachineImpl)this.vm, (PacketStream)ps).values;
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 10: 
                case 13: 
                case 30: {
                    throw new InvalidStackFrameException();
                }
                case 35: {
                    if (variables.size() == 1) {
                        return new HashMap<LocalVariable, Value>();
                    }
                    HashMap<LocalVariable, Value> result = new HashMap<LocalVariable, Value>();
                    for (LocalVariable localVariable : variables) {
                        ArrayList<LocalVariable> l = new ArrayList<LocalVariable>();
                        l.add(localVariable);
                        for (Map.Entry<LocalVariable, Value> toAdd : this.getValues(l).entrySet()) {
                            result.put(toAdd.getKey(), toAdd.getValue());
                        }
                    }
                    return result;
                }
            }
            throw exc.toJDIException();
        }
        if (count != values.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        HashMap<LocalVariable, Value> map = new HashMap<LocalVariable, Value>(count);
        for (int i = 0; i < count; ++i) {
            LocalVariableImpl variable2 = (LocalVariableImpl)variables.get(i);
            map.put(variable2, values[i]);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, Value> getStackValues(Map<Integer, Type> stackValues) {
        ValueImpl[] values;
        PacketStream ps;
        this.validateStackFrame();
        int count = stackValues.size();
        byte[] typeTags = new byte[count];
        int[] slots = new int[count];
        int i = 0;
        Iterator<Integer> iterator = stackValues.keySet().iterator();
        while (iterator.hasNext()) {
            int slot;
            slots[i] = slot = iterator.next().intValue();
            typeTags[i] = (byte)stackValues.get(slot).signature().charAt(0);
        }
        VMState slot = this.vm.state();
        synchronized (slot) {
            this.validateStackFrame();
            ps = JDWP.SapExtensions.GetStackValues.enqueueCommand(this.vm, this.thread, slots, typeTags);
        }
        try {
            values = JDWP.SapExtensions.GetStackValues.waitForReply((VirtualMachineImpl)this.vm, (PacketStream)ps).values;
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 10: 
                case 13: 
                case 30: {
                    throw new InvalidStackFrameException();
                }
            }
            throw exc.toJDIException();
        }
        if (count != values.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        HashMap<Integer, Value> map = new HashMap<Integer, Value>(count);
        for (i = 0; i < count; ++i) {
            map.put(slots[i], values[i]);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(LocalVariable variableIntf, Value valueIntf) throws InvalidTypeException, ClassNotLoadedException {
        block11: {
            this.validateStackFrame();
            this.validateMirror(variableIntf);
            this.validateMirrorOrNull(valueIntf);
            LocalVariableImpl variable = (LocalVariableImpl)variableIntf;
            ValueImpl value = (ValueImpl)valueIntf;
            if (!variable.isVisible(this)) {
                throw new IllegalArgumentException(variable.name() + " is not valid at this frame location");
            }
            try {
                PacketStream ps;
                value = ValueImpl.prepareForAssignment(value, variable);
                JDWP.StackFrame.SetValues.SlotInfo[] slotVals = new JDWP.StackFrame.SetValues.SlotInfo[]{new JDWP.StackFrame.SetValues.SlotInfo(variable.slot(), value)};
                VMState vMState = this.vm.state();
                synchronized (vMState) {
                    this.validateStackFrame();
                    ps = JDWP.StackFrame.SetValues.enqueueCommand(this.vm, this.thread, this.id, slotVals);
                }
                try {
                    JDWP.StackFrame.SetValues.waitForReply(this.vm, ps);
                }
                catch (JDWPException exc) {
                    switch (exc.errorCode()) {
                        case 10: 
                        case 13: 
                        case 30: {
                            throw new InvalidStackFrameException();
                        }
                    }
                    throw exc.toJDIException();
                }
            }
            catch (ClassNotLoadedException e) {
                if (value == null) break block11;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Value> getArgumentValues() {
        ValueImpl[] values;
        PacketStream ps;
        this.validateStackFrame();
        MethodImpl mmm = (MethodImpl)this.location.method();
        List<String> argSigs = mmm.argumentSignatures();
        int count = argSigs.size();
        JDWP.StackFrame.GetValues.SlotInfo[] slots = new JDWP.StackFrame.GetValues.SlotInfo[count];
        int slot = mmm.isStatic() ? 0 : 1;
        for (int ii = 0; ii < count; ++ii) {
            char sigChar = argSigs.get(ii).charAt(0);
            slots[ii] = new JDWP.StackFrame.GetValues.SlotInfo(slot++, (byte)sigChar);
            if (sigChar != 'J' && sigChar != 'D') continue;
            ++slot;
        }
        VMState sigChar = this.vm.state();
        synchronized (sigChar) {
            this.validateStackFrame();
            ps = JDWP.StackFrame.GetValues.enqueueCommand(this.vm, this.thread, this.id, slots);
        }
        try {
            values = JDWP.StackFrame.GetValues.waitForReply((VirtualMachineImpl)this.vm, (PacketStream)ps).values;
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 10: 
                case 13: 
                case 30: {
                    throw new InvalidStackFrameException();
                }
            }
            throw exc.toJDIException();
        }
        if (count != values.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        return Arrays.asList((Value[])values);
    }

    void pop() throws IncompatibleThreadStateException {
        this.validateStackFrame();
        CommandSender sender = new CommandSender(){

            @Override
            public PacketStream send() {
                return JDWP.StackFrame.PopFrames.enqueueCommand(StackFrameImpl.this.vm, StackFrameImpl.this.thread, StackFrameImpl.this.id);
            }
        };
        try {
            PacketStream stream = this.thread.sendResumingCommand(sender);
            JDWP.StackFrame.PopFrames.waitForReply(this.vm, stream);
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 13: {
                    throw new IncompatibleThreadStateException("Thread not current or suspended");
                }
                case 10: {
                    throw new IncompatibleThreadStateException("zombie");
                }
                case 31: {
                    throw new InvalidStackFrameException("No more frames on the stack");
                }
            }
            throw exc.toJDIException();
        }
        this.vm.state().freeze();
    }

    @Override
    public String toString() {
        return this.location.toString() + " in thread " + this.thread.toString();
    }
}

