/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.tools.jdi.StackTrackerEntry;
import java.util.HashMap;
import java.util.Iterator;

public class StackTracker
implements Iterable<StackTrackerEntry> {
    HashMap<StackTrackerEntry, StackTrackerEntry> entries = new HashMap();
    private final int stackDepth;
    private final long methodId;

    public StackTracker() {
        this(-1L, -1);
    }

    public StackTracker(long methodId, int stackDepth) {
        this.methodId = methodId;
        this.stackDepth = stackDepth;
    }

    public long getMethodId() {
        return this.methodId;
    }

    public int getStackDepth() {
        return this.stackDepth;
    }

    public int getMaxBci() {
        return 0;
    }

    public void add(StackTrackerEntry entry) {
        this.entries.put(entry, entry);
    }

    public StackTrackerEntry get(int bci, int slot) {
        return this.entries.get(new StackTrackerEntry(bci, "V", slot));
    }

    public int getNrOfEntries() {
        return this.entries.size();
    }

    @Override
    public Iterator<StackTrackerEntry> iterator() {
        return this.entries.values().iterator();
    }
}

